/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.encoder.EncoderBase;
import com.github.loki4j.common.LogRecord;
import com.github.loki4j.logback.Loki4jEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

public abstract class AbstractLoki4jEncoder
extends EncoderBase<LogRecord[]>
implements Loki4jEncoder {
    private static final byte[] ZERO_BYTES = new byte[0];
    protected static final Comparator<LogRecord> byTime = (e1, e2) -> {
        int tsCmp = Long.compare(e1.timestampMs, e2.timestampMs);
        return tsCmp == 0 ? Integer.compare(e1.nanos, e2.nanos) : tsCmp;
    };
    protected static final Comparator<LogRecord> byStream = (e1, e2) -> String.CASE_INSENSITIVE_ORDER.compare(e1.stream, e2.stream);
    protected final Charset charset = Charset.forName("UTF-8");
    private LabelCfg label = new LabelCfg();
    private MessageCfg message = new MessageCfg();
    private boolean sortByTime = false;
    private boolean staticLabels = false;
    private PatternLayout labelPatternLayout;
    private PatternLayout messagePatternLayout;
    private final AtomicInteger nanoCounter = new AtomicInteger(0);

    public void start() {
        Object labelPattern = this.label.nopex ? this.label.pattern + "%nopex" : this.label.pattern;
        this.labelPatternLayout = this.initPatternLayout((String)labelPattern);
        this.labelPatternLayout.start();
        this.messagePatternLayout = this.initPatternLayout(this.message.pattern);
        this.messagePatternLayout.start();
        super.start();
    }

    public void stop() {
        super.stop();
        this.messagePatternLayout.stop();
        this.labelPatternLayout.stop();
    }

    @Override
    public LogRecord eventToRecord(ILoggingEvent e, LogRecord r) {
        r.timestampMs = e.getTimeStamp();
        r.nanos = this.nanoCounter.updateAndGet(i -> i < 999999 ? i + 1 : 0);
        r.stream = this.labelPatternLayout.doLayout(e).intern();
        r.streamHashCode = r.stream.hashCode();
        r.message = this.messagePatternLayout.doLayout(e);
        return r;
    }

    public byte[] headerBytes() {
        return ZERO_BYTES;
    }

    public byte[] footerBytes() {
        return ZERO_BYTES;
    }

    public byte[] encode(LogRecord[] batch) {
        if (batch.length < 1) {
            return ZERO_BYTES;
        }
        if (this.staticLabels) {
            if (this.sortByTime) {
                Arrays.sort(batch, byTime);
            }
            return this.encodeStaticLabels(batch);
        }
        Comparator<LogRecord> comp = this.sortByTime ? byStream.thenComparing(byTime) : byStream;
        Arrays.sort(batch, comp);
        return this.encodeDynamicLabels(batch);
    }

    protected abstract byte[] encodeStaticLabels(LogRecord[] var1);

    protected abstract byte[] encodeDynamicLabels(LogRecord[] var1);

    private PatternLayout initPatternLayout(String pattern) {
        PatternLayout patternLayout = new PatternLayout();
        patternLayout.setContext(this.context);
        patternLayout.setPattern(pattern);
        return patternLayout;
    }

    protected String[] extractStreamKVPairs(String stream) {
        String[] pairs = stream.split(Pattern.quote(this.label.pairSeparator));
        String[] result = new String[pairs.length * 2];
        for (int i = 0; i < pairs.length; ++i) {
            String[] kv = pairs[i].split(Pattern.quote(this.label.keyValueSeparator));
            if (kv.length != 2) {
                throw new IllegalArgumentException(String.format("Unable to split '%s' in '%s' to label key-value pairs, pairSeparator=%s, keyValueSeparator=%s", pairs[i], stream, this.label.pairSeparator, this.label.keyValueSeparator));
            }
            result[i * 2] = kv[0];
            result[i * 2 + 1] = kv[1];
        }
        return result;
    }

    public void setLabel(LabelCfg label) {
        this.label = label;
    }

    public void setMessage(MessageCfg message) {
        this.message = message;
    }

    public void setSortByTime(boolean sortByTime) {
        this.sortByTime = sortByTime;
    }

    public void setStaticLabels(boolean staticLabels) {
        this.staticLabels = staticLabels;
    }

    public static final class MessageCfg {
        String pattern = "l=%level c=%logger{20} t=%thread | %msg %ex";

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }
    }

    public static final class LabelCfg {
        String pattern = "host=${HOSTNAME},level=%level";
        String pairSeparator = ",";
        String keyValueSeparator = "=";
        boolean nopex = true;

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public void setKeyValueSeparator(String keyValueSeparator) {
            this.keyValueSeparator = keyValueSeparator;
        }

        public void setPairSeparator(String pairSeparator) {
            this.pairSeparator = pairSeparator;
        }

        public void setNopex(boolean nopex) {
            this.nopex = nopex;
        }
    }
}

