/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.status.StatusListener;
import com.github.loki4j.common.ConcurrentBatchBuffer;
import com.github.loki4j.common.LogRecord;
import com.github.loki4j.logback.JsonEncoder;
import com.github.loki4j.logback.Loki4jEncoder;
import com.github.loki4j.logback.LokiThreadFactory;
import com.github.loki4j.logback.StatusPrinter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class AbstractLoki4jAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final LogRecord[] ZERO_EVENTS = new LogRecord[0];
    protected String url = "http://localhost:3100/loki/api/v1/push";
    protected long connectionTimeoutMs = 30000L;
    protected long requestTimeoutMs = 5000L;
    private int batchSize = 1000;
    private long batchTimeoutMs = 60000L;
    private int processingThreads = 1;
    private int httpThreads = 1;
    private boolean verbose = false;
    private Loki4jEncoder encoder;
    private ConcurrentBatchBuffer<ILoggingEvent, LogRecord> buffer;
    private ScheduledExecutorService scheduler;
    protected ExecutorService httpThreadPool;

    public final void start() {
        if (this.getStatusManager() != null && this.getStatusManager().getCopyOfStatusListenerList().isEmpty()) {
            StatusPrinter statusListener = new StatusPrinter(this.verbose ? 0 : 1);
            statusListener.setContext(this.getContext());
            statusListener.start();
            this.getStatusManager().add((StatusListener)statusListener);
        }
        this.addInfo(String.format("Starting with procThreads=%s, batchSize=%s, batchTimeout=%s...", this.processingThreads, this.batchSize, this.batchTimeoutMs));
        if (this.encoder == null) {
            this.addWarn("No encoder specified. Switching to default encoder");
            this.encoder = new JsonEncoder();
        }
        this.encoder.setContext(this.context);
        this.encoder.start();
        this.buffer = new ConcurrentBatchBuffer<ILoggingEvent, LogRecord>(this.batchSize, LogRecord::create, (e, r) -> this.encoder.eventToRecord((ILoggingEvent)e, (LogRecord)r));
        this.scheduler = Executors.newScheduledThreadPool(this.processingThreads, new LokiThreadFactory("loki-scheduler"));
        this.httpThreadPool = Executors.newFixedThreadPool(this.httpThreads, new LokiThreadFactory("loki-http-sender"));
        this.startHttp(this.encoder.getContentType());
        super.start();
        this.scheduler.scheduleAtFixedRate(() -> this.drainAsync(this.batchTimeoutMs - 20L), 100L, this.batchTimeoutMs, TimeUnit.MILLISECONDS);
        this.addInfo("Successfully started");
    }

    public final void stop() {
        if (!super.isStarted()) {
            return;
        }
        this.addInfo("Stopping...");
        super.stop();
        try {
            this.drainAsync(0L).get(500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            this.addWarn("Error during buffer drain on stop", e);
        }
        this.encoder.stop();
        this.scheduler.shutdown();
        this.httpThreadPool.shutdown();
        this.stopHttp();
        this.addInfo("Successfully stopped");
    }

    protected void append(ILoggingEvent event) {
        try {
            event.prepareForDeferredProcessing();
        }
        catch (RuntimeException e) {
            this.addWarn("Unable to prepare the event for deferred processing", e);
        }
        LogRecord[] batch = this.buffer.add(event, (LogRecord[])ZERO_EVENTS);
        if (batch.length > 0) {
            this.handleBatchAsync(batch);
        }
    }

    protected abstract void startHttp(String var1);

    protected abstract void stopHttp();

    protected abstract CompletableFuture<LokiResponse> sendAsync(byte[] var1);

    private CompletableFuture<Void> drainAsync(long timeoutMs) {
        LogRecord[] batch = this.buffer.drain(timeoutMs, (LogRecord[])ZERO_EVENTS);
        if (batch.length > 0) {
            return this.handleBatchAsync(batch).thenApply(r -> null);
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<LokiResponse> handleBatchAsync(LogRecord[] batch) {
        long batchId = System.nanoTime();
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            byte[] body = this.encoder.encode(batch);
            this.addInfo(String.format(">>> Batch #%x: Sending %,d items converted to %,d bytes", batchId, batch.length, body.length));
            return body;
        }, this.scheduler).thenCompose(this::sendAsync)).whenComplete((r, e) -> {
            if (e != null) {
                this.addError(String.format("Error while sending Batch #%x (%s records) to Loki (%s)", batchId, batch.length, this.url), (Throwable)e);
            } else if (r.status < 200 || r.status > 299) {
                this.addError(String.format("Loki responded with non-success status %s on Batch #%x (%s records). Error: %s", r.status, batchId, batch.length, r.body));
            } else {
                this.addInfo(String.format("<<< Batch #%x: Loki responded with status %s", batchId, r.status));
            }
        });
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setConnectionTimeoutMs(long connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
    }

    public void setRequestTimeoutMs(long requestTimeoutMs) {
        this.requestTimeoutMs = requestTimeoutMs;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public long getBatchTimeoutMs() {
        return this.batchTimeoutMs;
    }

    public void setBatchTimeoutMs(long batchTimeoutMs) {
        this.batchTimeoutMs = batchTimeoutMs;
    }

    public void setEncoder(Loki4jEncoder encoder) {
        this.encoder = encoder;
    }

    public void setProcessingThreads(int processingThreads) {
        this.processingThreads = processingThreads;
    }

    public int getHttpThreads() {
        return this.httpThreads;
    }

    public void setHttpThreads(int httpThreads) {
        this.httpThreads = httpThreads;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    static final class LokiResponse {
        public int status;
        public String body;

        public LokiResponse(int status, String body) {
            this.status = status;
            this.body = body;
        }
    }
}

