/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.common;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class ConcurrentBatchBuffer<I, E> {
    private final Object[] items;
    private int index;
    private final ReentrantLock lock;
    private long lastBatchTime;
    private Supplier<E> factory;
    private BiFunction<I, E, E> transformer;

    public ConcurrentBatchBuffer(int capacity, Supplier<E> factory, BiFunction<I, E, E> transformer) {
        if (capacity < 1) {
            throw new IllegalArgumentException("The capacity of the buffer should be at least 1 element");
        }
        this.index = 0;
        this.lastBatchTime = System.currentTimeMillis();
        this.factory = factory;
        this.transformer = transformer;
        this.lock = new ReentrantLock(false);
        this.items = new Object[capacity];
        this.initItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E[] add(I input, E[] zeroSizeArray) {
        Objects.requireNonNull(input);
        Object[] batch = zeroSizeArray;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] items = this.items;
            items[this.index] = Objects.requireNonNull(this.transformer.apply(input, items[this.index]));
            if (++this.index == items.length) {
                batch = Arrays.copyOf(items, items.length, zeroSizeArray.getClass());
                this.index = 0;
                this.lastBatchTime = System.currentTimeMillis();
                this.initItems();
            }
        }
        finally {
            lock.unlock();
        }
        return batch;
    }

    public E[] drain(long timeoutMs, E[] zeroSizeArray) {
        Object[] batch = zeroSizeArray;
        long now = System.currentTimeMillis();
        ReentrantLock lock = this.lock;
        lock.lock();
        if (this.index > 0 && now - this.lastBatchTime > timeoutMs) {
            batch = Arrays.copyOf(this.items, this.index, zeroSizeArray.getClass());
            this.index = 0;
            this.lastBatchTime = System.currentTimeMillis();
            this.initItems();
        }
        lock.unlock();
        return batch;
    }

    public int getCapacity() {
        return this.items.length;
    }

    private void initItems() {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = this.factory.get();
        }
    }
}

