/*
 * Decompiled with CFR 0.152.
 */
package org.liveSense.service.securityManager;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserResourceChangeListener {
    private static final Logger log = LoggerFactory.getLogger(UserResourceChangeListener.class);
    public static final String USER_GENERATE_TOPIC = "org/liveSense/user/generate";
    public static final String USER_REMOVE_TOPIC = "org/liveSense/user/remove";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    private SlingRepository repository;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    private EventAdmin eventAdmin;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    ResourceResolverFactory resourceResolverFactory;
    Session session;
    private final ArrayList<PathEventListener> eventListeners = new ArrayList();
    private ObservationManager observationManager;

    protected void activate(ComponentContext componentContext) throws RepositoryException {
        this.session = this.repository.loginAdministrative("security");
        if (this.repository.getDescriptor("option.observation.supported").equals("true")) {
            this.observationManager = this.session.getWorkspace().getObservationManager();
            String[] nodeType = new String[]{"rep:User"};
            PathEventListener listener = new PathEventListener();
            this.eventListeners.add(listener);
            this.observationManager.addEventListener((EventListener)listener, 62, "/rep:security/rep:authorizables/", true, null, nodeType, true);
        }
    }

    public void deactivate(ComponentContext componentContext) throws RepositoryException {
        if (this.observationManager != null) {
            for (PathEventListener listener : this.eventListeners) {
                this.observationManager.removeEventListener((EventListener)listener);
            }
        }
        if (this.session != null && this.session.isLive()) {
            this.session.logout();
        }
    }

    class PathEventListener
    implements EventListener {
        PathEventListener() {
        }

        private void generateJobEvent(String userName) {
            log.info("> Create user create event event.job.topic org/liveSense/user/generate for " + userName);
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("event.job.topic", UserResourceChangeListener.USER_GENERATE_TOPIC);
            ((Dictionary)props).put("userName", userName);
            org.osgi.service.event.Event createUserJob = new org.osgi.service.event.Event("org/apache/sling/event/job", props);
            UserResourceChangeListener.this.eventAdmin.sendEvent(createUserJob);
        }

        private void removeJobEvent(String userName) {
            log.info("> Create user remove event event.job.topic org/liveSense/user/remove for " + userName);
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("event.job.topic", UserResourceChangeListener.USER_REMOVE_TOPIC);
            ((Dictionary)props).put("userName", userName);
            org.osgi.service.event.Event removeUserJob = new org.osgi.service.event.Event("org/apache/sling/event/job", props);
            UserResourceChangeListener.this.eventAdmin.sendEvent(removeUserJob);
        }

        public void onEvent(EventIterator it) {
            while (it.hasNext()) {
                Event event = it.nextEvent();
                try {
                    log.info("userChanged: " + event.getType() + " " + event.getPath());
                    String[] pathParts = event.getPath().split("/");
                    if (event.getType() == 1) {
                        this.generateJobEvent(pathParts[pathParts.length - 1]);
                    } else if (event.getType() == 2) {
                        this.removeJobEvent(pathParts[pathParts.length - 1]);
                    }
                    if (event.getType() != 4 || !event.getPath().endsWith("/jcr:primaryType")) continue;
                    this.generateJobEvent(pathParts[pathParts.length - 2]);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

