/*
 * Decompiled with CFR 0.152.
 */
package org.liveSense.service.securityManager;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.security.principal.EveryonePrincipal;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.liveSense.core.Configurator;
import org.liveSense.core.PasswordDigester;
import org.liveSense.core.wrapper.GenericValue;
import org.liveSense.service.securityManager.AccessRights;
import org.liveSense.service.securityManager.AccessRightsImpl;
import org.liveSense.service.securityManager.PrivilegeFromSerializable;
import org.liveSense.service.securityManager.SecurityManagerService;
import org.liveSense.service.securityManager.SerializablePrivilege;
import org.liveSense.service.securityManager.exceptions.GroupAlreadyExistsException;
import org.liveSense.service.securityManager.exceptions.GroupNotExistsException;
import org.liveSense.service.securityManager.exceptions.InternalException;
import org.liveSense.service.securityManager.exceptions.PrincipalIsNotGroupException;
import org.liveSense.service.securityManager.exceptions.PrincipalIsNotUserException;
import org.liveSense.service.securityManager.exceptions.PrincipalNotExistsException;
import org.liveSense.service.securityManager.exceptions.UserAlreadyExistsException;
import org.liveSense.service.securityManager.exceptions.UserNotExistsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="%service.name", description="%service.description", immediate=true)
@Service(value={SecurityManagerService.class})
public class SecurityManagerServiceImpl
implements SecurityManagerService {
    private final Logger log = LoggerFactory.getLogger(SecurityManagerServiceImpl.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    private SlingRepository repository;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    Configurator configurator;

    @Override
    public SlingRepository getRepository() throws RepositoryException {
        if (this.repository == null) {
            throw new RepositoryException("Repository is null");
        }
        return this.repository;
    }

    @Override
    public User addUser(Session session, String userName, String password, Map<String, Object> properties) throws UserAlreadyExistsException, InternalException {
        User user = null;
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)session);
            Authorizable authorizable = userManager.getAuthorizable(userName);
            if (authorizable != null) {
                throw new UserAlreadyExistsException("A principal already exists with the requested name: " + userName);
            }
            String passwordDigest = new PasswordDigester(password, this.configurator.getDigest(), this.configurator.getEncoding()).toString();
            user = userManager.createUser(userName, passwordDigest);
            for (String key : properties.keySet()) {
                if (properties.get(key) == null) continue;
                GenericValue val = GenericValue.getGenericValueFromObject((Object)properties.get(key));
                if (val.isMultiValue()) {
                    user.setProperty(key, val.getValues());
                    continue;
                }
                user.setProperty(key, val.get());
            }
        }
        catch (RepositoryException ex) {
            throw new InternalException("Repository exception", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new InternalException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new InternalException(ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new InternalException(ex);
        }
        return user;
    }

    @Override
    public Group addGroup(Session session, final String groupName, Map<String, Object> properties) throws GroupAlreadyExistsException, InternalException {
        Group group = null;
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)session);
            Authorizable authorizable = userManager.getAuthorizable(groupName);
            if (authorizable != null) {
                throw new GroupAlreadyExistsException("A principal already exists with the requested name: " + groupName);
            }
            group = userManager.createGroup(new Principal(){

                @Override
                public String getName() {
                    return groupName;
                }
            });
            if (properties != null) {
                for (String key : properties.keySet()) {
                    if (properties.get(key) == null) continue;
                    GenericValue val = GenericValue.getGenericValueFromObject((Object)properties.get(key));
                    if (val.isMultiValue()) {
                        group.setProperty(key, val.getValues());
                        continue;
                    }
                    group.setProperty(key, val.get());
                }
            }
        }
        catch (IllegalArgumentException ex) {
            throw new InternalException(ex);
        }
        catch (RepositoryException ex) {
            throw new InternalException("Repository exception", ex);
        }
        return group;
    }

    @Override
    public void deleteGroupByName(Session session, String groupName) throws GroupNotExistsException, InternalException, PrincipalIsNotGroupException {
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)session);
            Authorizable authorizable = userManager.getAuthorizable(groupName);
            if (authorizable == null) {
                throw new GroupNotExistsException("Group does not exist with the requested name: " + groupName);
            }
            if (!authorizable.isGroup()) {
                throw new PrincipalIsNotGroupException("Principal is not a group: " + groupName);
            }
            authorizable.remove();
        }
        catch (RepositoryException e) {
            throw new InternalException("Repository exception", e);
        }
    }

    @Override
    public void deleteUserByName(Session session, String userName) throws UserNotExistsException, InternalException, PrincipalIsNotUserException {
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)session);
            Authorizable authorizable = userManager.getAuthorizable(userName);
            if (authorizable == null) {
                throw new UserNotExistsException("User does not exist with the requested name: " + userName);
            }
            if (authorizable.isGroup()) {
                throw new PrincipalIsNotUserException("Principal is not a user: " + userName);
            }
            authorizable.remove();
        }
        catch (RepositoryException ex) {
            throw new InternalException("Repository exception", ex);
        }
    }

    @Override
    public Group getGroupByName(Session session, String groupName) throws GroupNotExistsException, InternalException, PrincipalIsNotGroupException {
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)session);
            Authorizable authorizable = userManager.getAuthorizable(groupName);
            if (authorizable == null) {
                throw new GroupNotExistsException("Group does not exist: " + groupName);
            }
            if (!authorizable.isGroup()) {
                throw new PrincipalIsNotGroupException("Principal is not group: " + groupName);
            }
            Group group = (Group)authorizable;
            return group;
        }
        catch (RepositoryException ex) {
            throw new InternalException("Repository exception", ex);
        }
    }

    @Override
    public User getUserByName(Session session, String userName) throws UserNotExistsException, InternalException, PrincipalIsNotUserException {
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)session);
            Authorizable authorizable = userManager.getAuthorizable(userName);
            if (authorizable == null) {
                throw new UserNotExistsException("Group does not exist: " + userName);
            }
            if (authorizable.isGroup()) {
                throw new PrincipalIsNotUserException("Principal is not user: " + userName);
            }
            User user = (User)authorizable;
            return user;
        }
        catch (RepositoryException ex) {
            throw new InternalException("Repository exception", ex);
        }
    }

    @Override
    public Authorizable getAuthorizableByName(Session session, String principal) throws PrincipalNotExistsException, InternalException {
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)session);
            Authorizable authorizable = userManager.getAuthorizable(principal);
            if (authorizable == null) {
                throw new PrincipalNotExistsException("Principal does not exist: " + principal);
            }
            Authorizable authorizable2 = authorizable;
            return authorizable2;
        }
        catch (RepositoryException ex) {
            throw new InternalException("Repository exception", ex);
        }
    }

    @Override
    public void changePasswordByName(Session session, String userName, String password) throws UserNotExistsException, PrincipalIsNotUserException, InternalException {
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)session);
            Authorizable authorizable = userManager.getAuthorizable(userName);
            if (authorizable == null) {
                throw new UserNotExistsException("User does not exist: " + userName);
            }
            if (authorizable.isGroup()) {
                throw new PrincipalIsNotUserException("Principal is not user: " + userName);
            }
            User user = (User)authorizable;
            user.changePassword(password);
            user.setProperty("jcr:Password", GenericValue.getGenericValueFromObject((Object)password).get());
        }
        catch (RepositoryException e) {
            throw new InternalException("Repository exception", e);
        }
    }

    @Override
    public List<Group> getEffectiveMemberOfByName(Session session, String principal) throws PrincipalNotExistsException, InternalException {
        ArrayList<Group> ret = new ArrayList<Group>();
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)session);
            Authorizable authorizable = userManager.getAuthorizable(principal);
            if (authorizable == null) {
                throw new PrincipalNotExistsException("Principal does not exist: " + principal);
            }
            Iterator iter = authorizable.memberOf();
            while (iter.hasNext()) {
                ret.add((Group)iter.next());
            }
        }
        catch (RepositoryException e) {
            throw new InternalException("Repository exception", e);
        }
        return ret;
    }

    @Override
    public List<Group> getDeclaredMemberOfByName(Session session, String principal) throws PrincipalNotExistsException, InternalException {
        ArrayList<Group> ret = new ArrayList<Group>();
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)session);
            Authorizable authorizable = userManager.getAuthorizable(principal);
            if (authorizable == null) {
                throw new PrincipalNotExistsException("Principal does not exist: " + principal);
            }
            Iterator iter = authorizable.declaredMemberOf();
            while (iter.hasNext()) {
                ret.add((Group)iter.next());
            }
        }
        catch (RepositoryException e) {
            throw new InternalException("Repository exception", e);
        }
        return ret;
    }

    @Override
    public List<Authorizable> getEffectiveMembersByName(Session session, String groupName) throws InternalException, PrincipalIsNotGroupException, GroupNotExistsException {
        HashSet<Object> ret = new HashSet<Object>();
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)session);
            Authorizable authorizable = userManager.getAuthorizable(groupName);
            if (authorizable == null) {
                throw new GroupNotExistsException("Group does not exist: " + groupName);
            }
            if (!authorizable.isGroup()) {
                throw new PrincipalIsNotGroupException("Principal is not a group: " + groupName);
            }
            Iterator iter = ((Group)authorizable).getMembers();
            while (iter.hasNext()) {
                Group act = (Group)iter.next();
                ret.addAll(this.getEffectiveMembersByName(session, act.getID()));
                ret.add(act);
            }
        }
        catch (RepositoryException e) {
            throw new InternalException("Repository exception", e);
        }
        ArrayList<Authorizable> out = new ArrayList<Authorizable>();
        out.addAll(ret);
        return out;
    }

    @Override
    public List<Authorizable> getDeclaredMembersByName(Session session, String groupName) throws InternalException, PrincipalIsNotGroupException, GroupNotExistsException {
        ArrayList<Authorizable> ret = new ArrayList<Authorizable>();
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)session);
            Authorizable authorizable = userManager.getAuthorizable(groupName);
            if (authorizable == null) {
                throw new GroupNotExistsException("Group does not exist: " + groupName);
            }
            if (!authorizable.isGroup()) {
                throw new PrincipalIsNotGroupException("Principal is not a group: " + groupName);
            }
            Iterator iter = ((Group)authorizable).getDeclaredMembers();
            while (iter.hasNext()) {
                ret.add(authorizable);
            }
        }
        catch (RepositoryException e) {
            throw new InternalException("Repository exception", e);
        }
        return ret;
    }

    @Override
    public Map<String, GenericValue> getPrincipalPropertiesByName(Session session, String principal) throws PrincipalNotExistsException, InternalException {
        HashMap<String, GenericValue> ret = new HashMap<String, GenericValue>();
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)session);
            Authorizable authorizable = userManager.getAuthorizable(principal);
            if (authorizable == null) {
                throw new PrincipalNotExistsException("Principal does not exist: " + principal);
            }
            Iterator iter = authorizable.getPropertyNames();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                GenericValue value = GenericValue.getGenericValueFromObject((Object)authorizable.getProperty(key));
                ret.put(key, value);
            }
        }
        catch (RepositoryException e) {
            throw new InternalException("Repository exception", e);
        }
        return ret;
    }

    @Override
    public void modifyPrincipalPropertiesByName(Session session, String principal, Map<String, GenericValue> properties) throws UserNotExistsException, InternalException, PrincipalIsNotUserException {
    }

    @Override
    public SerializablePrivilege[] getSupportedPrivileges(Node node) throws InternalException {
        try {
            return this.getSupportedPrivileges(node.getSession(), node.getPath());
        }
        catch (RepositoryException ex) {
            throw new InternalException("Repository exception", ex);
        }
    }

    @Override
    public SerializablePrivilege[] getSupportedPrivileges(Session session, String absPath) throws InternalException {
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
            SerializablePrivilege[] supportedPrivileges = SerializablePrivilege.fromPrivilegeArray(accessControlManager.getSupportedPrivileges(absPath));
            return supportedPrivileges;
        }
        catch (UnsupportedRepositoryOperationException ex) {
            throw new InternalException("Unsupported operation: " + absPath, ex);
        }
        catch (RepositoryException ex) {
            throw new InternalException("Repository exception: " + absPath, ex);
        }
    }

    @Override
    public Map<Principal, AccessRights> getDeclaredAccessRights(Node node) throws InternalException {
        Map<Principal, AccessRights> accessRights;
        try {
            accessRights = this.getDeclaredAccessRights(node.getSession(), node.getPath());
        }
        catch (RepositoryException ex) {
            throw new InternalException("Repository exception", ex);
        }
        return accessRights;
    }

    @Override
    public Map<Principal, AccessRights> getDeclaredAccessRights(Session session, String absPath) throws InternalException {
        try {
            LinkedHashMap<Principal, AccessRights> accessMap = new LinkedHashMap<Principal, AccessRights>();
            AccessControlEntry[] entries = this.getDeclaredAccessControlEntries(session, absPath);
            if (entries != null) {
                for (AccessControlEntry ace : entries) {
                    int i;
                    Privilege[] privs;
                    boolean isAllow;
                    Principal principal = ace.getPrincipal();
                    AccessRights accessPrivleges = (AccessRights)accessMap.get(principal);
                    if (accessPrivleges == null) {
                        accessPrivleges = new AccessRightsImpl();
                        accessMap.put(principal, accessPrivleges);
                    }
                    if (isAllow = AccessControlUtil.isAllow((AccessControlEntry)ace)) {
                        privs = ace.getPrivileges();
                        for (i = 0; i < privs.length; ++i) {
                            accessPrivleges.getGranted().add(new SerializablePrivilege(privs[i]));
                        }
                        continue;
                    }
                    privs = ace.getPrivileges();
                    for (i = 0; i < privs.length; ++i) {
                        accessPrivleges.getDenied().add(new SerializablePrivilege(privs[i]));
                    }
                }
            }
            return accessMap;
        }
        catch (RepositoryException ex) {
            throw new InternalException("Repository exception", ex);
        }
    }

    private AccessControlEntry[] getDeclaredAccessControlEntries(Session session, String absPath) throws RepositoryException {
        AccessControlPolicy[] policies;
        AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
        for (AccessControlPolicy accessControlPolicy : policies = accessControlManager.getPolicies(absPath)) {
            if (!(accessControlPolicy instanceof AccessControlList)) continue;
            AccessControlEntry[] accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries();
            return accessControlEntries;
        }
        return new AccessControlEntry[0];
    }

    @Override
    public AccessRights getDeclaredAccessRightsForPrincipal(Node node, String principalId) throws InternalException {
        try {
            return this.getDeclaredAccessRightsForPrincipal(node.getSession(), node.getPath(), principalId);
        }
        catch (RepositoryException ex) {
            throw new InternalException("Repository exception", ex);
        }
    }

    @Override
    public AccessRights getDeclaredAccessRightsForPrincipal(Session session, String absPath, String principalId) throws InternalException {
        try {
            AccessRightsImpl rights = new AccessRightsImpl();
            if (principalId != null && principalId.length() > 0) {
                AccessControlPolicy[] policies;
                AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
                for (AccessControlPolicy accessControlPolicy : policies = accessControlManager.getPolicies(absPath)) {
                    AccessControlEntry[] accessControlEntries;
                    if (!(accessControlPolicy instanceof AccessControlList)) continue;
                    for (AccessControlEntry ace : accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries()) {
                        int i;
                        Privilege[] privs;
                        if (!principalId.equals(ace.getPrincipal().getName())) continue;
                        boolean isAllow = AccessControlUtil.isAllow((AccessControlEntry)ace);
                        if (isAllow) {
                            privs = ace.getPrivileges();
                            for (i = 0; i < privs.length; ++i) {
                                rights.getGranted().add(new SerializablePrivilege(privs[i]));
                            }
                            continue;
                        }
                        privs = ace.getPrivileges();
                        for (i = 0; i < privs.length; ++i) {
                            rights.getDenied().add(new SerializablePrivilege(privs[i]));
                        }
                    }
                }
            }
            AccessRightsImpl accessRightsImpl = rights;
            return accessRightsImpl;
        }
        catch (RepositoryException ex) {
            throw new InternalException("Repository exception: " + absPath, ex);
        }
    }

    @Override
    public Map<Principal, AccessRights> getEffectiveAccessRights(Node node) throws InternalException {
        Map<Principal, AccessRights> accessRights;
        try {
            accessRights = this.getEffectiveAccessRights(node.getSession(), node.getPath());
        }
        catch (RepositoryException ex) {
            throw new InternalException("Repository exception", ex);
        }
        return accessRights;
    }

    @Override
    public Map<Principal, AccessRights> getEffectiveAccessRights(Session session, String absPath) throws InternalException {
        try {
            LinkedHashMap<Principal, AccessRights> accessMap = new LinkedHashMap<Principal, AccessRights>();
            AccessControlEntry[] entries = this.getEffectiveAccessControlEntries(session, absPath);
            if (entries != null) {
                for (AccessControlEntry ace : entries) {
                    int i;
                    Privilege[] privs;
                    boolean allow;
                    Principal principal = ace.getPrincipal();
                    AccessRights accessPrivleges = (AccessRights)accessMap.get(principal);
                    if (accessPrivleges == null) {
                        accessPrivleges = new AccessRightsImpl();
                        accessMap.put(principal, accessPrivleges);
                    }
                    if (allow = AccessControlUtil.isAllow((AccessControlEntry)ace)) {
                        privs = ace.getPrivileges();
                        for (i = 0; i < privs.length; ++i) {
                            accessPrivleges.getGranted().add(new SerializablePrivilege(privs[i]));
                        }
                        continue;
                    }
                    privs = ace.getPrivileges();
                    for (i = 0; i < privs.length; ++i) {
                        accessPrivleges.getDenied().add(new SerializablePrivilege(privs[i]));
                    }
                }
            }
            return accessMap;
        }
        catch (RepositoryException ex) {
            throw new InternalException("Repository exception: ", ex);
        }
    }

    private AccessControlEntry[] getEffectiveAccessControlEntries(Session session, String absPath) throws RepositoryException {
        AccessControlPolicy[] policies;
        AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
        for (AccessControlPolicy accessControlPolicy : policies = accessControlManager.getEffectivePolicies(absPath)) {
            if (!(accessControlPolicy instanceof AccessControlList)) continue;
            AccessControlEntry[] accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries();
            return accessControlEntries;
        }
        return new AccessControlEntry[0];
    }

    @Override
    public AccessRights getEffectiveAccessRightsForPrincipal(Node node, String principalId) throws InternalException {
        try {
            return this.getEffectiveAccessRightsForPrincipal(node.getSession(), node.getPath(), principalId);
        }
        catch (RepositoryException ex) {
            throw new InternalException("Repository exception", ex);
        }
    }

    @Override
    public AccessRights getEffectiveAccessRightsForPrincipal(Session session, String absPath, String principalId) throws InternalException {
        AccessRightsImpl rights = new AccessRightsImpl();
        if (principalId != null && principalId.length() > 0) {
            try {
                AccessControlPolicy[] policies;
                AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
                for (AccessControlPolicy accessControlPolicy : policies = accessControlManager.getEffectivePolicies(absPath)) {
                    AccessControlEntry[] accessControlEntries;
                    if (!(accessControlPolicy instanceof AccessControlList)) continue;
                    for (AccessControlEntry ace : accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries()) {
                        int i;
                        Privilege[] privs;
                        if (!principalId.equals(ace.getPrincipal().getName())) continue;
                        boolean isAllow = AccessControlUtil.isAllow((AccessControlEntry)ace);
                        if (isAllow) {
                            privs = ace.getPrivileges();
                            for (i = 0; i < privs.length; ++i) {
                                rights.getGranted().add(new SerializablePrivilege(privs[i]));
                            }
                            continue;
                        }
                        privs = ace.getPrivileges();
                        for (i = 0; i < privs.length; ++i) {
                            rights.getDenied().add(new SerializablePrivilege(privs[i]));
                        }
                    }
                }
            }
            catch (UnsupportedRepositoryOperationException ex) {
                throw new InternalException("Unsupported Operation Repository exception", ex);
            }
            catch (RepositoryException ex) {
                throw new InternalException("Repository exception", ex);
            }
        }
        return rights;
    }

    @Override
    public boolean canAddChildren(Node node) {
        try {
            return this.canAddChildren(node.getSession(), node.getPath());
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Override
    public boolean canAddChildren(Session session, String absPath) {
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
            return accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}addChildNodes")});
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Override
    public boolean canDeleteChildren(Node node) {
        try {
            return this.canDeleteChildren(node.getSession(), node.getPath());
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Override
    public boolean canDeleteChildren(Session session, String absPath) {
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
            return accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeChildNodes")});
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Override
    public boolean canDelete(Node node) {
        try {
            return this.canDelete(node.getSession(), node.getPath());
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Override
    public boolean canDelete(Session session, String absPath) {
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
            String parentPath = absPath.substring(0, absPath.lastIndexOf(47));
            boolean canDelete = accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeNode")}) && this.canDeleteChildren(session, parentPath);
            return canDelete;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Override
    public boolean canModifyProperties(Node node) {
        try {
            return this.canModifyProperties(node.getSession(), node.getPath());
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Override
    public boolean canModifyProperties(Session session, String absPath) {
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
            return accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}modifyProperties")});
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Override
    public boolean canReadAccessControl(Node node) {
        try {
            return this.canReadAccessControl(node.getSession(), node.getPath());
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Override
    public boolean canReadAccessControl(Session session, String absPath) {
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
            return accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}readAccessControl")});
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Override
    public boolean canModifyAccessControl(Node node) {
        try {
            return this.canModifyAccessControl(node.getSession(), node.getPath());
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Override
    public boolean canModifyAccessControl(Session session, String absPath) {
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
            return accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}modifyAccessControl")});
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    @Override
    public boolean canUpdateAuthorizable(Session session, String principalID) {
        try {
            PrincipalManager principalManager = AccessControlUtil.getPrincipalManager((Session)session);
            Principal principal = principalManager.getPrincipal(principalID);
            if (principal == null) {
                return false;
            }
            String path = this.getAuthorizableItemPath(principal);
            return this.canModifyProperties(session, path);
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getAuthorizableItemPath(Principal principal) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = principal.getClass().getMethod("getPath", new Class[0]);
        String path = (String)method.invoke((Object)principal, new Object[0]);
        return path;
    }

    @Override
    public boolean canDeleteAuthorizable(Session session, String principalID) {
        try {
            PrincipalManager principalManager = AccessControlUtil.getPrincipalManager((Session)session);
            Principal principal = principalManager.getPrincipal(principalID);
            if (principal == null) {
                return false;
            }
            String path = this.getAuthorizableItemPath(principal);
            return this.canDelete(session, path);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setAclByName(Session session, String principalName, String path, AccessRights privileges) throws InternalException, PrincipalNotExistsException {
        try {
            AccessControlEntry ace;
            AccessControlPolicy[] policies;
            UserManager userManager = AccessControlUtil.getUserManager((Session)session);
            Object principal = null;
            if (!principalName.equalsIgnoreCase("everyone")) {
                principal = userManager.getAuthorizable(principalName).getPrincipal();
                if (principal == null) {
                    throw new PrincipalNotExistsException("Principal does not exist: " + principalName);
                }
            } else {
                principal = EveryonePrincipal.getInstance();
            }
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
            AccessControlList acl = null;
            for (AccessControlPolicy policy : policies = accessControlManager.getPolicies(path)) {
                if (!(policy instanceof AccessControlList)) continue;
                acl = (AccessControlList)policy;
                break;
            }
            if (acl == null) {
                AccessControlPolicyIterator applicablePolicies = accessControlManager.getApplicablePolicies(path);
                while (applicablePolicies.hasNext()) {
                    AccessControlPolicy policy = applicablePolicies.nextAccessControlPolicy();
                    if (!(policy instanceof AccessControlList)) continue;
                    acl = (AccessControlList)policy;
                    break;
                }
            }
            if (acl == null) {
                throw new RepositoryException("Could not obtain ACL for resource " + path);
            }
            int i = 0;
            AccessControlEntry[] accessControlEntries = acl.getAccessControlEntries();
            if (i < accessControlEntries.length && principal.equals((ace = accessControlEntries[i]).getPrincipal())) {
                acl.removeAccessControlEntry(ace);
            }
            if (privileges.getGranted() != null && privileges.getGranted().size() > 0) {
                SerializablePrivilege[] granted = new SerializablePrivilege[privileges.getGranted().size()];
                System.arraycopy(privileges.getGranted().toArray(), 0, granted, 0, privileges.getGranted().size());
                if (!AccessControlUtil.addEntry((AccessControlList)acl, (Principal)principal, (Privilege[])PrivilegeFromSerializable.fromSerializableArray(accessControlManager, granted), (boolean)true)) {
                    throw new RepositoryException("Could not set granted rights for principal: " + principal);
                }
            }
            if (privileges.getDenied() != null && privileges.getDenied().size() > 0) {
                SerializablePrivilege[] denied = new SerializablePrivilege[privileges.getDenied().size()];
                System.arraycopy(privileges.getDenied().toArray(), 0, denied, 0, privileges.getDenied().size());
                if (!AccessControlUtil.addEntry((AccessControlList)acl, (Principal)principal, (Privilege[])PrivilegeFromSerializable.fromSerializableArray(accessControlManager, denied), (boolean)false)) {
                    throw new RepositoryException("Could not set granted denied for principal: " + principal);
                }
            }
            accessControlManager.setPolicy(path, (AccessControlPolicy)acl);
        }
        catch (RepositoryException ex) {
            throw new InternalException("Repository exception", ex);
        }
    }

    @Override
    public AccessRights getAclByName(Session session, String principalId, String absPath) throws InternalException {
        AccessRightsImpl rights;
        block9: {
            rights = new AccessRightsImpl();
            try {
                AccessControlPolicy[] policies;
                if (principalId == null || principalId.length() <= 0) break block9;
                AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)session);
                for (AccessControlPolicy accessControlPolicy : policies = accessControlManager.getPolicies(absPath)) {
                    AccessControlEntry[] accessControlEntries;
                    if (!(accessControlPolicy instanceof AccessControlList)) continue;
                    for (AccessControlEntry ace : accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries()) {
                        int i;
                        Privilege[] privs;
                        if (!principalId.equals(ace.getPrincipal().getName())) continue;
                        boolean isAllow = AccessControlUtil.isAllow((AccessControlEntry)ace);
                        if (isAllow) {
                            privs = ace.getPrivileges();
                            for (i = 0; i < privs.length; ++i) {
                                rights.getGranted().add(new SerializablePrivilege(privs[i]));
                            }
                            continue;
                        }
                        privs = ace.getPrivileges();
                        for (i = 0; i < privs.length; ++i) {
                            rights.getDenied().add(new SerializablePrivilege(privs[i]));
                        }
                    }
                }
            }
            catch (RepositoryException ex) {
                throw new InternalException("Repository exception", ex);
            }
        }
        return rights;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean addPrincipalToGroup(Session session, String principal, String groupName) throws InternalException, PrincipalNotExistsException, PrincipalIsNotGroupException {
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)session);
            Authorizable authorizable = userManager.getAuthorizable(principal);
            if (authorizable == null) {
                throw new PrincipalNotExistsException("A principal does not exist with the requested name: " + principal);
            }
            Authorizable group = userManager.getAuthorizable(groupName);
            if (!group.isGroup()) {
                throw new PrincipalIsNotGroupException("Principal is not group: " + groupName);
            }
            Group grp = (Group)group;
            return grp.addMember(authorizable);
        }
        catch (RepositoryException ex) {
            throw new InternalException("Repository exception", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new InternalException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean removePrincipalFromGroup(Session session, String principal, String groupName) throws InternalException, PrincipalNotExistsException, PrincipalIsNotGroupException {
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)session);
            Authorizable authorizable = userManager.getAuthorizable(principal);
            if (authorizable == null) {
                throw new PrincipalNotExistsException("A principal does not exist with the requested name: " + principal);
            }
            Authorizable group = userManager.getAuthorizable(groupName);
            if (!group.isGroup()) {
                throw new PrincipalIsNotGroupException("Principal is not group: " + groupName);
            }
            Group grp = (Group)group;
            return grp.removeMember(authorizable);
        }
        catch (RepositoryException ex) {
            throw new InternalException("Repository exception", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new InternalException(ex);
        }
    }

    @Override
    public void createUserHome(Session session, String userName) throws PrincipalIsNotUserException, InternalException, PrincipalNotExistsException {
        this.createUserHome(session, userName, null);
    }

    @Override
    public void createUserHome(Session session, String userName, String parentPath) throws PrincipalIsNotUserException, InternalException, PrincipalNotExistsException {
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)session);
            Authorizable authorizable = userManager.getAuthorizable(userName);
            if (authorizable.isGroup()) {
                throw new PrincipalIsNotUserException("Principal is not user: " + userName);
            }
            Node rootNode = session.getRootNode();
            if (StringUtils.isNotBlank((String)parentPath)) {
                rootNode = rootNode.getNode(parentPath);
            }
            Node home = null;
            if (!rootNode.hasNode("home")) {
                home = rootNode.addNode("home");
                AccessRightsImpl rights = new AccessRightsImpl();
                rights.getDenied().add(new SerializablePrivilege("{http://www.jcp.org/jcr/1.0}all"));
                this.setAclByName(session, "everyone", home.getPath(), rights);
            } else {
                home = rootNode.getNode("home");
            }
            Node userNode = null;
            if (!home.hasNode(userName)) {
                userNode = home.addNode(userName);
                AccessRightsImpl rights = new AccessRightsImpl();
                rights.getGranted().add(new SerializablePrivilege("{http://www.jcp.org/jcr/1.0}all"));
                this.setAclByName(session, userName, userNode.getPath(), rights);
            } else {
                userNode = home.getNode(userName);
            }
            if (session.hasPendingChanges()) {
                session.save();
            }
        }
        catch (RepositoryException ex) {
            throw new InternalException("Repository exception", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new InternalException(ex);
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindConfigurator(Configurator configurator) {
        this.configurator = configurator;
    }

    protected void unbindConfigurator(Configurator configurator) {
        if (this.configurator == configurator) {
            this.configurator = null;
        }
    }
}

