/*
 * Decompiled with CFR 0.152.
 */
package org.liveSense.service.securityManager;

import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.jcr.api.SlingRepository;
import org.liveSense.core.wrapper.GenericValue;
import org.liveSense.service.securityManager.AccessRights;
import org.liveSense.service.securityManager.SerializablePrivilege;
import org.liveSense.service.securityManager.exceptions.GroupAlreadyExistsException;
import org.liveSense.service.securityManager.exceptions.GroupNotExistsException;
import org.liveSense.service.securityManager.exceptions.InternalException;
import org.liveSense.service.securityManager.exceptions.PrincipalIsNotGroupException;
import org.liveSense.service.securityManager.exceptions.PrincipalIsNotUserException;
import org.liveSense.service.securityManager.exceptions.PrincipalNotExistsException;
import org.liveSense.service.securityManager.exceptions.UserAlreadyExistsException;
import org.liveSense.service.securityManager.exceptions.UserNotExistsException;

public interface SecurityManagerService {
    public Group addGroup(Session var1, String var2, Map<String, Object> var3) throws GroupAlreadyExistsException, InternalException;

    public User addUser(Session var1, String var2, String var3, Map<String, Object> var4) throws UserAlreadyExistsException, InternalException;

    public boolean canAddChildren(Node var1);

    public boolean canAddChildren(Session var1, String var2);

    public boolean canDelete(Node var1);

    public boolean canDelete(Session var1, String var2);

    public boolean canDeleteAuthorizable(Session var1, String var2);

    public boolean canDeleteChildren(Node var1);

    public boolean canDeleteChildren(Session var1, String var2);

    public boolean canModifyAccessControl(Node var1);

    public boolean canModifyAccessControl(Session var1, String var2);

    public boolean canModifyProperties(Node var1);

    public boolean canModifyProperties(Session var1, String var2);

    public boolean canReadAccessControl(Node var1);

    public boolean canReadAccessControl(Session var1, String var2);

    public boolean canUpdateAuthorizable(Session var1, String var2);

    public void changePasswordByName(Session var1, String var2, String var3) throws UserNotExistsException, PrincipalIsNotUserException, InternalException;

    public void deleteGroupByName(Session var1, String var2) throws GroupNotExistsException, InternalException, PrincipalIsNotGroupException;

    public void deleteUserByName(Session var1, String var2) throws UserNotExistsException, InternalException, PrincipalIsNotUserException;

    public AccessRights getAclByName(Session var1, String var2, String var3) throws InternalException;

    public Authorizable getAuthorizableByName(Session var1, String var2) throws PrincipalNotExistsException, InternalException;

    public Map<Principal, AccessRights> getDeclaredAccessRights(Node var1) throws InternalException;

    public Map<Principal, AccessRights> getDeclaredAccessRights(Session var1, String var2) throws InternalException;

    public AccessRights getDeclaredAccessRightsForPrincipal(Node var1, String var2) throws InternalException;

    public AccessRights getDeclaredAccessRightsForPrincipal(Session var1, String var2, String var3) throws InternalException;

    public List<Group> getDeclaredMemberOfByName(Session var1, String var2) throws PrincipalNotExistsException, InternalException;

    public List<Authorizable> getDeclaredMembersByName(Session var1, String var2) throws InternalException, PrincipalIsNotGroupException, GroupNotExistsException;

    public Map<Principal, AccessRights> getEffectiveAccessRights(Node var1) throws InternalException;

    public Map<Principal, AccessRights> getEffectiveAccessRights(Session var1, String var2) throws InternalException;

    public AccessRights getEffectiveAccessRightsForPrincipal(Node var1, String var2) throws InternalException;

    public AccessRights getEffectiveAccessRightsForPrincipal(Session var1, String var2, String var3) throws InternalException;

    public List<Group> getEffectiveMemberOfByName(Session var1, String var2) throws PrincipalNotExistsException, InternalException;

    public List<Authorizable> getEffectiveMembersByName(Session var1, String var2) throws InternalException, PrincipalIsNotGroupException, GroupNotExistsException;

    public Group getGroupByName(Session var1, String var2) throws GroupNotExistsException, InternalException, PrincipalIsNotGroupException;

    public Map<String, GenericValue> getPrincipalPropertiesByName(Session var1, String var2) throws PrincipalNotExistsException, InternalException;

    public SlingRepository getRepository() throws RepositoryException;

    public SerializablePrivilege[] getSupportedPrivileges(Node var1) throws InternalException;

    public SerializablePrivilege[] getSupportedPrivileges(Session var1, String var2) throws InternalException;

    public User getUserByName(Session var1, String var2) throws UserNotExistsException, InternalException, PrincipalIsNotUserException;

    public void modifyPrincipalPropertiesByName(Session var1, String var2, Map<String, GenericValue> var3) throws UserNotExistsException, InternalException, PrincipalIsNotUserException;

    public void setAclByName(Session var1, String var2, String var3, AccessRights var4) throws InternalException, PrincipalNotExistsException;

    public boolean addPrincipalToGroup(Session var1, String var2, String var3) throws InternalException, PrincipalNotExistsException, PrincipalIsNotGroupException;

    public boolean removePrincipalFromGroup(Session var1, String var2, String var3) throws InternalException, PrincipalNotExistsException, PrincipalIsNotGroupException;

    public void createUserHome(Session var1, String var2) throws PrincipalIsNotUserException, InternalException, PrincipalNotExistsException;

    public void createUserHome(Session var1, String var2, String var3) throws PrincipalIsNotUserException, InternalException, PrincipalNotExistsException;
}

