/*
 * Decompiled with CFR 0.152.
 */
package org.liveSense.service.securityManager;

import java.util.ArrayList;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.liveSense.service.securityManager.SerializablePrivilege;

public class PrivilegeFromSerializable
implements Privilege {
    SerializablePrivilege privilege;

    static Privilege[] fromSerializableArray(AccessControlManager util, SerializablePrivilege[] privileges) throws AccessControlException, RepositoryException {
        Privilege[] ret = new Privilege[privileges.length];
        for (int i = 0; i < privileges.length; ++i) {
            ret[i] = util.privilegeFromName(privileges[i].getName());
        }
        return ret;
    }

    public PrivilegeFromSerializable(SerializablePrivilege privilege) {
        this.privilege = privilege;
    }

    public String getName() {
        return this.privilege.getName();
    }

    public boolean isAbstract() {
        return this.privilege.isAbstract();
    }

    public boolean isAggregate() {
        return this.privilege.isAggregate();
    }

    public Privilege[] getDeclaredAggregatePrivileges() {
        ArrayList<PrivilegeFromSerializable> ret = new ArrayList<PrivilegeFromSerializable>();
        Iterator<SerializablePrivilege> iter = this.privilege.declaredAggregatePrivileges.iterator();
        while (iter.hasNext()) {
            ret.add(new PrivilegeFromSerializable(iter.next()));
        }
        Privilege[] retArr = new PrivilegeFromSerializable[ret.size()];
        System.arraycopy(ret.toArray(), 0, retArr, 0, ret.size());
        return retArr;
    }

    public Privilege[] getAggregatePrivileges() {
        ArrayList<PrivilegeFromSerializable> ret = new ArrayList<PrivilegeFromSerializable>();
        Iterator<SerializablePrivilege> iter = this.privilege.aggregatePrivileges.iterator();
        while (iter.hasNext()) {
            ret.add(new PrivilegeFromSerializable(iter.next()));
        }
        Privilege[] retArr = new PrivilegeFromSerializable[ret.size()];
        System.arraycopy(ret.toArray(), 0, retArr, 0, ret.size());
        return retArr;
    }
}

