/*
 * Decompiled with CFR 0.152.
 */
package org.liveSense.service.securityManager;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.liveSense.service.securityManager.AccessRights;
import org.liveSense.service.securityManager.SerializablePrivilege;

public class AccessRightsImpl
implements AccessRights {
    private Set<SerializablePrivilege> granted = new HashSet<SerializablePrivilege>();
    private Set<SerializablePrivilege> denied = new HashSet<SerializablePrivilege>();
    private static transient ResourceBundle resBundle = null;

    private ResourceBundle getResourceBundle(Locale locale) {
        if (resBundle == null || !resBundle.getLocale().equals(locale)) {
            resBundle = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".PrivilegesResources", locale);
        }
        return resBundle;
    }

    @Override
    public Set<SerializablePrivilege> getGranted() {
        return this.granted;
    }

    @Override
    public Set<SerializablePrivilege> getDenied() {
        return this.denied;
    }

    @Override
    public String[] getGrantedAsString() {
        String[] privStr = new String[this.granted.size()];
        int i = 0;
        for (SerializablePrivilege privilege : this.granted) {
            privStr[i] = privilege.getName();
            ++i;
        }
        return privStr;
    }

    @Override
    public String[] getDeniedAsString() {
        String[] privStr = new String[this.denied.size()];
        int i = 0;
        for (SerializablePrivilege privilege : this.denied) {
            privStr[i] = privilege.getName();
            ++i;
        }
        return privStr;
    }

    @Override
    public String getPrivilegeSetDisplayName(Locale locale) {
        if (this.denied != null && !this.denied.isEmpty()) {
            return this.getResourceBundle(locale).getString("privilegeset.custom");
        }
        if (this.granted.isEmpty()) {
            return this.getResourceBundle(locale).getString("privilegeset.none");
        }
        if (this.granted.size() == 1) {
            Iterator<SerializablePrivilege> iterator = this.granted.iterator();
            SerializablePrivilege next = iterator.next();
            if ("jcr:all".equals(next.getName())) {
                return this.getResourceBundle(locale).getString("privilegeset.all");
            }
            if ("jcr:read".equals(next.getName())) {
                return this.getResourceBundle(locale).getString("privilegeset.readonly");
            }
        } else if (this.granted.size() == 2) {
            Iterator<SerializablePrivilege> iterator = this.granted.iterator();
            SerializablePrivilege next = iterator.next();
            SerializablePrivilege next2 = iterator.next();
            if ("jcr:read".equals(next.getName()) && "jcr:write".equals(next2.getName()) || "jcr:read".equals(next2.getName()) && "jcr:write".equals(next.getName())) {
                return this.getResourceBundle(locale).getString("privilegeset.readwrite");
            }
        }
        return this.getResourceBundle(locale).getString("privilegeset.custom");
    }
}

