/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chinese.fate.util;

import com.github.houbb.chinese.fate.util.CalendarUtil;
import com.github.houbb.heaven.annotation.CommonEager;
import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import com.github.houbb.heaven.util.util.DateUtil;
import java.util.Calendar;
import java.util.Date;

public final class DestinyUtil {
    private static final String[] TIAN_GAN = new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
    private static final String[] DI_ZHI = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
    private static final String[] SHENG_XIAO = new String[]{"\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};
    private static final String[] JIA_ZI = new String[]{"\u4e19\u5bc5", "\u620a\u5bc5", "\u5e9a\u5bc5", "\u58ec\u5bc5", "\u7532\u5bc5", "\u4e01\u536f", "\u5df1\u536f", "\u8f9b\u536f", "\u7678\u536f", "\u4e59\u536f", "\u620a\u8fb0", "\u5e9a\u8fb0", "\u58ec\u8fb0", "\u7532\u8fb0", "\u4e19\u8fb0", "\u5df1\u5df3", "\u8f9b\u5df3", "\u7678\u5df3", "\u4e59\u5df3", "\u4e01\u5df3", "\u5e9a\u5348", "\u58ec\u5348", "\u7532\u5348", "\u4e19\u5348", "\u620a\u5348", "\u8f9b\u672a", "\u7678\u672a", "\u4e59\u672a", "\u4e01\u672a", "\u5df1\u672a", "\u58ec\u7533", "\u7532\u7533", "\u4e19\u7533", "\u620a\u7533", "\u5e9a\u7533", "\u7678\u9149", "\u4e59\u9149", "\u4e01\u9149", "\u5df1\u9149", "\u8f9b\u9149", "\u7532\u620c", "\u4e19\u620c", "\u620a\u620c", "\u5e9a\u620c", "\u58ec\u620c", "\u4e59\u4ea5", "\u4e01\u4ea5", "\u5df1\u4ea5", "\u8f9b\u4ea5", "\u7678\u4ea5", "\u4e19\u5b50", "\u620a\u5b50", "\u5e9a\u5b50", "\u58ec\u5b50", "\u7532\u5b50", "\u4e01\u4e11", "\u5df1\u4e11", "\u8f9b\u4e11", "\u7678\u4e11", "\u4e59\u4e11"};
    private static final int[] DAY_ARR = new int[]{20, 19, 21, 20, 21, 22, 23, 23, 23, 24, 23, 22};
    private static final String[] CONSTELLATION_ARR = new String[]{"\u6469\u7faf\u5ea7", "\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u767d\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u6469\u7faf\u5ea7"};
    private static final String[] SHU_XIANG = new String[]{"\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};

    private DestinyUtil() {
    }

    public static String getXingZuo(int month, int day) {
        return day < DAY_ARR[month - 1] ? CONSTELLATION_ARR[month - 1] : CONSTELLATION_ARR[month];
    }

    public static String getShuXiang(int year) {
        if (year < 1900) {
            return "\u672a\u77e5";
        }
        int start = 1900;
        return SHU_XIANG[(year - start) % SHU_XIANG.length];
    }

    public static String getEightWord4Lunar(int year, int month, int day, int hour) {
        try {
            String dateStr = DestinyUtil.getDateString(year, month, day);
            String res = CalendarUtil.lunarToSolar(dateStr);
            return DestinyUtil.getEightWord(Integer.parseInt(res.substring(0, 4)), Integer.parseInt(res.substring(4, 6)), Integer.parseInt(res.substring(6, 8)), hour);
        }
        catch (Exception e) {
            throw new CommonRuntimeException((Throwable)e);
        }
    }

    @CommonEager
    private static Date of(int year, int month, int day) {
        String dateStr = DestinyUtil.leftPaddingZero(year, 4) + DestinyUtil.leftPaddingZero(month, 2) + DestinyUtil.leftPaddingZero(day, 2);
        return DateUtil.getFormatDate((String)dateStr, (String)"yyyyMMdd");
    }

    @CommonEager
    public static String getDateString(int year, int month, int day) {
        return DestinyUtil.leftPaddingZero(year, 4) + DestinyUtil.leftPaddingZero(month, 2) + DestinyUtil.leftPaddingZero(day, 2);
    }

    @CommonEager
    private static String leftPaddingZero(int value, int expectSize) {
        String valueStr = String.valueOf(value);
        if (valueStr.length() >= expectSize) {
            return valueStr;
        }
        int zeroSize = expectSize - valueStr.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < zeroSize; ++i) {
            stringBuilder.append("0");
        }
        return stringBuilder.toString() + valueStr;
    }

    @CommonEager
    private static int getDayOfYear(int year, int month, int day) {
        Date date = DestinyUtil.of(year, month, day);
        return DestinyUtil.getDayOfYear(date);
    }

    @CommonEager
    private static int getDayOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(6);
    }

    public static String getEightWord(int year, int month, int day, int hour) {
        return DestinyUtil.getYearColumn(year) + DestinyUtil.getMonthColumn(year, month) + DestinyUtil.getDayColumn(year, month, day) + DestinyUtil.getHourColumn(year, month, day, hour);
    }

    public static String getYearColumn(int year) {
        return DestinyUtil.getTianGan(year - 3) + DestinyUtil.getDiZhi(year - 3);
    }

    private static String getTianGan(int num) {
        return TIAN_GAN[DestinyUtil.getTianGanIndex(num)];
    }

    private static int getTianGanIndex(int num) {
        return (num % TIAN_GAN.length + 9) % 10;
    }

    private static String getDiZhi(int num) {
        return DI_ZHI[DestinyUtil.getDiZhiIndex(num)];
    }

    private static int getDiZhiIndex(int num) {
        return (num % DI_ZHI.length + 9) % 12;
    }

    private static String getMonthColumn(int year, int month) {
        return JIA_ZI[DestinyUtil.getTianGanIndex(year - 3) % 5 + (month - 1) * 5];
    }

    public static String getDayColumn(int year, int month, int day) {
        int dayOfYear = DestinyUtil.getDayOfYear(year, month, day);
        int remainder = ((year - 1) * 5 + (year - 1) / 4 + dayOfYear) % 60;
        return DestinyUtil.getTianGan(remainder) + DestinyUtil.getDiZhi(remainder);
    }

    private static String getHourColumn(int year, int month, int day, int hour) {
        int dayOfYear = DestinyUtil.getDayOfYear(year, month, day);
        int remainder = ((year - 1) * 5 + (year - 1) / 4 + dayOfYear) % 60;
        int col = DestinyUtil.getTianGanIndex(remainder) + 1;
        int row = (hour + 3) / 2 % 12;
        return TIAN_GAN[(col + row * 5) % 10] + DI_ZHI[row];
    }

    public static String getShengXiao(int year) {
        return SHENG_XIAO[(DestinyUtil.getDiZhiIndex(year - 3) + 2) % 12];
    }

    public static String getWuXing(String baZi) {
        StringBuilder wuXing = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            wuXing.append(DestinyUtil.getTianGanWuXing(baZi.substring(2 * i, 2 * i + 1)));
            wuXing.append(DestinyUtil.getDiZhiWuXing(baZi.substring(2 * i + 1, 2 * i + 2)));
        }
        return wuXing.toString();
    }

    public static String getTianGanWuXing(String tianGan) {
        if ("\u7532\u4e59".contains(tianGan)) {
            return "\u6728";
        }
        if ("\u4e19\u4e01".contains(tianGan)) {
            return "\u706b";
        }
        if ("\u620a\u5df1".contains(tianGan)) {
            return "\u571f";
        }
        if ("\u5e9a\u8f9b".contains(tianGan)) {
            return "\u91d1";
        }
        if ("\u58ec\u7678".contains(tianGan)) {
            return "\u6c34";
        }
        return tianGan;
    }

    private static String getDiZhiWuXing(String diZhi) {
        if ("\u5bc5\u536f".contains(diZhi)) {
            return "\u6728";
        }
        if ("\u5df3\u5348".contains(diZhi)) {
            return "\u706b";
        }
        if ("\u8fb0\u4e11\u620c\u672a".contains(diZhi)) {
            return "\u571f";
        }
        if ("\u7533\u9149".contains(diZhi)) {
            return "\u91d1";
        }
        if ("\u4ea5\u5b50".contains(diZhi)) {
            return "\u6c34";
        }
        return diZhi;
    }

    @CommonEager
    public static int getCount(String data, String word) {
        int count = 0;
        for (int i = 0; i < data.length(); ++i) {
            if (!word.equals(data.substring(i, i + 1))) continue;
            ++count;
        }
        return count;
    }

    public static String getYunShi(String wuXingOfRiGan, int month) {
        if ("\u6728".equals(wuXingOfRiGan)) {
            if (month >= 1 && month <= 3) {
                return "\u5fc5\u987b\u6709\u706b\u52a9\uff0c\u6709\u6c34\u66f4\u597d\uff0c\u4f46\u5fcc\u6c34\u592a\u591a\uff0c\u4e5f\u5fcc\u571f\u592a\u591a\u3002";
            }
            if (month >= 4 && month <= 6) {
                return "\u5fc5\u987b\u6709\u6c34\u76f8\u52a9\uff0c\u5fcc\u571f\u592a\u591a\uff0c\u4e5f\u5fcc\u6728\u592a\u591a\u3002";
            }
            if (month >= 7 && month <= 9) {
                return "\u5fc5\u987b\u6709\u91d1\u76f8\u52a9\uff0c\u4f46\u5fcc\u91d1\u592a\u591a\uff0c\u987b\u6709\u571f\u3001\u706b\u624d\u597d\uff0c\u4f46\u5fcc\u6c34\u591a\u3002";
            }
            if (month >= 10 && month <= 12) {
                return "\u5fc5\u987b\u6709\u706b\u76f8\u52a9\uff0c\u6700\u597d\u6709\u571f\u3001\u6c34\u3002";
            }
        } else if ("\u706b".equals(wuXingOfRiGan)) {
            if (month >= 1 && month <= 3) {
                return "\u6b64\u65f6\u5fc5\u4e3a\u4e19\u706b\u6216\u4e01\u706b\uff0c\u5927\u90fd\u4e0d\u9519\uff0c\u4f46\u5fcc\u6728\u591a\u3001\u571f\u591a\u3002";
            }
            if (month >= 4 && month <= 6) {
                return "\u5fc5\u987b\u6709\u6c34\u76f8\u52a9\uff0c\u6700\u559c\u6709\u91d1\u3002";
            }
            if (month >= 7 && month <= 9) {
                return "\u559c\u6709\u6728\uff0c\u5fcc\u6c34\u3001\u571f\u591a\u3002";
            }
            if (month >= 10 && month <= 12) {
                return "\u5fc5\u987b\u6709\u6728\u76f8\u52a9\uff0c\u5fcc\u6709\u6c34\u4e0e\u91d1\u591a\uff0c\u559c\u6709\u571f\u3001\u6c34\u3001\u6728\u3002";
            }
        } else if ("\u571f".equals(wuXingOfRiGan)) {
            if (month >= 1 && month <= 3) {
                return "\u559c\u6709\u706b\u3001\u6728\uff0c\u559c\u6709\u91d1\u800c\u5c11\uff0c\u5fcc\u91d1\u591a\u3001\u6728\u591a\u3002";
            }
            if (month >= 4 && month <= 6) {
                return "\u559c\u6709\u6c34\u3001\u91d1\uff0c\u5fcc\u6709\u6728\u3002";
            }
            if (month >= 7 && month <= 9) {
                return "\u559c\u6709\u706b\uff0c\u6709\u6728\uff0c\u5fcc\u91d1\u3001\u6c34\u591a\u3002";
            }
            if (month >= 10 && month <= 12) {
                return "\u559c\u6709\u706b\uff0c\u66f4\u559c\u6709\u706b\u53c8\u6709\u91d1\uff0c\u559c\u6709\u571f\u3001\u6728\u3002";
            }
        } else if ("\u91d1".equals(wuXingOfRiGan)) {
            if (month >= 1 && month <= 3) {
                return "\u559c\u6709\u571f\u3001\u706b\uff0c\u6700\u5fcc\u6ca1\u6709\u571f\u3001\u91d1\u3002";
            }
            if (month >= 4 && month <= 6) {
                return "\u5fc5\u987b\u6709\u6c34\u76f8\u52a9\uff0c\u5fcc\u6728\u591a\u3002";
            }
            if (month >= 7 && month <= 9) {
                return "\u559c\u6709\u6728\u3001\u706b\uff0c\u5fcc\u571f\u591a\u3002";
            }
            if (month >= 10 && month <= 12) {
                return "\u5fc5\u987b\u6709\u706b\u3001\u571f\u76f8\u52a9\uff0c\u5fcc\u65e0\u706b\u3001\u571f\u53cd\u800c\u6709\u91d1\u3001\u6c34\uff0c\u5fcc\u6728\u591a\u800c\u65e0\u706b\u3002";
            }
        } else if ("\u6c34".equals(wuXingOfRiGan)) {
            if (month >= 1 && month <= 3) {
                return "\u5fc5\u987b\u6709\u571f\u76f8\u52a9\uff0c\u82e5\u6709\u706b\uff0c\u91d1\uff0c\u4f46\u5fcc\u91d1\u591a\u3002";
            }
            if (month >= 4 && month <= 6) {
                return "\u5fc5\u987b\u6709\u91d1\u76f8\u52a9\uff0c\u5fcc\u6728\u591a\u3002";
            }
            if (month >= 7 && month <= 9) {
                return "\u5fc5\u987b\u6709\u91d1\u76f8\u52a9\uff0c\u5fcc\u571f\u3001\u91d1\u3001\u6c34\u591a\uff0c\u559c\u6728\u3001\u706b\u3002";
            }
            if (month >= 10 && month <= 12) {
                return "\u5fc5\u987b\u6709\u706b\u76f8\u52a9\uff0c\u559c\u6c34\u591a\uff0c\u4f46\u5fcc\u91d1\u591a\u3002";
            }
        }
        return "";
    }
}

