/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.chinese.fate.util;

import com.github.houbb.heaven.response.exception.CommonRuntimeException;
import com.github.houbb.heaven.util.util.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class CalendarUtil {
    private static final int[] LUNAR_INFO = new int[]{19416, 19168, 42352, 21717, 53856, 55632, 91476, 22176, 39632, 21970, 19168, 42422, 42192, 53840, 119381, 46400, 54944, 44450, 38320, 84343, 18800, 42160, 46261, 27216, 27968, 109396, 11104, 38256, 21234, 18800, 25958, 54432, 59984, 28309, 23248, 11104, 100067, 37600, 116951, 51536, 54432, 120998, 46416, 22176, 107956, 9680, 37584, 53938, 43344, 46423, 27808, 46416, 86869, 19872, 42448, 83315, 21200, 43432, 59728, 27296, 44710, 43856, 19296, 43748, 42352, 21088, 62051, 55632, 23383, 22176, 38608, 19925, 19152, 42192, 54484, 53840, 54616, 46400, 46496, 103846, 38320, 18864, 43380, 42160, 45690, 27216, 27968, 44870, 43872, 38256, 19189, 18800, 25776, 29859, 59984, 27480, 21952, 43872, 38613, 37600, 51552, 55636, 54432, 55888, 30034, 22176, 43959, 9680, 37584, 51893, 43344, 46240, 47780, 44368, 21977, 19360, 42416, 86390, 21168, 43312, 31060, 27296, 44368, 23378, 19296, 42726, 42208, 53856, 60005, 54576, 23200, 30371, 38608, 19415, 19152, 42192, 118966, 53840, 54560, 56645, 46496, 22224, 21938, 18864, 42359, 42160, 43600, 111189, 27936, 44448};
    private static final int MIN_YEAR = 1900;
    private static final int MAX_YEAR = 2049;
    private static final String START_DATE = "19000130";

    private CalendarUtil() {
    }

    private static int getLeapMonth(int year) {
        return LUNAR_INFO[year - 1900] & 0xF;
    }

    private static int getLeapMonthDays(int year) {
        if (CalendarUtil.getLeapMonth(year) != 0) {
            if ((LUNAR_INFO[year - 1900] & 0xF0000) == 0) {
                return 29;
            }
            return 30;
        }
        return 0;
    }

    private static int getMonthDays(int lunarYear, int month) {
        if (month > 31 || month < 0) {
            throw new CommonRuntimeException("\u6708\u4efd\u6709\u9519\uff01");
        }
        int bit = 1 << 16 - month;
        if ((LUNAR_INFO[lunarYear - 1900] & 0xFFFF & bit) == 0) {
            return 29;
        }
        return 30;
    }

    private static int getYearDays(int year) {
        int sum = 348;
        for (int i = 32768; i >= 8; i >>= 1) {
            if ((LUNAR_INFO[year - 1900] & 0xFFF0 & i) == 0) continue;
            ++sum;
        }
        return sum + CalendarUtil.getLeapMonthDays(year);
    }

    private static int daysBetween(Date startDate, Date endDate) {
        Calendar can;
        Calendar can1 = Calendar.getInstance();
        can1.setTime(startDate);
        Calendar can2 = Calendar.getInstance();
        can2.setTime(endDate);
        int year1 = can1.get(1);
        int year2 = can2.get(1);
        int days = 0;
        if (can1.before(can2)) {
            days -= can1.get(6);
            days += can2.get(6);
            can = can1;
        } else {
            days -= can2.get(6);
            days += can1.get(6);
            can = can2;
        }
        for (int i = 0; i < Math.abs(year2 - year1); ++i) {
            days += can.getActualMaximum(6);
            can.add(1, 1);
        }
        return days;
    }

    private static void checkLunarDate(int lunarYear, int lunarMonth, int lunarDay, boolean leapMonthFlag) {
        if (lunarYear < 1900 || lunarYear > 2049) {
            throw new IllegalArgumentException("\u975e\u6cd5\u519c\u5386\u5e74\u4efd\uff01");
        }
        if (lunarMonth < 1 || lunarMonth > 12) {
            throw new IllegalArgumentException("\u975e\u6cd5\u519c\u5386\u6708\u4efd\uff01");
        }
        if (lunarDay < 1 || lunarDay > 30) {
            throw new IllegalArgumentException("\u975e\u6cd5\u519c\u5386\u5929\u6570\uff01");
        }
        int leap = CalendarUtil.getLeapMonth(lunarYear);
        if (leapMonthFlag && lunarMonth != leap) {
            throw new IllegalArgumentException("\u975e\u6cd5\u95f0\u6708\uff01");
        }
    }

    public static String lunarToSolar(String lunarDate) {
        int tempMonthDaysCount;
        int i;
        boolean hasRunYear;
        int lunarYear = Integer.parseInt(lunarDate.substring(0, 4));
        int lunarMonth = Integer.parseInt(lunarDate.substring(4, 6));
        int lunarDay = Integer.parseInt(lunarDate.substring(6, 8));
        boolean leapMonthFlag = false;
        try {
            CalendarUtil.checkLunarDate(lunarYear, lunarMonth, lunarDay, leapMonthFlag);
        }
        catch (IllegalArgumentException e) {
            leapMonthFlag = true;
            CalendarUtil.checkLunarDate(lunarYear, lunarMonth, lunarDay, leapMonthFlag);
        }
        int offset = 0;
        for (int i2 = 1900; i2 < lunarYear; ++i2) {
            int yearDaysCount = CalendarUtil.getYearDays(i2);
            offset += yearDaysCount;
        }
        int leapMonth = CalendarUtil.getLeapMonth(lunarYear);
        if (leapMonthFlag & leapMonth != lunarMonth) {
            throw new IllegalArgumentException("\u60a8\u8f93\u5165\u7684\u95f0\u6708\u6807\u5fd7\u6709\u8bef\uff01");
        }
        boolean bl = hasRunYear = leapMonth == 0 || lunarMonth < leapMonth || lunarMonth == leapMonth && !leapMonthFlag;
        if (hasRunYear) {
            for (i = 1; i < lunarMonth; ++i) {
                tempMonthDaysCount = CalendarUtil.getMonthDays(lunarYear, i);
                offset += tempMonthDaysCount;
            }
            if (lunarDay > CalendarUtil.getMonthDays(lunarYear, lunarMonth)) {
                throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\u519c\u5386\u65e5\u671f\uff01");
            }
            offset += lunarDay;
        } else {
            int temp;
            for (i = 1; i < lunarMonth; ++i) {
                tempMonthDaysCount = CalendarUtil.getMonthDays(lunarYear, i);
                offset += tempMonthDaysCount;
            }
            if (lunarMonth > leapMonth) {
                temp = CalendarUtil.getLeapMonthDays(lunarYear);
                offset += temp;
                if (lunarDay > CalendarUtil.getMonthDays(lunarYear, lunarMonth)) {
                    throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\u519c\u5386\u65e5\u671f\uff01");
                }
                offset += lunarDay;
            } else {
                temp = CalendarUtil.getMonthDays(lunarYear, lunarMonth);
                offset += temp;
                if (lunarDay > CalendarUtil.getLeapMonthDays(lunarYear)) {
                    throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\u519c\u5386\u65e5\u671f\uff01");
                }
                offset += lunarDay;
            }
        }
        Date myDate = DateUtil.getFormatDate((String)START_DATE, (String)"yyyyMMdd");
        Calendar c = Calendar.getInstance();
        c.setTime(myDate);
        c.add(5, offset);
        myDate = c.getTime();
        return DateUtil.getDateFormat((Date)myDate, (String)"yyyyMMdd");
    }

    public static String solarToLunar(String solarDate) {
        int i;
        int temp = 0;
        boolean leapMonthFlag = false;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        Date myDate = null;
        Date startDate = null;
        try {
            myDate = formatter.parse(solarDate);
            startDate = formatter.parse(START_DATE);
        }
        catch (ParseException e) {
            throw new CommonRuntimeException((Throwable)e);
        }
        int offset = CalendarUtil.daysBetween(startDate, myDate);
        for (i = 1900; i <= 2049 && offset - (temp = CalendarUtil.getYearDays(i)) >= 1; ++i) {
            offset -= temp;
        }
        int lunarYear = i;
        int leapMonth = CalendarUtil.getLeapMonth(lunarYear);
        boolean isLeapYear = leapMonth > 0;
        for (i = 1; i <= 12; ++i) {
            if (i == leapMonth + 1 && isLeapYear) {
                temp = CalendarUtil.getLeapMonthDays(lunarYear);
                isLeapYear = false;
                --i;
            } else {
                temp = CalendarUtil.getMonthDays(lunarYear, i);
            }
            if ((offset -= temp) <= 0) break;
        }
        int lunarMonth = i;
        int lunarDay = offset += temp;
        return CalendarUtil.to2num(lunarYear) + CalendarUtil.to2num(lunarMonth) + CalendarUtil.to2num(lunarDay);
    }

    private static String to2num(int num) {
        if (num < 10) {
            return "0" + num;
        }
        return "" + num;
    }
}

