/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.sortedsets;

import com.github.fppt.jedismock.datastructures.RMZSet;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.exception.ArgumentException;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.sortedsets.AbstractByScoreOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

@RedisCommand(value="zadd")
class ZAdd
extends AbstractByScoreOperation {
    private final Object lock;
    private final EnumSet<Options> options = EnumSet.noneOf(Options.class);
    private int countAdd = 0;
    private int countChange = 0;

    ZAdd(OperationExecutorState state, List<Slice> params) {
        super(state.base(), params);
        this.lock = state.lock();
    }

    @Override
    protected Slice response() {
        this.parseParams();
        if (this.options.contains((Object)Options.NX) && (this.options.contains((Object)Options.GT) || this.options.contains((Object)Options.LT) || this.options.contains((Object)Options.XX))) {
            throw new ArgumentException("ERR syntax error");
        }
        if (this.options.contains((Object)Options.LT) && this.options.contains((Object)Options.GT)) {
            throw new ArgumentException("ERR syntax error");
        }
        return this.options.contains((Object)Options.INCR) ? this.incr() : this.adding();
    }

    private Slice incr() {
        Slice key = this.params().get(0);
        RMZSet mapDBObj = this.getZSetFromBaseOrCreateEmpty(key);
        if (this.params().size() != 3) {
            throw new ArgumentException("ERR INCR option supports a single increment-element pair");
        }
        String increment = this.params().get(1).toString();
        Slice member = this.params().get(2);
        double score = mapDBObj.getScore(member) == null ? 0.0 : mapDBObj.getScore(member);
        double newScore = this.getSum(score, increment);
        if (newScore != score) {
            this.addOneElement(mapDBObj, member, newScore);
            if (this.countChange + this.countAdd > 0) {
                mapDBObj.put(member, newScore);
                this.base().putValue(key, mapDBObj);
                this.lock.notifyAll();
                return Response.bulkString(Slice.create(String.valueOf(newScore)));
            }
        }
        return Response.NULL;
    }

    private Slice adding() {
        Slice key = this.params().get(0);
        RMZSet mapDBObj = this.getZSetFromBaseOrCreateEmpty(key);
        if ((this.params().size() & 1) == 0) {
            throw new ArgumentException("ERR syntax error");
        }
        if (this.options.contains((Object)Options.XX) && this.params().isEmpty()) {
            return Slice.empty();
        }
        for (int i = 1; i < this.params().size(); i += 2) {
            Slice score = this.params().get(i);
            Slice value = this.params().get(i + 1);
            double newScore = ZAdd.toDouble(score.toString());
            this.addOneElement(mapDBObj, value, newScore);
        }
        if (this.countAdd + this.countChange > 0) {
            this.base().putValue(key, mapDBObj);
            this.lock.notifyAll();
        }
        return this.options.contains((Object)Options.CH) ? Response.integer(this.countAdd + this.countChange) : Response.integer(this.countAdd);
    }

    private void addOneElement(RMZSet mapDBObj, Slice value, double newScore) {
        if (this.options.contains((Object)Options.XX) && mapDBObj.hasMember(value)) {
            this.updateValue(mapDBObj, value, newScore);
        }
        if (this.options.contains((Object)Options.NX) && !mapDBObj.hasMember(value)) {
            mapDBObj.put(value, newScore);
            ++this.countAdd;
        }
        if (!this.options.contains((Object)Options.XX) && !this.options.contains((Object)Options.NX)) {
            if (mapDBObj.hasMember(value)) {
                this.updateValue(mapDBObj, value, newScore);
            } else {
                mapDBObj.put(value, newScore);
                ++this.countAdd;
            }
        }
    }

    private void updateValue(RMZSet mapDBObj, Slice value, double newScore) {
        Double oldScore = mapDBObj.getScore(value);
        if (this.options.contains((Object)Options.LT) && oldScore > newScore || this.options.contains((Object)Options.GT) && oldScore < newScore || !this.options.contains((Object)Options.LT) && !this.options.contains((Object)Options.GT) && oldScore != newScore) {
            mapDBObj.put(value, newScore);
            ++this.countChange;
        }
    }

    private void parseParams() {
        Iterator<Slice> i = this.params().iterator();
        i.next();
        boolean quit = false;
        block0: while (i.hasNext() && !quit) {
            String opt = i.next().toString();
            quit = true;
            for (Options value : Options.values()) {
                if (!value.toString().equalsIgnoreCase(opt)) continue;
                this.options.add(value);
                i.remove();
                quit = false;
                continue block0;
            }
        }
    }

    static enum Options {
        XX,
        NX,
        LT,
        GT,
        CH,
        INCR;

    }
}

