/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import com.github.f4b6a3.uuid.enums.UuidVariant;
import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.util.UuidTime;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;

public final class UuidUtil {
    private static final String MESSAGE_NOT_A_TIME_BASED_UUID = "Not a time-based, time-ordered or DCE Security UUID: %s.";
    private static final String MESSAGE_NOT_A_TIME_ORDERED_EPOCH_UUID = "Not a time-ordered with Unix Epoch UUID: %s.";
    private static final String MESSAGE_NOT_A_DCE_SECURITY_UUID = "Not a DCE Security UUID: %s.";

    private UuidUtil() {
    }

    public static UUID copy(UUID uuid) {
        return new UUID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public static boolean isNil(UUID uuid) {
        Objects.requireNonNull(uuid, "Null UUID is not equal to Nil UUID");
        return uuid.getMostSignificantBits() == 0L && uuid.getLeastSignificantBits() == 0L;
    }

    public static boolean isMax(UUID uuid) {
        Objects.requireNonNull(uuid, "Null UUID is not equal to Max UUID");
        return uuid.getMostSignificantBits() == -1L && uuid.getLeastSignificantBits() == -1L;
    }

    public static UuidVersion getVersion(UUID uuid) {
        return UuidVersion.getVersion(uuid.version());
    }

    public static UuidVariant getVariant(UUID uuid) {
        return UuidVariant.getVariant(uuid.variant());
    }

    public static UUID setVersion(UUID uuid, int version) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        msb = msb & 0xFFFFFFFFFFFF0FFFL | (long)((version & 0xF) << 12);
        lsb = lsb & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new UUID(msb, lsb);
    }

    public static boolean isRfc4122(UUID uuid) {
        return UuidUtil.isVariant(uuid, UuidVariant.VARIANT_RFC_4122);
    }

    public static boolean isReservedNcs(UUID uuid) {
        return UuidUtil.isVariant(uuid, UuidVariant.VARIANT_RESERVED_NCS);
    }

    public static boolean isReservedMicrosoft(UUID uuid) {
        return UuidUtil.isVariant(uuid, UuidVariant.VARIANT_RESERVED_MICROSOFT);
    }

    public static boolean isReservedFuture(UUID uuid) {
        return UuidUtil.isVariant(uuid, UuidVariant.VARIANT_RESERVED_FUTURE);
    }

    public static boolean isRandomBased(UUID uuid) {
        return UuidUtil.isVersion(uuid, UuidVersion.VERSION_RANDOM_BASED);
    }

    public static boolean isNameBasedMd5(UUID uuid) {
        return UuidUtil.isVersion(uuid, UuidVersion.VERSION_NAME_BASED_MD5);
    }

    public static boolean isNameBasedSha1(UUID uuid) {
        return UuidUtil.isVersion(uuid, UuidVersion.VERSION_NAME_BASED_SHA1);
    }

    public static boolean isTimeBased(UUID uuid) {
        return UuidUtil.isVersion(uuid, UuidVersion.VERSION_TIME_BASED);
    }

    public static boolean isTimeOrdered(UUID uuid) {
        return UuidUtil.isVersion(uuid, UuidVersion.VERSION_TIME_ORDERED);
    }

    public static boolean isTimeOrderedEpoch(UUID uuid) {
        return UuidUtil.isVersion(uuid, UuidVersion.VERSION_TIME_ORDERED_EPOCH);
    }

    public static boolean isDceSecurity(UUID uuid) {
        return UuidUtil.isVersion(uuid, UuidVersion.VERSION_DCE_SECURITY);
    }

    public static boolean isCustom(UUID uuid) {
        return UuidUtil.isVersion(uuid, UuidVersion.VERSION_CUSTOM);
    }

    public static Instant getInstant(UUID uuid) {
        if (UuidUtil.isTimeOrderedEpoch(uuid)) {
            long unixTimestamp = UuidUtil.getUnixTimestamp(uuid);
            return UuidTime.fromUnixTimestamp(unixTimestamp);
        }
        long gregTimestamp = UuidUtil.getGregTimestamp(uuid);
        return UuidTime.fromGregTimestamp(gregTimestamp);
    }

    public static long getTimestamp(UUID uuid) {
        if (UuidUtil.isTimeOrderedEpoch(uuid)) {
            return UuidTime.toGregTimestamp(UuidUtil.getUnixTimestamp(uuid));
        }
        return UuidUtil.getGregTimestamp(uuid);
    }

    private static long getUnixTimestamp(UUID uuid) {
        if (UuidUtil.isTimeOrderedEpoch(uuid)) {
            return UuidUtil.getTimeOrderedEpochTimestamp(uuid.getMostSignificantBits());
        }
        throw new IllegalArgumentException(String.format(MESSAGE_NOT_A_TIME_ORDERED_EPOCH_UUID, uuid.toString()));
    }

    private static long getGregTimestamp(UUID uuid) {
        if (UuidUtil.isTimeBased(uuid)) {
            return UuidUtil.getTimeBasedTimestamp(uuid.getMostSignificantBits());
        }
        if (UuidUtil.isTimeOrdered(uuid)) {
            return UuidUtil.getTimeOrderedTimestamp(uuid.getMostSignificantBits());
        }
        if (UuidUtil.isDceSecurity(uuid)) {
            return UuidUtil.getTimeBasedTimestamp(uuid.getMostSignificantBits() & 0xFFFFFFFFL);
        }
        throw new IllegalArgumentException(String.format(MESSAGE_NOT_A_TIME_BASED_UUID, uuid.toString()));
    }

    public static long getNodeIdentifier(UUID uuid) {
        if (!(UuidUtil.isTimeBased(uuid) || UuidUtil.isTimeOrdered(uuid) || UuidUtil.isDceSecurity(uuid))) {
            throw new IllegalArgumentException(String.format(MESSAGE_NOT_A_TIME_BASED_UUID, uuid.toString()));
        }
        return uuid.getLeastSignificantBits() & 0xFFFFFFFFFFFFL;
    }

    public static int getClockSequence(UUID uuid) {
        if (!UuidUtil.isTimeBased(uuid) && !UuidUtil.isTimeOrdered(uuid) || UuidUtil.isDceSecurity(uuid)) {
            throw new IllegalArgumentException(String.format(MESSAGE_NOT_A_TIME_BASED_UUID, uuid.toString()));
        }
        if (UuidUtil.isDceSecurity(uuid)) {
            return (int)(uuid.getLeastSignificantBits() >>> 56) & 0x3F;
        }
        return (int)(uuid.getLeastSignificantBits() >>> 48) & 0x3FFF;
    }

    public static byte getLocalDomain(UUID uuid) {
        if (!UuidUtil.isDceSecurity(uuid)) {
            throw new IllegalArgumentException(String.format(MESSAGE_NOT_A_DCE_SECURITY_UUID, uuid.toString()));
        }
        return (byte)((uuid.getLeastSignificantBits() & 0xFF000000000000L) >>> 48);
    }

    public static int getLocalIdentifier(UUID uuid) {
        if (!UuidUtil.isDceSecurity(uuid)) {
            throw new IllegalArgumentException(String.format(MESSAGE_NOT_A_DCE_SECURITY_UUID, uuid.toString()));
        }
        return (int)(uuid.getMostSignificantBits() >>> 32);
    }

    private static boolean isVariant(UUID uuid, UuidVariant variant) {
        Objects.requireNonNull(uuid, "Null UUID");
        return uuid.variant() == variant.getValue();
    }

    private static boolean isVersion(UUID uuid, UuidVersion version) {
        Objects.requireNonNull(uuid, "Null UUID");
        return UuidUtil.isRfc4122(uuid) && uuid.version() == version.getValue();
    }

    private static long getTimeBasedTimestamp(long msb) {
        long hii = (msb & 0xFFFFFFFF00000000L) >>> 32;
        long mid = (msb & 0xFFFF0000L) << 16;
        long low = (msb & 0xFFFL) << 48;
        return hii | mid | low;
    }

    private static long getTimeOrderedTimestamp(long msb) {
        long himid = (msb & 0xFFFFFFFFFFFF0000L) >>> 4;
        long low = msb & 0xFFFL;
        return himid | low;
    }

    private static long getTimeOrderedEpochTimestamp(long msb) {
        long ticksPerMilli = 10000L;
        return ((msb & 0xFFFFFFFFFFFF0000L) >>> 16) * 10000L;
    }
}

