/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.enhance.dsl.where.sql.support;

import com.gitee.hengboy.mybatis.enhance.dsl.expression.ColumnExpression;
import com.gitee.hengboy.mybatis.enhance.dsl.where.sql.entity.ColumnWhereSQLEntity;
import com.gitee.hengboy.mybatis.enhance.dsl.where.sql.support.AbstractColumnWhereSupport;
import com.gitee.hengboy.mybatis.enhance.exception.EnhanceFrameworkException;
import java.util.Arrays;
import java.util.List;

public class InColumnWhereSupport
extends AbstractColumnWhereSupport {
    @Override
    public ColumnWhereSQLEntity getColumnWhere(ColumnExpression expression, int index) throws EnhanceFrameworkException {
        Object value = expression.getValues().get(index);
        if (value instanceof Object[]) {
            this.putArrayIns(expression, index, (Object[])value);
        } else if (value instanceof List) {
            this.putListIns(expression, index, (List)value);
        }
        return this.whereSQLEntity;
    }

    void putArrayIns(ColumnExpression expression, int index, Object[] values) {
        this.putListIns(expression, index, Arrays.asList(values));
    }

    void putListIns(ColumnExpression expression, int index, List<Object> values) {
        String placeholer = expression.getPlaceholers().get(index).getValue();
        String columnName = this.getColumnWithTableAlias(expression);
        StringBuffer sql = new StringBuffer();
        this.putInPreffix(placeholer, columnName, sql);
        for (int i = 0; i < values.size(); ++i) {
            this.putIns(expression, values.get(i), sql, i);
            sql.append(values.size() - 1 == i ? "" : ",");
        }
        this.putInSuffix(sql);
        this.whereSQLEntity.getSqls().add(sql.toString());
    }

    void putInPreffix(String placeholer, String columnName, StringBuffer sql) {
        sql.append(columnName + placeholer + "\n(");
    }

    void putInSuffix(StringBuffer sql) {
        sql.append(")");
    }

    void putIns(ColumnExpression expression, Object value, StringBuffer sql, int index) {
        String paramName = this.getParamName(expression, index);
        this.whereSQLEntity.getParamNames().add(paramName);
        this.whereSQLEntity.getValues().add(value);
        sql.append("#{" + paramName + "}");
    }
}

