/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.enhance.dsl.update.support;

import com.gitee.hengboy.mybatis.enhance.common.enums.PlaceholderEnum;
import com.gitee.hengboy.mybatis.enhance.dsl.expression.ColumnExpression;
import com.gitee.hengboy.mybatis.enhance.dsl.expression.TableExpression;
import com.gitee.hengboy.mybatis.enhance.dsl.factory.EnhanceDsl;
import com.gitee.hengboy.mybatis.enhance.dsl.update.Updateable;
import com.gitee.hengboy.mybatis.enhance.dsl.update.filter.SetFilter;
import com.gitee.hengboy.mybatis.enhance.dsl.where.support.WhereableSupport;
import com.gitee.hengboy.mybatis.enhance.exception.EnhanceFrameworkException;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.util.ObjectUtils;

public class UpdateableSupport
extends WhereableSupport
implements Updateable {
    protected TableExpression table;
    private EnhanceDsl enhanceDsl;

    public UpdateableSupport(EnhanceDsl enhanceDsl) {
        this.enhanceDsl = enhanceDsl;
    }

    @Override
    public Updateable update(TableExpression tableExpression) throws EnhanceFrameworkException {
        this.table = tableExpression;
        this.sql.UPDATE(this.table.getRoot());
        return this;
    }

    @Override
    public Updateable and(String sql) throws EnhanceFrameworkException {
        this.buildAnd(sql);
        return this;
    }

    @Override
    public Updateable where(ColumnExpression columnExpression, ColumnExpression ... columnExpressions) throws EnhanceFrameworkException {
        this.buildWhere(columnExpression, columnExpressions);
        return this;
    }

    @Override
    public Updateable and(ColumnExpression columnExpression, ColumnExpression ... columnExpressions) throws EnhanceFrameworkException {
        this.buildAnd(columnExpression, columnExpressions);
        return this;
    }

    @Override
    public Updateable or(ColumnExpression columnExpression, ColumnExpression ... columnExpressions) throws EnhanceFrameworkException {
        this.buildOr(columnExpression, columnExpressions);
        return this;
    }

    @Override
    public Updateable set(SetFilter setFilter) throws EnhanceFrameworkException {
        ColumnExpression columnExpression = setFilter.getColumnExpression();
        if (ObjectUtils.isEmpty((Object)columnExpression)) {
            throw new EnhanceFrameworkException("\u8bf7\u8f93\u5165\u66f4\u65b0\u5177\u4f53\u5217\u8868\u8fbe\u5f0f");
        }
        String columnName = this.getColumnWithTableAlias(columnExpression);
        String paramName = this.getParamName(columnExpression, PlaceholderEnum.SET.getValue().trim());
        this.sql.SET(columnName + "\t=\t#{" + paramName + "}\n");
        this.params.put(paramName, setFilter.getValue());
        return this;
    }

    @Override
    public Updateable set(SetFilter setFilter, SetFilter ... filters) throws EnhanceFrameworkException {
        ArrayList<SetFilter> setFilterList = new ArrayList<SetFilter>();
        setFilterList.add(setFilter);
        if (!ObjectUtils.isEmpty((Object[])filters)) {
            setFilterList.addAll(Arrays.asList(filters));
        }
        for (SetFilter filter : setFilterList) {
            this.set(filter);
        }
        return this;
    }

    @Override
    public void execute() throws EnhanceFrameworkException {
        if (ObjectUtils.isEmpty((Object)this.table)) {
            throw new EnhanceFrameworkException("\u8bf7\u5148\u8c03\u7528update\u65b9\u6cd5\u4f20\u9012\u66f4\u65b0\u8868\u7684\u52a8\u6001\u5b9e\u4f53.");
        }
        this.enhanceDsl.update(this);
    }
}

