/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.hengboy.mybatis.enhance.dsl.expression.support;

import com.gitee.hengboy.mybatis.enhance.common.enums.PlaceholderEnum;
import com.gitee.hengboy.mybatis.enhance.dsl.exception.ColumnException;
import com.gitee.hengboy.mybatis.enhance.dsl.expression.ColumnExpression;
import com.gitee.hengboy.mybatis.enhance.dsl.expression.interfaces.WhereExpression;
import com.gitee.hengboy.mybatis.enhance.dsl.expression.support.FunctionExpressionSupport;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.StringUtils;

public abstract class WhereExpressionSupport<T>
extends FunctionExpressionSupport<T>
implements WhereExpression<T> {
    private List<PlaceholderEnum> placeholers = new ArrayList<PlaceholderEnum>();
    private List<Object> values = new ArrayList<Object>();

    @Override
    public ColumnExpression<T> eq(Object value) throws ColumnException {
        this.values.add(value);
        this.placeholers.add(PlaceholderEnum.EQ);
        return this.getSlfe();
    }

    @Override
    public ColumnExpression<T> eqAll(Object ... eqs) throws ColumnException {
        this.values.add(eqs);
        this.placeholers.add(PlaceholderEnum.EQ);
        return this.getSlfe();
    }

    @Override
    public ColumnExpression<T> ne(Object value) throws ColumnException {
        this.values.add(value);
        this.placeholers.add(PlaceholderEnum.NEQ);
        return this.getSlfe();
    }

    @Override
    public ColumnExpression<T> neAll(List nes) throws ColumnException {
        this.values.add(nes);
        this.placeholers.add(PlaceholderEnum.NEQ);
        return this.getSlfe();
    }

    @Override
    public ColumnExpression<T> neAll(Object ... nes) throws ColumnException {
        this.values.add(nes);
        this.placeholers.add(PlaceholderEnum.NEQ);
        return this.getSlfe();
    }

    @Override
    public ColumnExpression<T> gt(Object value) throws ColumnException {
        this.values.add(value);
        this.placeholers.add(PlaceholderEnum.GT);
        return this.getSlfe();
    }

    @Override
    public ColumnExpression<T> gte(Object value) throws ColumnException {
        this.values.add(value);
        this.placeholers.add(PlaceholderEnum.GET);
        return this.getSlfe();
    }

    @Override
    public ColumnExpression<T> lt(Object value) throws ColumnException {
        this.values.add(value);
        this.placeholers.add(PlaceholderEnum.LT);
        return this.getSlfe();
    }

    @Override
    public ColumnExpression<T> lte(Object value) throws ColumnException {
        this.values.add(value);
        this.placeholers.add(PlaceholderEnum.LET);
        return this.getSlfe();
    }

    @Override
    public ColumnExpression<T> like(String preffix, Object value, String suffix) throws ColumnException {
        String formatterLikeValue = !StringUtils.isEmpty((Object)preffix) ? "%" : "";
        formatterLikeValue = formatterLikeValue + value;
        formatterLikeValue = formatterLikeValue + (!StringUtils.isEmpty((Object)suffix) ? "%" : "");
        this.values.add(formatterLikeValue);
        this.placeholers.add(PlaceholderEnum.LIKE);
        return this.getSlfe();
    }

    @Override
    public ColumnExpression<T> in(List ins) throws ColumnException {
        this.values.add(ins);
        this.placeholers.add(PlaceholderEnum.IN);
        return this.getSlfe();
    }

    @Override
    public ColumnExpression<T> in(Object ... ins) throws ColumnException {
        this.values.add(ins);
        this.placeholers.add(PlaceholderEnum.IN);
        return this.getSlfe();
    }

    @Override
    public ColumnExpression<T> isNull() throws ColumnException {
        this.values.add(null);
        this.placeholers.add(PlaceholderEnum.IS_NULL);
        return this.getSlfe();
    }

    @Override
    public ColumnExpression<T> isNotNull() throws ColumnException {
        this.values.add(null);
        this.placeholers.add(PlaceholderEnum.IS_NOT_NULL);
        return this.getSlfe();
    }

    @Override
    public ColumnExpression<T> isEmpty() throws ColumnException {
        this.values.add(null);
        this.placeholers.add(PlaceholderEnum.IS_EMPTY);
        return this.getSlfe();
    }

    @Override
    public ColumnExpression<T> isNotEmpty() throws ColumnException {
        this.values.add(null);
        this.placeholers.add(PlaceholderEnum.IS_NOT_EMPTY);
        return this.getSlfe();
    }

    public List<PlaceholderEnum> getPlaceholers() {
        return this.placeholers;
    }

    public List<Object> getValues() {
        return this.values;
    }
}

