/*
 * Decompiled with CFR 0.152.
 */
package com.getui.push.v2.sdk.core.registry;

import com.getui.push.v2.sdk.anno.method.GtDelete;
import com.getui.push.v2.sdk.anno.method.GtGet;
import com.getui.push.v2.sdk.anno.method.GtPost;
import com.getui.push.v2.sdk.anno.method.GtPut;
import com.getui.push.v2.sdk.common.ApiException;
import com.getui.push.v2.sdk.common.type.ParameterizedTypeImpl;
import com.getui.push.v2.sdk.common.type.TypeReference;
import com.getui.push.v2.sdk.common.util.Utils;
import com.getui.push.v2.sdk.core.factory.GtApiProxyFactory;
import com.getui.push.v2.sdk.core.registry.GtApiRegistry;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultGtApiRegistry
implements GtApiRegistry {
    private Map<String, GtApiProxyFactory.ApiParam> cache = new ConcurrentHashMap<String, GtApiProxyFactory.ApiParam>();

    @Override
    public void register(Method method) {
        this.get(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GtApiProxyFactory.ApiParam get(Method method) {
        GtApiProxyFactory.ApiParam apiParam = this.cache.get(method.toString());
        if (apiParam != null) {
            return apiParam;
        }
        Map<String, GtApiProxyFactory.ApiParam> map = this.cache;
        synchronized (map) {
            apiParam = this.cache.get(method.toString());
            if (apiParam != null) {
                return apiParam;
            }
            apiParam = this.doAnalise(method);
            this.cache.put(method.toString(), apiParam);
            return apiParam;
        }
    }

    private GtApiProxyFactory.ApiParam doAnalise(Method method) {
        GtApiProxyFactory.ApiParam apiParam = new GtApiProxyFactory.ApiParam();
        this.handleAnnotation(method.getAnnotations(), apiParam);
        Type[] types = ((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments();
        apiParam.setReturnType(new GtTypeHelper(method.getReturnType(), types).getType());
        return apiParam;
    }

    private GtApiProxyFactory.ApiParam handleAnnotation(Annotation[] annotations, GtApiProxyFactory.ApiParam apiParam) {
        if (apiParam == null) {
            throw new ApiException("apiParam cannot be null.");
        }
        for (Annotation annotation : annotations) {
            if (annotation instanceof GtGet) {
                apiParam.setMethod("GET");
                apiParam.setUri(((GtGet)annotation).uri());
                apiParam.setNeedToken(((GtGet)annotation).needToken());
                continue;
            }
            if (annotation instanceof GtPost) {
                apiParam.setMethod("POST");
                apiParam.setUri(((GtPost)annotation).uri());
                apiParam.setNeedToken(((GtPost)annotation).needToken());
                continue;
            }
            if (annotation instanceof GtPut) {
                apiParam.setMethod("PUT");
                apiParam.setUri(((GtPut)annotation).uri());
                apiParam.setNeedToken(((GtPut)annotation).needToken());
                continue;
            }
            if (annotation instanceof GtDelete) {
                apiParam.setMethod("DELETE");
                apiParam.setUri(((GtDelete)annotation).uri());
                apiParam.setNeedToken(((GtDelete)annotation).needToken());
                continue;
            }
            throw new ApiException("\u8bf7\u6dfb\u52a0\u8bf7\u6c42\u6ce8\u89e3 GtGet/GtPost/GtPut/GtDelete");
        }
        if (Utils.isEmpty(apiParam.getMethod())) {
            throw new UnsupportedOperationException();
        }
        return apiParam;
    }

    class GtTypeHelper
    extends TypeReference<Void> {
        final Class<?> aClass;
        final Type[] types;

        public GtTypeHelper(Class<?> aClass, Type[] types) {
            this.aClass = aClass;
            this.types = types;
        }

        @Override
        public Type getType() {
            return ParameterizedTypeImpl.make(this.aClass, this.types, null);
        }
    }
}

