/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.starter.plugins.cache.redis;

import com.gccloud.starter.plugins.cache.common.CacheUtils;
import com.gccloud.starter.plugins.cache.common.IStarterCache;
import com.gccloud.starter.plugins.cache.common.StarterL1Cache;
import com.gccloud.starter.plugins.cache.common.config.StarterCacheConfig;
import com.gccloud.starter.plugins.cache.common.config.StarterCacheTypeConfig;
import com.gccloud.starter.plugins.cache.common.policy.GetPolicy;
import com.gccloud.starter.plugins.cache.common.policy.PutPolicy;
import com.gccloud.starter.plugins.cache.pubsub.common.CacheClient;
import com.gccloud.starter.plugins.cache.pubsub.common.Command;
import com.gccloud.starter.plugins.cache.pubsub.common.IStarterCachePub;
import com.gccloud.starter.plugins.cache.redis.common.IRedisPool;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

@Component
@ConditionalOnProperty(prefix="gc.starter.component", name={"IStarterCache"}, havingValue="RedisCacheImpl", matchIfMissing=true)
public class RedisCacheImpl
implements IStarterCache {
    private static final Logger log = LoggerFactory.getLogger(RedisCacheImpl.class);
    @Autowired
    private StarterCacheConfig cacheConfig;
    @Autowired
    private StarterL1Cache l1;
    @Autowired
    private IRedisPool redisPool;
    @Autowired
    private IStarterCachePub cachePub;
    @Autowired
    private CacheClient cacheClient;

    public RedisCacheImpl() {
        log.info("----------------------------------------");
        log.info("\u542f\u7528Redis\u7f13\u5b58");
        log.info("----------------------------------------");
    }

    public void load() {
        log.info("----------------------------------------");
        log.info("\u5f00\u59cb\u4eceRedis\u4e2d\u52a0\u8f7d\u6570\u636e\u5230\u5185\u5b58\u4e2d");
        Stopwatch stopwatch = Stopwatch.createStarted();
        try (Jedis jedis = this.redisPool.getResource();){
            ScanResult scanResult;
            ScanParams scanParams = new ScanParams();
            scanParams.count(Integer.valueOf(100));
            scanParams.match(this.cacheConfig.getPrefix() + ":" + "*");
            String cursor = "0";
            do {
                List keyList;
                if ((keyList = (scanResult = jedis.scan(cursor, scanParams)).getResult()) == null) continue;
                for (String key : keyList) {
                    log.info("key = {}", (Object)key);
                    String redisValue = jedis.get(key);
                    String[] arr = key.split(":");
                    this.l1.put(arr[1], (Serializable)((Object)arr[2]), (Object)redisValue);
                }
            } while (!"0".equals(cursor = new String(scanResult.getCursorAsBytes(), "UTF-8")));
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        log.info("\u52a0\u8f7d\u5b8c\u6bd5,\u603b\u8017\u65f6: {} \u6beb\u79d2", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        log.info("----------------------------------------");
    }

    public void put(String type, Serializable key, Object val) {
        this.put(this.cacheConfig.getPrefix(), type, key, val, PutPolicy.ALL);
    }

    public void put(Class<?> type, Serializable key, Object val) {
        this.put(this.cacheConfig.getPrefix(), type.getSimpleName(), key, val, PutPolicy.ALL);
    }

    public void put(String type, Serializable key, Object val, PutPolicy putPolicy) {
        this.put(this.cacheConfig.getPrefix(), type, key, val, putPolicy);
    }

    public void put(Class<?> type, Serializable key, Object val, PutPolicy putPolicy) {
        this.put(this.cacheConfig.getPrefix(), type.getSimpleName(), key, val, putPolicy);
    }

    public void put(String prefix, String type, Serializable key, Object val) {
        this.put(prefix, type, key, val, PutPolicy.ALL);
    }

    public void put(String prefix, Class<?> type, Serializable key, Object val) {
        this.put(prefix, type.getSimpleName(), key, val, PutPolicy.ALL);
    }

    public void put(String prefix, Class<?> type, Serializable key, Object val, PutPolicy putPolicy) {
        this.put(prefix, type.getSimpleName(), key, val, putPolicy);
    }

    public void put(String prefix, String type, Serializable key, Object val, PutPolicy putPolicy) {
        PutPolicy putPolicy2 = putPolicy = putPolicy == null ? PutPolicy.ALL : putPolicy;
        if (PutPolicy.L1 == putPolicy || PutPolicy.ALL == putPolicy) {
            this.l1.put(type, key, val);
            if (PutPolicy.L1 == putPolicy) {
                return;
            }
        }
        if (PutPolicy.L2 == putPolicy || PutPolicy.ALL == putPolicy) {
            try (Jedis jedis = this.redisPool.getResource();){
                String realKey = prefix + ":" + type + ":" + key;
                StarterCacheTypeConfig cacheTypeConfig = (StarterCacheTypeConfig)this.cacheConfig.getTypeConfigMap().get(type);
                if (cacheTypeConfig == null || cacheTypeConfig.getTtl() == null || cacheTypeConfig.getTtl().equals(0)) {
                    jedis.set(realKey, CacheUtils.toString((Object)val));
                    return;
                }
                jedis.setex(realKey, cacheTypeConfig.getTtl().intValue(), CacheUtils.toString((Object)val));
                Command command = new Command(this.cacheClient.getCid(), 1, type, key);
                this.cachePub.publish(command);
            }
            catch (Exception e) {
                log.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
    }

    public <T> T get(String type, Serializable key, Class<T> responseType) {
        return this.get(this.cacheConfig.getPrefix(), type, key, responseType, GetPolicy.L1);
    }

    public <T> T get(Class<?> type, Serializable key, Class<T> responseType) {
        return this.get(this.cacheConfig.getPrefix(), type.getSimpleName(), key, responseType, GetPolicy.L1);
    }

    public <T> T get(String type, Serializable key, Class<T> responseType, GetPolicy getPolicy) {
        return this.get(this.cacheConfig.getPrefix(), type, key, responseType, getPolicy);
    }

    public <T> T get(Class<?> type, Serializable key, Class<T> responseType, GetPolicy getPolicy) {
        return this.get(this.cacheConfig.getPrefix(), type.getSimpleName(), key, responseType, getPolicy);
    }

    public <T> T get(String prefix, String type, Serializable key, Class<T> responseType) {
        return this.get(prefix, type, key, responseType, GetPolicy.L1);
    }

    public <T> T get(String prefix, Class<?> type, Serializable key, Class<T> responseType, GetPolicy getPolicy) {
        return this.get(prefix, type.getSimpleName(), key, responseType, getPolicy);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T get(String prefix, String type, Serializable key, Class<T> responseType, GetPolicy getPolicy) {
        GetPolicy getPolicy2 = getPolicy = getPolicy == null ? GetPolicy.L1 : getPolicy;
        if (GetPolicy.L1 == getPolicy) {
            return (T)this.l1.get(type, key, responseType);
        }
        if (GetPolicy.L2 != getPolicy) return null;
        try (Jedis jedis = this.redisPool.getResource();){
            String realKey = prefix + ":" + type + ":" + key.toString();
            String valStr = jedis.get(realKey);
            Object object = CacheUtils.convert((Object)valStr, responseType);
            return (T)object;
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return null;
    }

    public <T> List<T> getAll(String type, Class<T> responseType) {
        return this.getAll(this.cacheConfig.getPrefix(), type, responseType, GetPolicy.L1);
    }

    public <T> List<T> getAll(Class<?> type, Class<T> responseType) {
        return this.getAll(this.cacheConfig.getPrefix(), type.getSimpleName(), responseType, GetPolicy.L1);
    }

    public <T> List<T> getAll(String type, Class<T> responseType, GetPolicy getPolicy) {
        return this.getAll(this.cacheConfig.getPrefix(), type, responseType, getPolicy);
    }

    public <T> List<T> getAll(Class<?> type, Class<T> responseType, GetPolicy getPolicy) {
        return this.getAll(this.cacheConfig.getPrefix(), type.getSimpleName(), responseType, getPolicy);
    }

    public <T> List<T> getAll(String prefix, Class<?> type, Class<T> responseType, GetPolicy getPolicy) {
        return this.getAll(prefix, type.getSimpleName(), responseType, getPolicy);
    }

    public <T> List<T> getAll(String prefix, String type, Class<T> responseType, GetPolicy getPolicy) {
        GetPolicy getPolicy2 = getPolicy = getPolicy == null ? GetPolicy.L1 : getPolicy;
        if (GetPolicy.L1 == getPolicy) {
            return this.l1.getAll(type, responseType);
        }
        ArrayList valList = Lists.newArrayList();
        try (Jedis jedis = this.redisPool.getResource();){
            ScanResult scanResult;
            ScanParams scanParams = new ScanParams();
            scanParams.count(Integer.valueOf(100));
            scanParams.match(prefix + ":" + type + ":" + "*");
            String cursor = "0";
            do {
                List keyList;
                if ((keyList = (scanResult = jedis.scan(cursor, scanParams)).getResult()) == null) continue;
                for (String key : keyList) {
                    String redisValue = jedis.get(key);
                    Object val = CacheUtils.convert((Object)redisValue, responseType);
                    valList.add(val);
                }
            } while (!"0".equals(cursor = new String(scanResult.getCursorAsBytes(), "UTF-8")));
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return valList;
    }

    public void invalidate(String type, Serializable key) {
        this.invalidate(this.cacheConfig.getPrefix(), type, key);
    }

    public void invalidate(Class<?> type, Serializable key) {
        this.invalidate(this.cacheConfig.getPrefix(), type.getSimpleName(), key);
    }

    public void invalidate(String prefix, Class<?> type, Serializable key) {
        this.invalidate(prefix, type.getSimpleName(), key);
    }

    public void invalidate(String prefix, String type, Serializable key) {
        this.l1.invalidate(type, key);
        try (Jedis jedis = this.redisPool.getResource();){
            String realKey = prefix + ":" + type + ":" + key.toString();
            jedis.del(realKey);
            Command command = new Command(this.cacheClient.getCid(), 2, type, key);
            this.cachePub.publish(command);
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void invalidateAll(String type) {
        this.invalidateAll(this.cacheConfig.getPrefix(), type);
    }

    public void invalidateAll(Class<?> type) {
        this.invalidateAll(this.cacheConfig.getPrefix(), type.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAll(String prefix, String type) {
        this.l1.invalidateAll(type);
        ArrayList deletedKeyList = Lists.newArrayList();
        try (Jedis jedis = this.redisPool.getResource();){
            ScanResult scanResult;
            ScanParams scanParams = new ScanParams();
            scanParams.count(Integer.valueOf(100));
            scanParams.match(prefix + ":" + type + ":" + "*");
            String cursor = "0";
            do {
                List keyList;
                if ((keyList = (scanResult = jedis.scan(cursor, scanParams)).getResult()) == null) continue;
                deletedKeyList.addAll(keyList);
            } while (!"0".equals(cursor = new String(scanResult.getCursorAsBytes(), "UTF-8")));
            deletedKeyList.forEach(key -> jedis.del(key));
        }
        catch (Exception e) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        finally {
            Command command = new Command(this.cacheClient.getCid(), 3, type, null);
            this.cachePub.publish(command);
        }
    }
}

