/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.org.bouncycastle.cms;

import thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import thirdparty.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import thirdparty.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import thirdparty.org.bouncycastle.asn1.cms.RecipientIdentifier;
import thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import thirdparty.org.bouncycastle.cms.AuthAttributesProvider;
import thirdparty.org.bouncycastle.cms.CMSException;
import thirdparty.org.bouncycastle.cms.CMSSecureReadable;
import thirdparty.org.bouncycastle.cms.KeyTransRecipient;
import thirdparty.org.bouncycastle.cms.KeyTransRecipientId;
import thirdparty.org.bouncycastle.cms.Recipient;
import thirdparty.org.bouncycastle.cms.RecipientInformation;
import thirdparty.org.bouncycastle.cms.RecipientOperator;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo keyTransRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(keyTransRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = keyTransRecipientInfo;
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier.isTagged()) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(aSN1OctetString.getOctets());
        } else {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        }
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

