/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.org.bouncycastle.cms;

import java.io.IOException;
import thirdparty.org.bouncycastle.asn1.cms.KEKIdentifier;
import thirdparty.org.bouncycastle.asn1.cms.KEKRecipientInfo;
import thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import thirdparty.org.bouncycastle.cms.AuthAttributesProvider;
import thirdparty.org.bouncycastle.cms.CMSException;
import thirdparty.org.bouncycastle.cms.CMSSecureReadable;
import thirdparty.org.bouncycastle.cms.KEKRecipient;
import thirdparty.org.bouncycastle.cms.KEKRecipientId;
import thirdparty.org.bouncycastle.cms.Recipient;
import thirdparty.org.bouncycastle.cms.RecipientInformation;
import thirdparty.org.bouncycastle.cms.RecipientOperator;

public class KEKRecipientInformation
extends RecipientInformation {
    private KEKRecipientInfo info;

    KEKRecipientInformation(KEKRecipientInfo kEKRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(kEKRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = kEKRecipientInfo;
        KEKIdentifier kEKIdentifier = kEKRecipientInfo.getKekid();
        this.rid = new KEKRecipientId(kEKIdentifier.getKeyIdentifier().getOctets());
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException, IOException {
        return ((KEKRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

