/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc.importExport;

import com.exasol.jdbc.importExport.QueryManipulator;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryPattern {
    public static String getRegexQueryKey = "QueryType";
    public static String regexMainKey = "FirstPart";
    public static String regexSecureKey = "Secure";
    public static String regexFileType = "FileType";
    public static String regexErrorKey = "ErrorPart";
    public static String regexSecondaryKey = "SecondPart";
    public static String regexSecondarySecureKey = "SecondSecure";
    public static String CommentPattern = "(/\\*(.*)\\*/)";
    public static String CommentAndSpacePattern = "((\\s+" + CommentPattern + "*\\s*)|(\\s*" + CommentPattern + "*\\s+)|(\\s+))";
    static final Pattern ImpExpCSVFBVPattern = Pattern.compile("^\\s*" + CommentPattern + "*\\s*(?<" + getRegexQueryKey + ">IMPORT|EXPORT)[\\s(]+.+(?<" + regexMainKey + ">(?<" + regexSecureKey + ">LOCAL" + CommentAndSpacePattern + "(SECURE" + CommentAndSpacePattern + ")*)(?<" + regexFileType + ">CSV|FBV)+(" + CommentAndSpacePattern + "FILE" + CommentAndSpacePattern + "'([^']+?)')+).*$", 42);
    static final Pattern ImpErrCSVPattern = Pattern.compile("^\\s*" + CommentPattern + "*\\s*(?<" + getRegexQueryKey + ">IMPORT)[\\s(]+.+(?<" + regexMainKey + ">(?<" + regexSecureKey + ">LOCAL" + CommentAndSpacePattern + "(SECURE" + CommentAndSpacePattern + ")*)(?<" + regexFileType + ">CSV)+(" + CommentAndSpacePattern + "FILE" + CommentAndSpacePattern + "'([^']+?)')+).*(?<" + regexErrorKey + ">ERRORS" + CommentAndSpacePattern + "INTO" + CommentAndSpacePattern + "(?<" + regexSecondaryKey + ">(?<" + regexSecondarySecureKey + ">LOCAL" + CommentAndSpacePattern + "(SECURE" + CommentAndSpacePattern + ")*)CSV+(" + CommentAndSpacePattern + "FILE" + CommentAndSpacePattern + "'([^']+?)')+)).*$", 42);
    private String sql;
    private LinkedHashMap<SQLPatterns, Pattern> patterns;
    private boolean isMatching;
    private Matcher match;
    private String[] Files;
    private String[] ErrFiles;
    private boolean CSV;
    private boolean Secure;
    private SQLPatterns patternType;
    private LinkedHashMap<String, String> commentsMap;

    public QueryPattern() {
        this.InitializeParams();
        this.addPattern();
    }

    private void InitializeParams() {
        this.patterns = new LinkedHashMap();
        this.commentsMap = new LinkedHashMap();
        this.sql = null;
        this.isMatching = false;
        this.match = null;
        this.Files = null;
        this.ErrFiles = null;
        this.CSV = true;
        this.Secure = false;
        this.patternType = SQLPatterns.None;
    }

    public void addPattern() {
        this.patterns.put(SQLPatterns.IMPORT_ERROR, ImpErrCSVPattern);
        this.patterns.put(SQLPatterns.IMPORT_EXPORT_CSV_FBV, ImpExpCSVFBVPattern);
    }

    public void setParams() throws SQLException {
        this.Files = QueryPattern.GetFilesFromMatcher(this.getMatcher().group(regexMainKey));
        switch (this.patternType) {
            case EXPORT_CSV: 
            case EXPORT_SECURE_CSV: {
                QueryPattern.DummyFiles(this.Files);
                this.Secure = QueryPattern.isSecureQuery(this.getMatcher());
                this.CSV = true;
                break;
            }
            case IMPORT_CSV: 
            case IMPORT_SECURE_CSV: {
                this.Secure = QueryPattern.isSecureQuery(this.getMatcher());
                this.CSV = true;
                break;
            }
            case IMPORT_FBV: 
            case IMPORT_SECURE_FBV: {
                this.Secure = QueryPattern.isSecureQuery(this.getMatcher());
                this.CSV = false;
                break;
            }
            case EXPORT_FBV: 
            case EXPORT_SECURE_FBV: {
                this.Secure = QueryPattern.isSecureQuery(this.getMatcher());
                if (this.Files.length > 1) {
                    if (this.Secure) {
                        throw new SQLException("Only one secure FBV file can be specified in export.", "04505");
                    }
                    throw new SQLException("Only one FBV file can be specified in export.", "04503");
                }
                this.CSV = false;
                break;
            }
            case IMPORT_ERROR_CSV: 
            case IMPORT_SECURE_ERROR_CSV: {
                this.Secure = QueryPattern.isSecureQuery(this.getMatcher());
                this.CSV = true;
                this.ErrFiles = QueryPattern.GetFilesFromMatcher(this.match.group("SecondPart"));
            }
        }
    }

    public String getRandomString() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public String multiLineCommentReplacer(String SQL) {
        Matcher match = Pattern.compile("/\\*(.*?)\\*/", 34).matcher(SQL);
        while (match.find()) {
            for (int i = 0; i < match.groupCount(); ++i) {
                String fromSQL = match.group(i);
                String toSQL = "/*" + this.getRandomString() + "*/";
                SQL = SQL.replace(fromSQL, toSQL + " ");
                this.commentsMap.put(toSQL, fromSQL);
            }
        }
        return SQL;
    }

    public String singleLineCommentReplacer(String SQL) {
        Matcher match = Pattern.compile("--.*?(" + System.getProperty("line.separator") + "|\\n|$)", 34).matcher(SQL);
        while (match.find()) {
            for (int i = 0; i < match.groupCount(); ++i) {
                String fromSQL = match.group(i);
                String toSQL = "/*" + this.getRandomString() + "*/";
                SQL = SQL.replace(fromSQL, toSQL + " ");
                this.commentsMap.put(toSQL, fromSQL);
            }
        }
        return SQL;
    }

    public String replaceHashWithSingleLineComments(String SQL) {
        return this.replaceHashWithMultiLineComments(SQL);
    }

    public String replaceHashWithMultiLineComments(String SQL) {
        for (Map.Entry<String, String> hash : this.commentsMap.entrySet()) {
            if (!SQL.contains(hash.getKey())) continue;
            SQL = SQL.replace(hash.getKey() + " ", hash.getValue());
        }
        return SQL;
    }

    public String replaceHashWithComments(String SQL) {
        return this.replaceHashWithMultiLineComments(this.replaceHashWithSingleLineComments(SQL));
    }

    public String getCommentForHash(String hash) {
        return this.commentsMap.getOrDefault(hash, null);
    }

    private String replaceCommentsWithHash(String SQL) {
        return this.singleLineCommentReplacer(this.multiLineCommentReplacer(SQL));
    }

    public boolean Match(String SQL) throws SQLException {
        if (SQL == null) {
            throw new SQLException("[ERROR] SQL Query is not provided.");
        }
        if (!this.isImportExportQuery(SQL)) {
            return false;
        }
        if (this.getMatcher() == null) {
            SQL = this.replaceCommentsWithHash(SQL);
            for (Map.Entry<SQLPatterns, Pattern> pattern : this.patterns.entrySet()) {
                Matcher _match = pattern.getValue().matcher(SQL);
                if (!_match.matches()) continue;
                this.setMatcher(_match);
                this.setPatternType(QueryPattern.identifyPatternType(_match, pattern.getKey()));
                this.setIsMatching(_match.matches());
                this.setSql(SQL);
                this.setParams();
                break;
            }
        }
        return this.getIsMatching();
    }

    public static boolean isSecureQuery(Matcher _match) {
        return QueryManipulator.RemoveComment(_match.group(regexSecureKey)).trim().replaceAll("\\s+", " ").toUpperCase().startsWith("LOCAL SECURE");
    }

    public static boolean isImportQuery(Matcher _match) {
        return QueryManipulator.RemoveComment(_match.group(getRegexQueryKey)).trim().replaceAll("\\s+", " ").toUpperCase().startsWith("IMPORT");
    }

    public static boolean isCSVQuery(Matcher _match) {
        return QueryManipulator.RemoveComment(_match.group(regexFileType)).trim().replaceAll("\\s+", " ").toUpperCase().startsWith("CSV");
    }

    public static SQLPatterns identifyPatternType(Matcher _match, SQLPatterns PatternType) {
        boolean isSecure = QueryPattern.isSecureQuery(_match);
        boolean isImport = QueryPattern.isImportQuery(_match);
        boolean isCSV = QueryPattern.isCSVQuery(_match);
        SQLPatterns patternType = isImport ? (PatternType == SQLPatterns.IMPORT_EXPORT_CSV_FBV ? (isCSV ? (isSecure ? SQLPatterns.IMPORT_SECURE_CSV : SQLPatterns.IMPORT_CSV) : (isSecure ? SQLPatterns.IMPORT_SECURE_FBV : SQLPatterns.IMPORT_FBV)) : (isSecure ? SQLPatterns.IMPORT_SECURE_ERROR_CSV : SQLPatterns.IMPORT_ERROR_CSV)) : (isCSV ? (isSecure ? SQLPatterns.EXPORT_SECURE_CSV : SQLPatterns.EXPORT_CSV) : (isSecure ? SQLPatterns.EXPORT_SECURE_FBV : SQLPatterns.EXPORT_FBV));
        return patternType;
    }

    public static String[] GetFilesFromMatcher(String query) throws SQLException {
        try {
            String CommentPattern = "(/\\*((.|" + System.getProperty("line.separator") + ")*?)\\*/)";
            String SQL = String.join((CharSequence)" ", query.split(CommentPattern));
            Pattern pattern = Pattern.compile("File\\s+'(.*?)'+", 34);
            Matcher fileMatcher = pattern.matcher(SQL);
            ArrayList<String> allMatches = new ArrayList<String>();
            while (fileMatcher.find()) {
                allMatches.add(fileMatcher.group(1));
            }
            String[] Files = new String[allMatches.size()];
            return allMatches.toArray(Files);
        }
        catch (Exception ex) {
            throw new SQLException("[ERROR] Filenames cannot be parsed.");
        }
    }

    public static String CreateFilenameQueryComment(String[] files) {
        if (files.length <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < files.length - 1; ++i) {
            sb.append(String.format("file '%s' ", files[i]));
        }
        sb.append(String.format("file '%s'", files[files.length - 1]));
        return "/*" + sb + "*/";
    }

    private static void DummyFiles(String[] files) {
        for (String file : files) {
            File f = new File(file);
            if (f.exists() || f.isDirectory()) continue;
            try {
                f.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean isImportExportQuery(String query) {
        String sanitiarizedQuery = QueryManipulator.RemoveComment(query);
        Pattern impexpPattern = Pattern.compile("^.*?(IMPORT|EXPORT).*?((LOCAL).*?(CSV|FBV).*?(FILE)).*", 34);
        return impexpPattern.matcher(sanitiarizedQuery).matches();
    }

    private void setPatternType(SQLPatterns value) {
        this.patternType = value;
    }

    public SQLPatterns getPatternType() {
        return this.patternType;
    }

    private void setIsMatching(boolean value) {
        this.isMatching = value;
    }

    public boolean getIsMatching() {
        return this.isMatching;
    }

    private void setSql(String value) {
        this.sql = value;
    }

    public String getSql() {
        return this.sql;
    }

    public Matcher getMatcher() {
        return this.match;
    }

    private void setMatcher(Matcher _match) {
        this.match = _match;
    }

    public String[] getFiles() {
        return this.Files;
    }

    public String[] getErrFiles() {
        return this.ErrFiles;
    }

    public boolean isCSV() {
        return this.CSV;
    }

    public boolean isSecure() {
        return this.Secure;
    }

    public void setSecure(boolean value) {
        this.Secure = value;
    }

    public static enum SQLPatterns {
        IMPORT_EXPORT,
        IMPORT_CSV,
        IMPORT_SECURE_CSV,
        IMPORT_ERROR_CSV,
        IMPORT_SECURE_ERROR_CSV,
        EXPORT_CSV,
        EXPORT_SECURE_CSV,
        IMPORT_FBV,
        IMPORT_SECURE_FBV,
        EXPORT_FBV,
        EXPORT_SECURE_FBV,
        IMPORT_EXPORT_CSV_FBV,
        IMPORT_ERROR,
        None;

    }
}

