/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.spring;

import com.dtflys.forest.Forest;
import com.dtflys.forest.annotation.BindingVar;
import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.reflection.ForestVariableValue;
import com.dtflys.forest.spring.SpringMethodVariableValue;
import com.dtflys.forest.utils.NameUtils;
import com.dtflys.forest.utils.StringUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;

public class ForestBeanProcessor
implements InstantiationAwareBeanPostProcessor {
    private String bindingBeanVariableName(String name, String defaultName) {
        if (StringUtils.isNotBlank((String)name)) {
            return name;
        }
        return defaultName;
    }

    private String bindingMethodVariableName(String name, Method method) {
        if (StringUtils.isNotBlank((String)name)) {
            return name;
        }
        String methodName = method.getName();
        if (NameUtils.isGetter((String)methodName)) {
            return NameUtils.propNameFromGetter((String)methodName);
        }
        return methodName;
    }

    private void processBean(Object bean, Class<?> beanClass, String beanName) {
        Method[] methods;
        BindingVar classAnnotation = (BindingVar)AnnotationUtils.findAnnotation(beanClass, BindingVar.class);
        if (classAnnotation != null) {
            String confId = classAnnotation.configuration();
            ForestConfiguration configuration = null;
            configuration = StringUtils.isNotBlank((String)confId) ? Forest.config((String)confId) : Forest.config();
            String varName = this.bindingBeanVariableName(classAnnotation.value(), beanName);
            configuration.setVariableValue(varName, bean);
        }
        for (Method method : methods = beanClass.getDeclaredMethods()) {
            BindingVar annotation = method.getAnnotation(BindingVar.class);
            if (annotation == null) continue;
            String confId = annotation.configuration();
            ForestConfiguration configuration = null;
            configuration = StringUtils.isNotBlank((String)confId) ? Forest.config((String)confId) : Forest.config();
            String varName = this.bindingMethodVariableName(annotation.value(), method);
            SpringMethodVariableValue variableValue = new SpringMethodVariableValue(bean, method);
            configuration.setVariableValue(varName, (ForestVariableValue)variableValue);
        }
    }

    public Object postProcessBeforeInstantiation(Class<?> beanClass, String beanName) throws BeansException {
        return null;
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        Class<?> beanClass = bean.getClass();
        this.processBean(bean, beanClass, beanName);
        return true;
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        return pvs;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

