/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven.java;

import com.diffplug.spotless.maven.FormatterFactory;
import com.diffplug.spotless.maven.java.CleanthatJava;
import com.diffplug.spotless.maven.java.Eclipse;
import com.diffplug.spotless.maven.java.FormatAnnotations;
import com.diffplug.spotless.maven.java.GoogleJavaFormat;
import com.diffplug.spotless.maven.java.ImportOrder;
import com.diffplug.spotless.maven.java.PalantirJavaFormat;
import com.diffplug.spotless.maven.java.RemoveUnusedImports;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.Build;
import org.apache.maven.project.MavenProject;

public class Java
extends FormatterFactory {
    private static final String LICENSE_HEADER_DELIMITER = "(package|import|public|class|module) ";

    @Override
    public Set<String> defaultIncludes(MavenProject project) {
        Path projectDir = project.getBasedir().toPath();
        Build build = project.getBuild();
        return Stream.of(build.getSourceDirectory(), build.getTestSourceDirectory()).map(x$0 -> Paths.get(x$0, new String[0])).map(projectDir::relativize).map(Java::fileMask).collect(Collectors.toSet());
    }

    @Override
    public String licenseHeaderDelimiter() {
        return LICENSE_HEADER_DELIMITER;
    }

    public void addEclipse(Eclipse eclipse) {
        this.addStepFactory(eclipse);
    }

    public void addGoogleJavaFormat(GoogleJavaFormat googleJavaFormat) {
        this.addStepFactory(googleJavaFormat);
    }

    public void addImportOrder(ImportOrder importOrder) {
        this.addStepFactory(importOrder);
    }

    public void addPalantirJavaFormat(PalantirJavaFormat palantirJavaFormat) {
        this.addStepFactory(palantirJavaFormat);
    }

    public void addRemoveUnusedImports(RemoveUnusedImports removeUnusedImports) {
        this.addStepFactory(removeUnusedImports);
    }

    public void addFormatAnnotations(FormatAnnotations formatAnnotations) {
        this.addStepFactory(formatAnnotations);
    }

    public void addCleanthat(CleanthatJava cleanthat) {
        this.addStepFactory(cleanthat);
    }

    private static String fileMask(Path path) {
        Object dir = path.toString();
        if (!((String)dir).endsWith(File.separator)) {
            dir = (String)dir + File.separator;
        }
        return (String)dir + "**" + File.separator + "*.java";
    }
}

