/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.util;

import com.alibaba.druid.sql.parser.Lexer;
import com.dangdang.ddframe.rdb.sharding.exception.SQLParserException;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.SQLStatementType;
import com.dangdang.ddframe.rdb.sharding.util.ThrowableSQLExceptionMethod;
import com.google.common.base.CharMatcher;
import java.sql.SQLException;
import java.util.Collection;

public class SQLUtil {
    public static String getExactlyValue(String value) {
        return null == value ? null : CharMatcher.anyOf((CharSequence)"[]`'\"").removeFrom((CharSequence)value);
    }

    public static <T> void safeInvoke(Collection<T> throwableSQLExceptionObjects, ThrowableSQLExceptionMethod<T> method) throws SQLException {
        SQLException current = null;
        for (T each : throwableSQLExceptionObjects) {
            try {
                method.apply(each);
            }
            catch (SQLException exp) {
                if (null == current) {
                    current = exp;
                    continue;
                }
                current.setNextException(exp);
                current = exp;
            }
        }
        if (null != current) {
            throw current;
        }
    }

    public static SQLStatementType getTypeByStart(String sql) {
        Lexer lexer = new Lexer(sql);
        lexer.nextToken();
        while (true) {
            switch (lexer.token()) {
                case SELECT: {
                    return SQLStatementType.SELECT;
                }
                case INSERT: {
                    return SQLStatementType.INSERT;
                }
                case UPDATE: {
                    return SQLStatementType.UPDATE;
                }
                case DELETE: {
                    return SQLStatementType.DELETE;
                }
                case EOF: {
                    throw new SQLParserException("Unsupported SQL statement: [%s]", sql);
                }
            }
            lexer.nextToken();
        }
    }

    private SQLUtil() {
    }
}

