/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.router.strategy;

import com.dangdang.ddframe.rdb.sharding.api.ShardingValue;
import com.dangdang.ddframe.rdb.sharding.parser.result.router.SQLStatementType;
import com.dangdang.ddframe.rdb.sharding.router.strategy.MultipleKeysShardingAlgorithm;
import com.dangdang.ddframe.rdb.sharding.router.strategy.NoneKeyShardingAlgorithm;
import com.dangdang.ddframe.rdb.sharding.router.strategy.ShardingAlgorithm;
import com.dangdang.ddframe.rdb.sharding.router.strategy.SingleKeyShardingAlgorithm;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ShardingStrategy {
    private final Collection<String> shardingColumns;
    private final ShardingAlgorithm shardingAlgorithm;

    public ShardingStrategy(String shardingColumn, ShardingAlgorithm shardingAlgorithm) {
        this(Collections.singletonList(shardingColumn), shardingAlgorithm);
    }

    public Collection<String> doStaticSharding(SQLStatementType sqlStatementType, Collection<String> availableTargetNames, Collection<ShardingValue<?>> shardingValues) {
        if (shardingValues.isEmpty()) {
            Preconditions.checkState((!this.isInsertMultiple(sqlStatementType, availableTargetNames) ? 1 : 0) != 0, (Object)"INSERT statement should contain sharding value.");
            return availableTargetNames;
        }
        return this.doSharding(shardingValues, availableTargetNames);
    }

    public Collection<String> doDynamicSharding(Collection<ShardingValue<?>> shardingValues) {
        Preconditions.checkState((!shardingValues.isEmpty() ? 1 : 0) != 0, (Object)"Dynamic table should contain sharding value.");
        List<String> availableTargetNames = Collections.emptyList();
        return this.doSharding(shardingValues, availableTargetNames);
    }

    private Collection<String> doSharding(Collection<ShardingValue<?>> shardingValues, Collection<String> availableTargetNames) {
        if (this.shardingAlgorithm instanceof NoneKeyShardingAlgorithm) {
            return Collections.singletonList(((NoneKeyShardingAlgorithm)this.shardingAlgorithm).doSharding(availableTargetNames, shardingValues.iterator().next()));
        }
        if (this.shardingAlgorithm instanceof SingleKeyShardingAlgorithm) {
            SingleKeyShardingAlgorithm singleKeyShardingAlgorithm = (SingleKeyShardingAlgorithm)this.shardingAlgorithm;
            ShardingValue<?> shardingValue = shardingValues.iterator().next();
            switch (shardingValue.getType()) {
                case SINGLE: {
                    return Collections.singletonList(singleKeyShardingAlgorithm.doEqualSharding(availableTargetNames, shardingValue));
                }
                case LIST: {
                    return singleKeyShardingAlgorithm.doInSharding(availableTargetNames, shardingValue);
                }
                case RANGE: {
                    return singleKeyShardingAlgorithm.doBetweenSharding(availableTargetNames, shardingValue);
                }
            }
            throw new UnsupportedOperationException(((Object)((Object)shardingValue.getType())).getClass().getName());
        }
        if (this.shardingAlgorithm instanceof MultipleKeysShardingAlgorithm) {
            return ((MultipleKeysShardingAlgorithm)this.shardingAlgorithm).doSharding(availableTargetNames, shardingValues);
        }
        throw new UnsupportedOperationException(this.shardingAlgorithm.getClass().getName());
    }

    private boolean isInsertMultiple(SQLStatementType sqlStatementType, Collection<String> availableTargetNames) {
        return SQLStatementType.INSERT.equals((Object)sqlStatementType) && availableTargetNames.size() > 1;
    }

    @ConstructorProperties(value={"shardingColumns", "shardingAlgorithm"})
    public ShardingStrategy(Collection<String> shardingColumns, ShardingAlgorithm shardingAlgorithm) {
        this.shardingColumns = shardingColumns;
        this.shardingAlgorithm = shardingAlgorithm;
    }

    public Collection<String> getShardingColumns() {
        return this.shardingColumns;
    }
}

