/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.rdb.sharding.merger.pipeline.coupling;

import com.dangdang.ddframe.rdb.sharding.merger.ResultSetMergeContext;
import com.dangdang.ddframe.rdb.sharding.merger.resultset.memory.AbstractMemoryResultSet;
import com.dangdang.ddframe.rdb.sharding.merger.resultset.memory.row.GroupByResultSetRow;
import com.dangdang.ddframe.rdb.sharding.merger.resultset.memory.row.ResultSetRow;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.AggregationColumn;
import com.dangdang.ddframe.rdb.sharding.parser.result.merger.GroupByColumn;
import com.google.common.base.Optional;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public final class GroupByCouplingResultSet
extends AbstractMemoryResultSet {
    private final List<GroupByColumn> groupByColumns;
    private final List<AggregationColumn> aggregationColumns;
    private ResultSet resultSet;
    private boolean hasNext;

    public GroupByCouplingResultSet(ResultSet resultSet, ResultSetMergeContext resultSetMergeContext) throws SQLException {
        super(Collections.singletonList(resultSet));
        this.groupByColumns = resultSetMergeContext.getMergeContext().getGroupByColumns();
        this.aggregationColumns = resultSetMergeContext.getMergeContext().getAggregationColumns();
    }

    @Override
    protected void initRows(List<ResultSet> resultSets) throws SQLException {
        this.resultSet = resultSets.get(0);
        this.hasNext = this.resultSet.next();
    }

    @Override
    protected Optional<? extends ResultSetRow> nextRow() throws SQLException {
        if (!this.hasNext) {
            return Optional.absent();
        }
        GroupByResultSetRow result = new GroupByResultSetRow(this.resultSet, this.groupByColumns, this.aggregationColumns);
        List<Object> groupByValues = result.getGroupByValues();
        while (this.hasNext && (this.groupByColumns.isEmpty() || groupByValues.equals(result.getGroupByValues()))) {
            result.aggregate();
            this.hasNext = this.resultSet.next();
        }
        result.generateResult();
        return Optional.of((Object)result);
    }
}

