/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import java.io.Reader;
import java.sql.SQLException;

public class DmdbReader
extends Reader {
    public static final int IS_BLOB = 0;
    public static final int IS_CLOB = 1;
    public static final int IS_STRING = 2;
    public static final int IS_BYTE = 3;
    public static final int IS_FILE_TYPE = 4;
    private DmdbBlob ia = null;
    private DmdbClob ib = null;
    private int hr;
    private String it = null;
    byte[] iu = null;
    char[] iv = null;
    int iw = 0;
    static final int ix = 32000;
    static final int iy = 8000;
    int hu = 0;
    int iz;
    int iA;
    private boolean closed = false;
    long iB = -1L;

    public DmdbReader(Object object) {
        if (object instanceof DmdbBlob) {
            this.ia = (DmdbBlob)object;
            this.hr = 0;
        } else if (object instanceof DmdbClob) {
            this.ib = (DmdbClob)object;
            this.hr = 1;
        } else if (object instanceof String) {
            this.hr = 2;
            this.it = (String)object;
        } else if (object instanceof byte[]) {
            this.hr = 3;
            this.iu = (byte[])object;
        } else {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        }
    }

    protected DmdbReader(DmdbClob dmdbClob, long l2, long l3) {
        this.hr = 1;
        this.ib = dmdbClob;
        this.iw = (int)(l2 - 1L);
        this.iB = l3;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) {
        if (this.closed) {
            DBError.throwIOException(DBError.ECJDBC_STREAM_CLOSED.reason);
        }
        if (n2 < 0 || n3 < 0 || n2 + n3 > cArray.length) {
            DBError.throwIOException(DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.reason);
        }
        switch (this.hr) {
            case 0: {
                return this.readFromBlob(cArray, n2, n3);
            }
            case 1: {
                return this.readFromClob(cArray, n2, n3);
            }
            case 2: {
                return this.readFromString(cArray, n2, n3);
            }
            case 3: {
                return this.readFromByteArray(cArray, n2, n3);
            }
        }
        DBError.throwIOException("io read error.");
        return 0;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    private int readFromBlob(char[] cArray, int n2, int n3) {
        int n4;
        block10: {
            block9: {
                n4 = 0;
                if (this.ia != null) break block9;
                return -1;
            }
            if (this.iB < 0L) {
                this.iB = this.ia.do_length();
            }
            if (this.iu != null && (this.iz = this.iu.length) > this.hu || this.iB > (long)this.iw) break block10;
            return -1;
        }
        try {
            long l2 = 0L;
            l2 = this.iu == null ? this.iB - (long)this.iw : this.iB - (long)this.iw + (long)this.iz - (long)this.hu;
            int n5 = (int)(l2 > (long)n3 ? (long)n3 : l2);
            while (n4 < n5) {
                int n6;
                if (this.iu == null || (this.iz = this.iu.length) <= this.hu) {
                    n6 = (int)(this.iB - (long)this.iw > 32000L ? 32000L : this.iB - (long)this.iw);
                    this.iu = this.ia.do_getBytes(this.iw + 1, n6);
                    if (this.iu == null || this.iu.length <= 0) {
                        this.iu = new byte[0];
                        this.hu = 0;
                        this.iz = n6;
                        break;
                    }
                    this.hu = 0;
                    this.iz = n6;
                    this.iw += n6;
                }
                n6 = n5 - n4 < this.iz - this.hu ? n5 - n4 : this.iz - this.hu;
                int n7 = 0;
                while (n7 < n6) {
                    cArray[n2 + n7] = (char)this.iu[this.hu + n7];
                    ++n7;
                }
                n2 += n6;
                this.hu += n6;
                n4 += n6;
            }
        }
        catch (SQLException sQLException) {
            DBError.throwIOException(sQLException.getMessage());
        }
        return n4;
    }

    private int readFromClob(char[] cArray, int n2, int n3) {
        int n4;
        block9: {
            block8: {
                n4 = 0;
                if (this.ib != null) break block8;
                return -1;
            }
            if (this.iB < 0L) {
                this.iB = this.ib.do_length();
            }
            if (this.iv != null && (this.iA = this.iv.length) > this.hu || this.iB > (long)this.iw) break block9;
            return -1;
        }
        try {
            long l2 = 0L;
            l2 = this.iv == null ? this.iB - (long)this.iw : this.iB - (long)this.iw + (long)this.iA - (long)this.hu;
            int n5 = (int)(l2 > (long)n3 ? (long)n3 : l2);
            while (n4 < n5) {
                int n6;
                if (this.iv == null || (this.iA = this.iv.length) <= this.hu) {
                    n6 = (int)(this.iB - (long)this.iw > 8000L ? 8000L : this.iB - (long)this.iw);
                    String string = this.ib.do_getSubString(this.iw + 1, n6);
                    if (string == null || string.length() <= 0) {
                        this.iv = new char[0];
                        this.hu = 0;
                        this.iA = 0;
                        break;
                    }
                    this.iv = new char[n6];
                    string.getChars(0, n6, this.iv, 0);
                    this.hu = 0;
                    this.iw += n6;
                    this.iA = n6;
                }
                n6 = n5 - n4 < this.iA - this.hu ? n5 - n4 : this.iA - this.hu;
                System.arraycopy(this.iv, this.hu, cArray, n2, n6);
                n2 += n6;
                this.hu += n6;
                n4 += n6;
            }
        }
        catch (SQLException sQLException) {
            DBError.throwIOException(sQLException.getMessage());
        }
        return n4;
    }

    private int readFromString(char[] cArray, int n2, int n3) {
        int n4;
        if (this.it == null || (this.iA = this.it.length()) <= this.hu) {
            return -1;
        }
        int n5 = n4 = n3 > this.iA - this.hu ? this.iA - this.hu : n3;
        if (n2 + n4 > cArray.length) {
            DBError.throwIOException(DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.reason);
        }
        this.it.getChars(this.hu, this.hu + n4, cArray, n2);
        this.hu += n4;
        return n4;
    }

    private int readFromByteArray(char[] cArray, int n2, int n3) {
        int n4;
        if (this.iu == null || (this.iz = this.iu.length) <= this.hu) {
            return -1;
        }
        int n5 = n4 = n3 > this.iz - this.hu ? this.iz - this.hu : n3;
        if (n2 + n4 > cArray.length) {
            DBError.throwIOException(DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.reason);
        }
        int n6 = 0;
        while (n6 < n4) {
            cArray[n2 + n6] = (char)this.iu[n6 + this.hu];
            ++n6;
        }
        this.hu += n4;
        return n4;
    }
}

