/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.icc.oauth.model.v202010.SDK;

import com.dahuatech.hutool.log.Log;
import com.dahuatech.hutool.log.LogFactory;
import com.dahuatech.icc.oauth.exception.BusinessException;
import com.dahuatech.icc.oauth.http.IccClient;
import com.dahuatech.icc.oauth.model.v202010.OauthPwdAuthRequest;
import com.dahuatech.icc.oauth.model.v202010.OauthPwdAuthResponse;
import com.dahuatech.icc.oauth.model.v202010.oSDK.OauthParamConstant;

public class OauthPwdAuthSDK {
    private static final Log logger = LogFactory.get();

    public OauthPwdAuthResponse oauthPwdAuth(OauthPwdAuthRequest request) {
        OauthPwdAuthResponse response = null;
        try {
            request.valid();
            request.businessValid();
            request.setUrl(request.getOauthConfigBaseInfo().getHttpConfigInfo().getPrefixUrl() + request.getUrl().substring(8));
            response = new IccClient().doAction(request, request.getResponseClass());
        }
        catch (BusinessException businessException) {
            logger.error("\u5bc6\u7801\u8ba4\u8bc1\u6388\u6743\uff1a{}", (Throwable)businessException, businessException.getMessage(), new Object[0]);
            response = new OauthPwdAuthResponse();
            response.setCode(businessException.getCode());
            response.setErrMsg(businessException.getErrorMsg());
            response.setArgs(businessException.getArgs());
            response.setSuccess(false);
        }
        catch (Exception e) {
            logger.error("\u5bc6\u7801\u8ba4\u8bc1\u6388\u6743\uff1a{}", (Throwable)e, e.getMessage(), new Object[0]);
            response = new OauthPwdAuthResponse();
            response.setErrMsg(OauthParamConstant.SYSTEME_RROR.getErrMsg());
            response.setCode(OauthParamConstant.SYSTEME_RROR.getCode());
            response.setSuccess(false);
        }
        return response;
    }
}

