/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.usiflow.webframe.web.service.statistics;

import com.cpi.framework.dao.jpa.IBaseDao;
import com.cpi.framework.service.jpa.impl.BaseServiceImpl;
import com.cpi.usiflow.webframe.web.dao.statistics.WorkLoadDao;
import com.cpi.usiflow.webframe.web.model.flow.Processinst;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkLoadService
extends BaseServiceImpl<Processinst, Long> {
    @Autowired
    private WorkLoadDao workLoadDao;

    @Autowired
    public void setBaseDao(WorkLoadDao workLoadDao) {
        super.setBaseDao((IBaseDao)workLoadDao);
    }

    public List<Map<String, Object>> queryWorkLoad(Long orgid, String yearPre, String yearNext) {
        List<Map<String, Object>> list = this.workLoadDao.queryWorkLoad(orgid, yearPre, yearNext);
        return list;
    }

    public List<Map<String, Object>> queryWorkLoadSub(Long orgid, String yearPre, String yearNext) {
        List<Map<String, Object>> list = this.workLoadDao.queryWorkLoadSub(orgid, yearPre, yearNext);
        if (list == null || list.size() == 0) {
            list = this.workLoadDao.queryWorkLoad(orgid, yearPre, yearNext);
        }
        return list;
    }

    public List<Map<String, Object>> queryWorkLoadYear(Long orgid) {
        List<Map<String, Object>> list = this.workLoadDao.queryWorkLoadYear(orgid);
        ArrayList<Map<String, Object>> list1 = new ArrayList<Map<String, Object>>();
        int startYear = 2099;
        int endYear = 0;
        for (Map<String, Object> map : list) {
            int temp = Integer.parseInt(map.get("yearvalue").toString());
            if (temp < startYear) {
                startYear = temp;
            }
            if (temp <= endYear) continue;
            endYear = temp;
        }
        for (int year = startYear; year <= endYear; ++year) {
            Map<String, Object> map;
            if (this.isContainsYear(year, list) != null) {
                list1.add(this.isContainsYear(year, list));
                continue;
            }
            map = new HashMap<String, Object>();
            map.put("yearvalue", year);
            map.put("finishValue", 0);
            map.put("createValue", 0);
            list1.add(map);
        }
        return list1;
    }

    private Map<String, Object> isContainsYear(int year, List<Map<String, Object>> list) {
        for (Map<String, Object> temp : list) {
            if (Integer.parseInt(temp.get("yearvalue").toString()) != year) continue;
            return temp;
        }
        return null;
    }

    public List<Map<String, Object>> queryWorkLoadMonth(Long orgid) {
        List<Map<String, Object>> list = this.workLoadDao.queryWorkLoadMonth(orgid);
        ArrayList<Map<String, Object>> list1 = new ArrayList<Map<String, Object>>();
        int startYear = 2099;
        int endYear = 0;
        for (Map<String, Object> map : list) {
            int temp = Integer.parseInt(map.get("yearvalue").toString());
            if (temp < startYear) {
                startYear = temp;
            }
            if (temp <= endYear) continue;
            endYear = temp;
        }
        for (int year = startYear; year <= endYear; ++year) {
            for (int month = 1; month <= 12; ++month) {
                if (this.isContainsMonth(year, month, list) != null) {
                    list1.add(this.isContainsMonth(year, month, list));
                    continue;
                }
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put("yearvalue", year);
                map.put("monthvalue", month);
                map.put("finishValue", 0);
                map.put("createValue", 0);
                list1.add(map);
            }
        }
        return list1;
    }

    private Map<String, Object> isContainsMonth(int year, int month, List<Map<String, Object>> list) {
        for (Map<String, Object> temp : list) {
            if (Integer.parseInt(temp.get("yearvalue").toString()) != year || Integer.parseInt(temp.get("monthvalue").toString()) != month) continue;
            return temp;
        }
        return null;
    }
}

