/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.usiflow.webframe.web.controller.flowadmin;

import com.cpi.framework.dao.support.Filter;
import com.cpi.framework.dao.support.Order;
import com.cpi.framework.dao.support.Pageable;
import com.cpi.framework.dao.support.Pagination;
import com.cpi.framework.modules.security.shiro.Principal;
import com.cpi.framework.web.common.ResponseData;
import com.cpi.framework.web.controller.BaseController;
import com.cpi.framework.web.entity.admin.FwOrg;
import com.cpi.framework.web.entity.admin.FwRoles;
import com.cpi.framework.web.entity.admin.FwUser;
import com.cpi.framework.web.service.admin.IFwUserService;
import com.cpi.usiflow.webframe.flow.FlowSpringBeanUtil;
import com.cpi.usiflow.webframe.flow.ProcessEnginerHolder;
import com.cpi.usiflow.webframe.web.model.flow.BusinessProcess;
import com.cpi.usiflow.webframe.web.model.flow.BusinessType;
import com.cpi.usiflow.webframe.web.model.flow.WfProcessDefine;
import com.cpi.usiflow.webframe.web.model.flow.WorkItem;
import com.cpi.usiflow.webframe.web.service.admin.OrganizationService;
import com.cpi.usiflow.webframe.web.service.admin.RoleService;
import com.cpi.usiflow.webframe.web.service.flow.BusinessProcessService;
import com.cpi.usiflow.webframe.web.service.flow.BusinessTypeService;
import com.cpi.usiflow.webframe.web.service.flow.ProcessDefineService;
import com.cpi.usiflow.webframe.web.service.flow.WorkItemService;
import com.ustcsoft.usiflow.core.util.PrimaryKeyUtil;
import com.ustcsoft.usiflow.engine.model.ActivityInst;
import com.ustcsoft.usiflow.engine.model.ProcessDefine;
import com.ustcsoft.usiflow.engine.model.TransCtrl;
import com.ustcsoft.usiflow.engine.service.IActivityInstService;
import com.ustcsoft.usiflow.engine.service.IProcessDefineService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/workItem"})
public class WorkItemController
extends BaseController {
    private static final String PROCESSDEFNAME_PREFIX = "workItem.";
    @Autowired
    private BusinessTypeService businessTypeService;
    @Autowired
    private BusinessProcessService businessProcessService;
    @Autowired
    private ProcessDefineService processDefineService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private OrganizationService organizationService;
    @Resource(name="FwUserServiceImpl")
    private IFwUserService userService;
    @Autowired
    private WorkItemService workItemService;

    @RequestMapping(value={"/index"})
    public String index() {
        return "workflow/workItem";
    }

    private void getAllParentLabel(BusinessType bt, List<BusinessType> list, StringBuilder sb) {
        ArrayList<BusinessType> temp2 = new ArrayList<BusinessType>();
        for (BusinessType businessType : list) {
            if (businessType.getParentId() != bt.getId()) continue;
            temp2.add(businessType);
            sb.append("<node id=\"" + businessType.getId() + "\" label=\"" + businessType.getName() + "\" type=\"organization\" >\n");
            if ("N".equals(businessType.getLeafNode())) {
                this.getAllParentLabel(businessType, list, sb);
            }
            sb.append("</node>\n");
        }
    }

    @RequestMapping(value={"/queryWorkItem"})
    @ResponseBody
    public void queryWorkItem(Long node, HttpServletResponse response) throws IOException {
        if (node == null) {
            node = 0L;
        }
        List<BusinessType> list = this.businessTypeService.queryBusinessType();
        ArrayList<BusinessType> temp = new ArrayList<BusinessType>();
        for (BusinessType businessType : list) {
            if (businessType.getParentId() != 0L) continue;
            temp.add(businessType);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        for (int i = 0; i < temp.size(); ++i) {
            sb.append("<node id=\"" + ((BusinessType)temp.get(i)).getId() + "\" label=\"" + ((BusinessType)temp.get(i)).getName() + "\" type=\"organization\" >\n");
            if ("N".equals(((BusinessType)temp.get(i)).getLeafNode())) {
                this.getAllParentLabel((BusinessType)temp.get(i), list, sb);
            }
            sb.append("</node>\n");
        }
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/queryWorkFlow"})
    @ResponseBody
    public void queryWorkFlow(BusinessProcess bP, @RequestParam(required=false) String dir, HttpServletResponse response) throws IOException {
        Filter filter;
        List list = new ArrayList();
        Pageable paginationRequest = new Pageable();
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        if (StringUtils.hasText((String)bP.getFlowName())) {
            filter = new Filter("flowName", Filter.Operator.like, (Object)bP.getFlowName());
            filterList.add(filter);
        }
        if (StringUtils.hasText((String)bP.getType())) {
            filter = new Filter("type", Filter.Operator.like, (Object)bP.getType());
            filterList.add(filter);
        }
        paginationRequest.setFilters(filterList);
        Pagination pgn = this.businessProcessService.findPage(paginationRequest);
        list = pgn.getResult();
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<node>");
        for (BusinessProcess businessProcess : list) {
            String memo = businessProcess.getMemo() == null ? "" : businessProcess.getMemo();
            sb.append("<node id=\"" + businessProcess.getId() + "\" name=\"" + businessProcess.getFlowName() + "\" memo=\"" + memo + "\" busiId=\"" + businessProcess.getBusinessTypeId() + "\" type=\"" + businessProcess.getType() + "\" defName=\"" + businessProcess.getType() + "." + businessProcess.getId() + "\" dgSelected=\"false\" " + " >\n");
            sb.append("</node>");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/queryWorkFlowVersion"})
    @ResponseBody
    public void queryWorkFlowVersion(WfProcessDefine pD, @RequestParam(required=false) String dir, HttpServletResponse response) throws IOException {
        String processDefName = pD.getProcessDefName();
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        Filter filter = new Filter("processDefName", Filter.Operator.eq, (Object)processDefName);
        filterList.add(filter);
        List list = this.processDefineService.findList(null, filterList, null);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<node>");
        for (WfProcessDefine processDefine : list) {
            sb.append("<node id=\"" + processDefine.getProcessDefId() + "\" name=\"" + processDefine.getProcesschname() + "\" defName=\"" + processDefine.getProcessDefName() + "\" versionsign=\"" + processDefine.getVersionsign() + "\" createName=\"" + processDefine.getCreateName() + "\" createTime=\"" + processDefine.getCreatetime() + "\" updateTime=\"" + processDefine.getUpdatetime() + "\" limitTime=\"" + processDefine.getLimittime() + "\" currentState=\"" + processDefine.getCurrentstate() + "\" description=\"" + processDefine.getDescription() + "\" dgSelected=\"false\" " + " >\n");
            sb.append("</node>");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/queryWorkItemW"})
    @ResponseBody
    public void queryWorkItemW(Long activityinstid, HttpServletResponse response) throws IOException {
        List<WorkItem> list = this.workItemService.queryWorkItem(activityinstid);
        ArrayList<WorkItem> temp = new ArrayList<WorkItem>();
        for (WorkItem workItem : list) {
            temp.add(workItem);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<node>");
        for (int i = 0; i < temp.size(); ++i) {
            sb.append("<node workitemid=\"" + ((WorkItem)temp.get(i)).getWorkitemid() + "\" workitemname=\"" + ((WorkItem)temp.get(i)).getWorkitemname() + "\" currentstate=\"" + ((WorkItem)temp.get(i)).getCurrentstate() + "\" participant=\"" + (StringUtils.isEmpty((Object)((WorkItem)temp.get(i)).getParticipant()) || ((WorkItem)temp.get(i)).getParticipant().equals("null") ? "" : ((WorkItem)temp.get(i)).getParticipant()) + "\" starttime=\"" + ((WorkItem)temp.get(i)).getStarttime() + "\" endtime=\"" + ((WorkItem)temp.get(i)).getEndtime() + "\" workmemory=\"" + ((WorkItem)temp.get(i)).getWorkmemory() + "\" istimeout=\"" + this.getTimeOut(((WorkItem)temp.get(i)).getStarttime(), ((WorkItem)temp.get(i)).getEndtime(), ((WorkItem)temp.get(i)).getLimittime()) + "\">\n");
            sb.append("</node>\n");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/queryWorkItemByDefid"})
    @ResponseBody
    public void queryWorkItemByDefid(Long processinstid, String activitydefid, HttpServletResponse response) throws IOException {
        List<WorkItem> list = this.workItemService.queryWorkItemByDefid(processinstid, activitydefid);
        ArrayList<WorkItem> temp = new ArrayList<WorkItem>();
        for (WorkItem workItem : list) {
            temp.add(workItem);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<node>");
        for (int i = 0; i < temp.size(); ++i) {
            sb.append("<node workitemid=\"" + ((WorkItem)temp.get(i)).getWorkitemid() + "\" workitemname=\"" + ((WorkItem)temp.get(i)).getWorkitemname() + "\" currentstate=\"" + ((WorkItem)temp.get(i)).getCurrentstate() + "\" participant=\"" + (StringUtils.isEmpty((Object)((WorkItem)temp.get(i)).getParticipant()) || ((WorkItem)temp.get(i)).getParticipant().equals("null") ? "" : ((WorkItem)temp.get(i)).getParticipant()) + "\" starttime=\"" + ((WorkItem)temp.get(i)).getStarttime() + "\" endtime=\"" + ((WorkItem)temp.get(i)).getEndtime() + "\" workmemory=\"" + ((WorkItem)temp.get(i)).getWorkmemory() + "\" istimeout=\"" + this.getTimeOut(((WorkItem)temp.get(i)).getStarttime(), ((WorkItem)temp.get(i)).getEndtime(), ((WorkItem)temp.get(i)).getLimittime()) + "\">\n");
            sb.append("</node>\n");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    private String getTimeOut(Date starttime, Date endtime, Long limittime) {
        String result = "";
        if (limittime == 0L) {
            return "0";
        }
        if (starttime == null) {
            result = "0";
        } else {
            Date lasttime = new Date();
            if (endtime != null) {
                lasttime = endtime;
            }
            result = lasttime.getTime() - starttime.getTime() > limittime * 1000L * 60L ? "1" : "0";
        }
        return result;
    }

    @RequestMapping(value={"/saveWorkItem"})
    @ResponseBody
    public Long saveWorkItem(BusinessProcess businessProcess) {
        long workItem = 0L;
        try {
            if (businessProcess.getId() != null) {
                this.businessProcessService.update(businessProcess);
            } else {
                this.businessProcessService.save(businessProcess);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
        return workItem;
    }

    @RequestMapping(value={"/publishWorkFlow"})
    @ResponseBody
    public Long publishWorkFlow(WfProcessDefine wProcessDefine) {
        long workItem = 0L;
        String processDefName = wProcessDefine.getProcessDefName();
        Long processDefId = wProcessDefine.getProcessDefId();
        IProcessDefineService iProcessDefineService = ProcessEnginerHolder.getInstance().getProcessDefineService();
        iProcessDefineService.publishProcessDefine(processDefName, processDefId.longValue());
        return workItem;
    }

    @RequestMapping(value={"/cancelWorkFlow"})
    @ResponseBody
    public Long cancelWorkFlow(WfProcessDefine wProcessDefine) {
        long workItem = 0L;
        return workItem;
    }

    @RequestMapping(value={"/queryFlows"})
    @ResponseBody
    public List queryFlows(Long node, @RequestParam(required=false) String leafNode, @RequestParam(required=false) String type) {
        if (node == null) {
            node = 0L;
        }
        if (StringUtils.hasText((String)leafNode) && "Y".equals(leafNode)) {
            ArrayList<Filter> filterList = new ArrayList<Filter>();
            Filter filter = new Filter("businessTypeId", Filter.Operator.eq, (Object)node);
            filterList.add(filter);
            ArrayList<Order> orderList = new ArrayList<Order>();
            Order order = new Order("id", Order.Direction.asc);
            orderList.add(order);
            List list = this.businessProcessService.findList(null, filterList, orderList);
            for (BusinessProcess busiProcess : list) {
                if (!"subflow".equals(busiProcess.getType())) continue;
                busiProcess.setIconCls("subflow");
            }
            return list;
        }
        if ("flow".equals(type) || "subflow".equals(type)) {
            IProcessDefineService iProcessDefineService = ProcessEnginerHolder.getInstance().getProcessDefineService();
            List list = iProcessDefineService.findProcessDefines(PROCESSDEFNAME_PREFIX + node);
            ArrayList processDefines = new ArrayList();
            for (ProcessDefine define : list) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", define.getProcessDefId());
                if (define.getCurrentState() == 3) {
                    map.put("text", define.getVersionSign() + "*");
                } else {
                    map.put("text", define.getVersionSign());
                }
                map.put("processDefName", define.getProcessDefId());
                map.put("versionSign", define.getVersionSign());
                map.put("leaf", true);
                map.put("iconCls", "version");
                map.put("type", "version");
                processDefines.add(map);
            }
            return processDefines;
        }
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        Filter filter = new Filter("parentId", Filter.Operator.eq, (Object)node);
        filterList.add(filter);
        ArrayList<Order> orderList = new ArrayList<Order>();
        Order order = new Order("orderIndex", Order.Direction.asc);
        orderList.add(order);
        List list = this.businessTypeService.findList(null, filterList, orderList);
        for (BusinessType businessType : list) {
            businessType.setLeaf(false);
            if (!"Y".equals(businessType.getLeafNode())) continue;
            businessType.setIconCls("leaf");
        }
        return list;
    }

    @RequestMapping(value={"/queryFlowContent"})
    @ResponseBody
    public void queryFlowContent(Long id, HttpServletResponse response) throws IOException {
        IProcessDefineService iProcessDefineService = ProcessEnginerHolder.getInstance().getProcessDefineService();
        ProcessDefine processDefine = iProcessDefineService.findProcessDefine(id.longValue());
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(processDefine.getProcessDefContent());
    }

    @RequestMapping(value={"/queryParticipant4Org"})
    @ResponseBody
    public void queryParticipant4Org(Long id, HttpServletResponse response) throws IOException {
        if (id == null) {
            id = 0L;
        }
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        Filter filter = new Filter("parentId", Filter.Operator.eq, (Object)id);
        filterList.add(filter);
        List orgs = this.organizationService.findList(null, filterList, null);
        ArrayList<Filter> userfilterList = new ArrayList<Filter>();
        Filter userfilter = new Filter("orgId", Filter.Operator.eq, (Object)id);
        userfilterList.add(userfilter);
        List users = this.userService.findList(null, userfilterList, null);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node>\n");
        for (FwOrg org : orgs) {
            sb.append("<node id=\"" + org.getId() + "\" name=\"" + org.getOrgName() + "\" type=\"organization\" />\n");
        }
        for (FwUser user : users) {
            sb.append("<node id=\"" + user.getId() + "\" name=\"" + user.getUsername() + "\" type=\"person\" />\n");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/queryParticipant4Role"})
    @ResponseBody
    public void queryParticipant4Role(Long id, HttpServletResponse response) throws IOException {
        if (id == null) {
            id = 0L;
        }
        List list = this.roleService.findAll();
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node>\n");
        for (FwRoles role : list) {
            sb.append("<node id=\"" + role.getId() + "\" name=\"" + role.getRoleName() + "\" type=\"role\" />\n");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/querySubFlow"})
    @ResponseBody
    public void querySubFlow(Long id, HttpServletResponse response) throws IOException {
        List busiTypes = null;
        List busiProcesses = null;
        if (id == 0L) {
            ArrayList<Filter> filterList = new ArrayList<Filter>();
            Filter filter = new Filter("parentId", Filter.Operator.eq, (Object)id);
            filterList.add(filter);
            busiTypes = this.businessTypeService.findList(null, filterList, null);
        } else {
            Filter filter;
            ArrayList<Filter> filterList;
            BusinessType businessType = (BusinessType)this.businessTypeService.find(id);
            if ("N".equals(businessType.getLeafNode())) {
                filterList = new ArrayList<Filter>();
                filter = new Filter("parentId", Filter.Operator.eq, (Object)id);
                filterList.add(filter);
                busiTypes = this.businessTypeService.findList(null, filterList, null);
            } else {
                filterList = new ArrayList();
                filter = new Filter("businessTypeId", Filter.Operator.eq, (Object)id);
                filterList.add(filter);
                busiProcesses = this.businessProcessService.findList(null, filterList, null);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node>\n");
        if (busiTypes != null) {
            for (BusinessType busiType : busiTypes) {
                sb.append("<node id=\"" + busiType.getId() + "\" name=\"" + busiType.getName() + "\" type=\"busi\" />\n");
            }
        }
        if (busiProcesses != null) {
            for (BusinessProcess busiProcess : busiProcesses) {
                if (!"subflow".equals(busiProcess.getType())) continue;
                sb.append("<node id=\"flow." + busiProcess.getId() + "\" name=\"" + busiProcess.getFlowName() + "\" type=\"subflow\" />\n");
            }
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/querySpringBean"})
    @ResponseBody
    public void querySpringBean(String type, HttpServletResponse response) throws IOException {
        StringBuilder sb = new StringBuilder();
        List<String> list = FlowSpringBeanUtil.querySpringBean(type);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node>\n");
        for (String name : list) {
            sb.append("<node value=\"" + name + "\" />\n");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/queryTransctrls"})
    @ResponseBody
    public void queryTransctrls(Long id, HttpServletResponse response) throws IOException {
        IActivityInstService activityInstService = ProcessEnginerHolder.getInstance().getActivityInstService();
        StringBuilder sb = new StringBuilder();
        List transCtrls = activityInstService.findTransCtrls(id.longValue());
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<activities>\n<transctrls>\n");
        for (TransCtrl tc : transCtrls) {
            sb.append("<transctrl srcId=\"" + tc.getSrcActDefId() + "\" destId=\"" + tc.getDestActDefId() + "\" />\n");
        }
        sb.append("</transctrls>\n<noFinishActs>\n");
        List activityInsts = activityInstService.findWaitingAndTerminateAndRunningActivityInst(id.longValue());
        for (ActivityInst activityInst : activityInsts) {
            sb.append("<activity id=\"" + activityInst.getActivityDefId() + "\" status=\"" + activityInst.getCurrentState() + "\" />\n");
        }
        sb.append("</noFinishActs></activities>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/saveFlow"})
    @ResponseBody
    public Long saveFlow(ProcessDefine processDefine) {
        IProcessDefineService iProcessDefineService = ProcessEnginerHolder.getInstance().getProcessDefineService();
        boolean isUnique = iProcessDefineService.isUniqueProcessDefine(String.valueOf(processDefine.getProcessDefId()), processDefine.getVersionSign());
        Principal principal = (Principal)SecurityUtils.getSubject().getPrincipal();
        if (!isUnique) {
            ProcessDefine pd = iProcessDefineService.findProcessDefine(processDefine.getProcessDefId());
            pd.setDescription(processDefine.getDescription());
            pd.setLimitTime(processDefine.getLimitTime());
            pd.setProcessDefContent(processDefine.getProcessDefContent());
            pd.setUpdateTime(new Date());
            pd.setUpdator(principal.getId().toString());
            iProcessDefineService.updateProcessDefine(processDefine);
        } else {
            processDefine.setProcessDefId(PrimaryKeyUtil.getPrimaryKey((String)"BusinessUsiFlow").longValue());
            processDefine.setCreateTime(new Date());
            processDefine.setCreator(principal.getId().toString());
            iProcessDefineService.insertProcessDefine(processDefine);
        }
        return processDefine.getProcessDefId();
    }

    @RequestMapping(value={"/deleteFlow"})
    @ResponseBody
    public ResponseData deleteFlow(long processDefId) {
        IProcessDefineService iProcessDefineService = ProcessEnginerHolder.getInstance().getProcessDefineService();
        iProcessDefineService.deleteProcessDefine(processDefId);
        return ResponseData.SUCCESS_NO_DATA;
    }

    @RequestMapping(value={"/publishFlow"})
    @ResponseBody
    public ResponseData publishFlow(long processDefId, String processDefName) {
        IProcessDefineService iProcessDefineService = ProcessEnginerHolder.getInstance().getProcessDefineService();
        iProcessDefineService.publishProcessDefine(processDefName, processDefId);
        return ResponseData.SUCCESS_NO_DATA;
    }

    @RequestMapping(value={"/finishWorkItem"})
    @ResponseBody
    public ResponseData finishWorkItem(Long workItemId) {
        WorkItem workItem = (WorkItem)this.workItemService.find(workItemId);
        workItem.setCurrentstate(12L);
        this.workItemService.update(workItem);
        return ResponseData.SUCCESS_NO_DATA;
    }

    @RequestMapping(value={"/deleteWorkItem"})
    @ResponseBody
    public ResponseData deleteWorkItem(Long workItemId) {
        this.workItemService.delete(workItemId);
        return ResponseData.SUCCESS_NO_DATA;
    }
}

