/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.usiflow.webframe.web.controller.flow;

import com.cpi.framework.dao.support.Filter;
import com.cpi.framework.dao.support.Order;
import com.cpi.framework.web.common.ResponseData;
import com.cpi.framework.web.controller.BaseController;
import com.cpi.usiflow.webframe.web.model.flow.BusinessType;
import com.cpi.usiflow.webframe.web.service.flow.BusinessTypeService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/businessType"})
public class BusinessTypeController
extends BaseController {
    @Autowired
    private BusinessTypeService businessTypeService;

    @RequestMapping(value={"/index"})
    public String index() {
        return "workflow/businessType";
    }

    @RequestMapping(value={"/busiType"})
    public void busiType() {
    }

    @RequestMapping(value={"/queryBusiTypes"})
    @ResponseBody
    public List<BusinessType> queryBusiTypes(Long node) {
        if (node == null) {
            node = 0L;
        }
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        Filter filter = new Filter("parentId", Filter.Operator.eq, (Object)node);
        filterList.add(filter);
        ArrayList<Order> orderList = new ArrayList<Order>();
        Order order = new Order("orderIndex", Order.Direction.asc);
        orderList.add(order);
        List list = this.businessTypeService.findList(null, filterList, orderList);
        for (BusinessType busiType : list) {
            if (!"Y".equals(busiType.getLeafNode())) continue;
            busiType.setLeaf(true);
        }
        return list;
    }

    @RequestMapping(value={"/saveBusiTypeOrder"})
    @ResponseBody
    public ResponseData saveBusiTypeOrder(Long parentId, String childIds) {
        this.businessTypeService.saveBusiTypeOrder(parentId, childIds);
        return ResponseData.SUCCESS_NO_DATA;
    }

    @RequestMapping(value={"/insertBusiType"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData insertBusiType(BusinessType businessType) {
        this.businessTypeService.save(businessType);
        return ResponseData.SUCCESS_NO_DATA;
    }

    @RequestMapping(value={"/updateBusiType"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData updateBusiType(BusinessType businessType) {
        this.businessTypeService.update(businessType);
        return ResponseData.SUCCESS_NO_DATA;
    }

    @RequestMapping(value={"/loadBusiType"}, method={RequestMethod.POST})
    @ResponseBody
    public BusinessType loadBusiType(Long id) {
        return (BusinessType)this.businessTypeService.find(id);
    }

    @RequestMapping(value={"/deleteBusiType"})
    @ResponseBody
    public ResponseData deleteBusiType(long id) {
        this.businessTypeService.delete(Long.valueOf(id));
        return ResponseData.SUCCESS_NO_DATA;
    }
}

