/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.usiflow.webframe.web.service.flow;

import com.cpi.framework.dao.support.Pagination;
import com.cpi.framework.modules.exception.ServiceException;
import com.cpi.framework.web.entity.admin.FwPendingDetails;
import com.cpi.framework.web.entity.admin.FwPendingMessage;
import com.cpi.framework.web.service.admin.IFwPendingMessageService;
import com.cpi.usiflow.webframe.flow.AuditEnum;
import com.cpi.usiflow.webframe.flow.ProcessEnginerHolder;
import com.cpi.usiflow.webframe.flow.WorkItemEnum;
import com.cpi.usiflow.webframe.web.dao.flow.FlowUtilDao;
import com.cpi.usiflow.webframe.web.model.flow.LineCondition;
import com.cpi.usiflow.webframe.web.model.flow.Processinst;
import com.cpi.usiflow.webframe.web.model.flow.WfProcessDefine;
import com.cpi.usiflow.webframe.web.service.flow.BusinessProcessService;
import com.cpi.usiflow.webframe.web.service.flow.ProcessDefineService;
import com.cpi.usiflow.webframe.web.service.flow.ProcessinstService;
import com.ustcsoft.usiflow.engine.core.RelaDataManagerBuilder;
import com.ustcsoft.usiflow.engine.core.data.RelaDataManager;
import com.ustcsoft.usiflow.engine.model.ProcessInstance;
import com.ustcsoft.usiflow.engine.model.WorkItem;
import com.ustcsoft.usiflow.engine.repository.IWorkItemRepository;
import com.ustcsoft.usiflow.engine.service.IProcessInstanceService;
import com.ustcsoft.usiflow.engine.service.IWorkItemService;
import com.ustcsoft.usiflow.engine.xml.Dom4jProcDefParser;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Component(value="FlowUtilService")
@Transactional
public class FlowUtilService {
    Logger logger = Logger.getLogger(FlowUtilService.class);
    @Autowired
    private FlowUtilDao flowUtilDao;
    private IProcessInstanceService procInstService;
    private IWorkItemService workItemService;
    @Autowired
    private ProcessinstService pinstservice;
    @Autowired
    private ProcessDefineService pdefservice;
    @Autowired
    private BusinessProcessService bpservice;
    @Resource(name="FwPendingMessageServiceImpl")
    private IFwPendingMessageService fwPendingMessageService;

    public Long createAndStartProcess(String tablename, Long userId) throws Exception {
        IProcessInstanceService procInstService = ProcessEnginerHolder.getInstance().getProcessInstanceService();
        String flowName = this.getFlowName(tablename);
        if (!StringUtils.isEmpty((Object)flowName)) {
            ProcessInstance processinst = procInstService.createAndStartProcess(flowName, userId.toString());
            return processinst.getParentProcInstId();
        }
        this.logger.error((Object)"\u6d41\u7a0b\u521b\u5efa\u5931\u8d25,\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u6d41\u7a0b!");
        throw new ServiceException("\u6d41\u7a0b\u521b\u5efa\u5931\u8d25,\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u6d41\u7a0b!");
    }

    public void excuteFlow(Long processInstId, Long userId, Long orgId, String msgTitle, String condition, String toActId, String TH, String advice) throws Exception {
        int status;
        IWorkItemService workItemService = ProcessEnginerHolder.getInstance().getWorkItemService();
        Long workitemid = this.getWorkItemId(processInstId, userId.toString());
        IWorkItemRepository workItemRep = (IWorkItemRepository)ProcessEnginerHolder.getInstance().getApplicationContext().getBean(IWorkItemRepository.class);
        WorkItem workItem = workItemRep.findWorkItem(workitemid.longValue());
        if (condition != null && !"".equals(condition)) {
            String[] acons;
            HashMap<String, Object> conditions = new HashMap<String, Object>();
            Pattern pattern = Pattern.compile("&&|\\|\\|");
            Pattern pattern2 = Pattern.compile("==|>=|<=|>|<");
            for (String acon : acons = pattern.split(condition)) {
                String[] con = pattern2.split(acon);
                con[0] = con[0].replaceAll("#", "");
                String value = con[1].trim();
                if (value.contains("'")) {
                    value = value.replaceAll("'", "");
                    conditions.put(con[0].trim(), value);
                    continue;
                }
                conditions.put(con[0].trim(), Long.parseLong(value));
            }
            this.cleanRelvant_data(processInstId, workItem.getActivityDefId());
            RelaDataManager relaDataManager = RelaDataManagerBuilder.buildRelaDataManager();
            relaDataManager.setExpressConditions(processInstId.longValue(), workItem.getActivityDefId(), conditions);
        }
        if ("TH".equals(TH)) {
            this.endWorkItemWhenTh(userId, processInstId, workitemid);
            status = AuditEnum.nopassed.ordinal();
        } else {
            status = "act_finish".equals(toActId) ? (this.isAllWorkItemIsDoneWhenPass(processInstId, workitemid) ? AuditEnum.passed.ordinal() : AuditEnum.pending.ordinal()) : AuditEnum.pending.ordinal();
        }
        workItemService.finishWorkItem(workitemid.longValue(), userId.toString(), advice);
        Long businessId = this.updateBusinessStatus(processInstId, status);
        this.sysMsgdeal(businessId, userId, processInstId, toActId, workItem.getActivityDefId(), TH, msgTitle);
    }

    public List<LineCondition> getLineCondition(WorkItem workItem, Long userId, Map<String, Object> condtion) {
        Processinst processinst = (Processinst)this.pinstservice.find(Long.valueOf(workItem.getProcessInstId()));
        if (processinst == null) {
            return null;
        }
        WfProcessDefine wfprocessDefine = (WfProcessDefine)this.pdefservice.find(processinst.getProcessdefid());
        String processDefContent = wfprocessDefine.getProcessdefcontent();
        List list = Dom4jProcDefParser.parserTransitionInfo((String)processDefContent, (String)workItem.getActivityDefId());
        ArrayList<LineCondition> condtions = new ArrayList<LineCondition>(list.size());
        block0: for (Element el : list) {
            Element childel;
            LineCondition cond = new LineCondition();
            Iterator iterator = el.elementIterator("complexExpressionValue");
            while (iterator.hasNext()) {
                childel = (Element)iterator.next();
                String exp = this.isConform(childel.getData().toString(), condtion);
                if (exp == null) continue block0;
                cond.setCondition(exp);
            }
            cond.setLineName(el.attributeValue("name"));
            cond.setToActId(el.attributeValue("to"));
            iterator = el.elementIterator("description");
            while (iterator.hasNext()) {
                childel = (Element)iterator.next();
                cond.setDescription(childel.getData().toString());
            }
            condtions.add(cond);
        }
        return condtions;
    }

    private String isConform(String expression, Map<String, Object> condition) {
        String[] acons;
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("SpringExpression");
        Bindings variables = engine.createBindings();
        String expBak = expression = expression.replaceAll("\\s*|\t|\r|\n", "");
        Pattern pattern = Pattern.compile("&&|\\|\\|");
        Pattern pattern2 = Pattern.compile("==|>=|<=|>|<|!=");
        for (String acon : acons = pattern.split(expression)) {
            String[] con = pattern2.split(acon);
            con[0] = con[0].replaceAll("#", "");
            if (!condition.containsKey(con[0])) {
                expBak = expBak.replaceAll("[&\\|]{2}" + acon + "|^" + acon + "[&\\|]{2}|" + acon, "");
                continue;
            }
            expression = con[1].indexOf("'") == -1 ? expression.replaceAll(acon, "#" + con[0] + "==" + condition.get(con[0])) : expression.replaceAll(acon, "#" + con[0] + "=='" + condition.get(con[0]) + "'");
        }
        variables.putAll((Map<? extends String, ? extends Object>)condition);
        expBak = expBak.replaceAll("&&", "and");
        expBak = expBak.replaceAll("\\|\\|", "or");
        try {
            if ("".equals(expBak.trim()) || ((Boolean)engine.eval(expBak, variables)).booleanValue()) {
                return expression;
            }
            return null;
        }
        catch (ScriptException e) {
            this.logger.error((Object)("\u89e3\u6790\u8868\u8fbe\u5f0f\u5931\u8d25\uff1a" + expBak));
            return null;
        }
    }

    private void sysMsgdeal(Long businessId, Long userId, Long processInstId, String toActId, String ActivityDefId, String TH, String msgTitle) throws Exception {
        this.fwPendingMessageService.updateMsgStatus(processInstId, userId, "TH".equals(TH));
        if (!"act_finish".equals(toActId)) {
            String moduleUrlPath = "/ProcessDefine/Activitys/Activity[@id='" + toActId + "']/ExtendNodes/extendNode[@key='" + "module_url" + "']/@value";
            String filterPath = "/ProcessDefine/Activitys/Activity[@id='" + toActId + "']/ExtendNodes/extendNode[@key='" + "isFilter" + "']/@value";
            String rolePath = "/ProcessDefine/Activitys/Activity[@id='" + toActId + "']/Participants";
            String participantType = "/ProcessDefine/Activitys/Activity[@id='" + toActId + "']/participantType";
            String processDefContent = this.bpservice.queryFlowContent(null, processInstId, "");
            try {
                SAXReader reader = new SAXReader();
                Document document = reader.read((Reader)new StringReader(processDefContent));
                String moduleUrl = document.selectSingleNode(moduleUrlPath).getText();
                Node participantTypeNode = document.selectSingleNode(participantType);
                ArrayList<Long> receiveIds = new ArrayList<Long>();
                if ("TH".equals(TH)) {
                    String receive = this.getLastDealPerson(processInstId, toActId);
                    receiveIds.add(Long.valueOf(receive));
                } else if ("process-starter".equals(participantTypeNode.getText())) {
                    Processinst processinst = (Processinst)this.pinstservice.find(processInstId);
                    receiveIds.add(Long.parseLong(processinst.getCreator()));
                } else {
                    Node node;
                    Element roleEl = (Element)document.selectSingleNode(rolePath);
                    StringBuilder role = new StringBuilder();
                    Iterator iterator = roleEl.elementIterator("participant");
                    while (iterator.hasNext()) {
                        Element childel = (Element)iterator.next();
                        String type = childel.attributeValue("type");
                        if ("person".equals(type)) {
                            receiveIds.add(Long.valueOf(childel.attributeValue("id")));
                            continue;
                        }
                        if (!"role".equals(type)) continue;
                        role.append("'" + childel.attributeValue("id") + "',");
                    }
                    if (role.length() > 0) {
                        role.deleteCharAt(role.length() - 1);
                    }
                    if ((node = document.selectSingleNode(filterPath)) != null && Boolean.valueOf(node.getText()).booleanValue()) {
                        receiveIds.addAll(this.getProjectDeptLeader(processInstId));
                    } else if (role.length() > 0) {
                        receiveIds.addAll(this.getNextStepPerson(null, role.toString()));
                    }
                }
                String flowName = this.bpservice.getFlowNameByProcessInstId(processInstId);
                FwPendingMessage fwPendingMsg = new FwPendingMessage();
                String smd = "TH".equals(TH) ? "...\u5df2\u88ab\u9000\u56de" : "...\u9700\u8981\u60a8\u5ba1\u6838";
                fwPendingMsg.setMsgTitle("\u3010" + msgTitle + "\u3011" + flowName + smd);
                fwPendingMsg.setMsgUrl(moduleUrl);
                fwPendingMsg.setSendId(userId);
                fwPendingMsg.setBusinessId(businessId);
                fwPendingMsg.setProcessInstId(processInstId);
                for (Long receiveId : receiveIds) {
                    FwPendingDetails fwPendingDetail = new FwPendingDetails();
                    fwPendingDetail.setReceiverId(receiveId);
                    fwPendingMsg.addPendingDetails(fwPendingDetail);
                }
                this.fwPendingMessageService.save((Object)fwPendingMsg);
            }
            catch (DocumentException e) {
                this.logger.error((Object)"\u53d1\u9001\u6d88\u606f\u65f6\u89e3\u6790xml\u5931\u8d25\uff01");
                throw new ServiceException("\u6d41\u7a0bXML\u6587\u4ef6\u89e3\u6790\u5931\u8d25!");
            }
            catch (Exception e) {
                this.logger.error((Object)"\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff01");
                throw new ServiceException("\u53d1\u9001\u6d88\u606f\u5931\u8d25!", (Throwable)e);
            }
        }
    }

    private Long updateBusinessStatus(Long processInstId, int status) {
        String tsql = "SELECT p.business_table\n  FROM wf_processinst       t,\n       stf_business_process p\n WHERE t.processinstid = ?0\n   AND p.design_name = t.processinstname";
        Object ob = this.flowUtilDao.getSingal(tsql, new Object[]{processInstId});
        String tableName = "";
        if (ob != null) {
            tableName = ob.toString();
            String updateSql = "update " + tableName + " t set t.AUDIT_STATUS=?0 where t.PROCESSINSTID=?1";
            this.flowUtilDao.exeNativeSQL(updateSql, new Object[]{String.valueOf(status), processInstId});
            String idSql = "select t.id from " + tableName + " t where t.PROCESSINSTID=?0";
            Object oid = this.flowUtilDao.getSingal(idSql, new Object[]{processInstId});
            if (oid != null) {
                return Long.parseLong(String.valueOf(oid));
            }
            this.logger.error((Object)"\u66f4\u65b0\u4e1a\u52a1\u72b6\u6001\u65f6\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u4e1a\u52a1\u8868\uff01");
            throw new ServiceException("\u66f4\u65b0\u4e1a\u52a1\u72b6\u6001\u65f6\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u4e1a\u52a1\u8868");
        }
        this.logger.error((Object)"\u66f4\u65b0\u4e1a\u52a1\u72b6\u6001\u65f6\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u4e1a\u52a1\u8868\uff01");
        throw new ServiceException("\u66f4\u65b0\u4e1a\u52a1\u72b6\u6001\u65f6\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u4e1a\u52a1\u8868");
    }

    private String getLastDealPerson(Long processInstId, String toActId) {
        String sql = "SELECT t.participant\n          FROM wf_workitem t\n         WHERE t.processinstid = " + processInstId + "\n" + "           AND t.activitydefid = '" + toActId + "'\n" + "\t\t\tAND t.currentstate=12\n" + "         ORDER BY t.workitemid DESC";
        Object ob = this.flowUtilDao.getSingal(sql);
        String participant = "";
        if (ob != null) {
            participant = ob.toString();
        }
        return participant;
    }

    private List<Long> getNextStepPerson(Long orgId, String roles) throws Exception {
        ArrayList<Long> userIds = new ArrayList<Long>();
        String sql = "select distinct u.id\n  from fw_user u, fw_user_roles ur\n where u.id = ur.user_id\n   and ur.role_id in (" + roles + ")\n";
        if (orgId != null) {
            sql = sql + "   and u.org_id =" + orgId;
        }
        try {
            List result = this.flowUtilDao.findByNativeSQL(sql, new int[0]);
            if (result != null) {
                for (BigDecimal row : result) {
                    userIds.add(row.longValue());
                }
            }
            return userIds;
        }
        catch (Exception e) {
            throw new Exception("\u4e0b\u4e00\u6b65\u5904\u7406\u4eba\u5458\u672a\u627e\u5230", e);
        }
    }

    private void endWorkItemWhenTh(Long userId, Long processinstid, Long workItemId) {
        String sql = "update wf_workitem t\nset t.currentstate=7,t.participant=?0\n WHERE t.processinstid = ?1\n   AND t.workitemid <> ?2\n   AND t.currentstate IN (4, 10)";
        this.flowUtilDao.exeNativeSQL(sql, new Object[]{userId, processinstid, workItemId});
    }

    public boolean isAllWorkItemIsDoneWhenPass(Long processinstid, Long workItemId) {
        String sql = "select count(*) from wf_workitem t\n WHERE t.processinstid = ?0\n   AND t.workitemid <> ?1\n   AND t.currentstate IN (4, 10)";
        Object ob = this.flowUtilDao.getSingal(sql, new Object[]{processinstid, workItemId});
        if (ob != null) {
            return ob.toString().equals("0");
        }
        return true;
    }

    private String getFlowName(String tablename) {
        String sql = "select t.design_name from STF_BUSINESS_PROCESS t where TRIM(Upper(t.business_table))=TRIM(Upper(?0))";
        Object ob = this.flowUtilDao.getSingal(sql, new Object[]{tablename});
        if (ob != null) {
            return ob.toString();
        }
        return null;
    }

    private List<Long> getProjectDeptLeader(Long processInstId) throws Exception {
        ArrayList<Long> userIds = new ArrayList<Long>();
        String sql = "select v.dept_lead\n  from (select t.id, t.dept_lead, t.processinstid\n          from PJ_BASE t\n        union\n        select c.id, t.dept_lead, c.processinstid\n          from PJ_BASE t, pj_base_change c\n         where t.id = c.id\n        union\n        select m.id, t.dept_lead, m.processinstid\n          from PJ_BASE t, pj_month_report m\n         where t.id = m.pj_id\n        union\n        select w.id, t.dept_lead, w.processinstid\n          from PJ_BASE t, pj_week_report w\n         where t.id = w.pj_id) v\n where v.processinstid = " + processInstId;
        try {
            List result = this.flowUtilDao.findByNativeSQL(sql, new int[0]);
            if (result != null) {
                for (BigDecimal row : result) {
                    userIds.add(row.longValue());
                }
            }
            return userIds;
        }
        catch (Exception e) {
            throw new Exception("\u4e0b\u4e00\u6b65\u5904\u7406\u4eba\u5458\u672a\u627e\u5230", e);
        }
    }

    public Long getWorkItemIdRelevantdata(Long processInstId, String userId) {
        String sql = "SELECT b.WORKITEMID FROM wf_workitem b WHERE b.CURRENTSTATE IN(4,10) AND b.PROCESSINSTID = '" + processInstId + "'";
        Long workitemid = null;
        workitemid = Long.valueOf(this.flowUtilDao.getSingal(sql).toString());
        return workitemid;
    }

    public Long getWorkItemId(Long processInstId, String userId) {
        String roleSql = "select t1.role_id\n  from FW_USER_ROLES t1,fw_user t2\n where t1.user_id=t2.id and t2.id =" + userId;
        String sql = "SELECT b.WORKITEMID FROM wf_participant a, wf_workitem b WHERE ((a.PARTICTYPE = 'person' AND a.Participant = '" + userId + "')" + " OR (a.PARTICTYPE = 'role' AND a.PARTICIPANT in (" + roleSql + "))" + " OR (a.PARTICTYPE = 'organization' AND a.PARTICIPANT = '" + userId + "'))" + " AND b.CURRENTSTATE IN(4,10) AND a.WORKITEMID = b.WORKITEMID" + " AND b.PROCESSINSTID = '" + processInstId + "'";
        Long workitemid = null;
        Object ob = this.flowUtilDao.getSingal(sql);
        if (ob != null) {
            workitemid = Long.valueOf(this.flowUtilDao.getSingal(sql).toString());
        }
        return workitemid;
    }

    public String getActivityDefIdRelevantdata(Long processInstId, String userId) {
        String sql = "SELECT b.ACTIVITYDEFID FROM wf_workitem b WHERE b.CURRENTSTATE IN(4,10) AND b.PROCESSINSTID = '" + processInstId + "'";
        String activityDefId = null;
        activityDefId = String.valueOf(this.flowUtilDao.getSingal(sql).toString());
        return activityDefId;
    }

    public String getActivityDefId(Long processInstId, String userId) {
        String sql = "SELECT b.ACTIVITYDEFID FROM wf_participant a, wf_workitem b WHERE ((a.PARTICTYPE = 'person' AND a.Participant = '" + userId + "')" + " OR (a.PARTICTYPE = 'organization' AND a.PARTICIPANT = '" + userId + "'))" + " AND b.CURRENTSTATE IN(4,10) AND a.WORKITEMID = b.WORKITEMID" + " AND b.PROCESSINSTID = '" + processInstId + "'";
        String activityDefId = null;
        activityDefId = String.valueOf(this.flowUtilDao.getSingal(sql).toString());
        return activityDefId;
    }

    public String haseRole(String participant, Long workitemid) {
        String sql = "select t.particid from WF_PARTICIPANT t where t.participant='" + participant + "' and t.workitemid=" + workitemid;
        String particid = null;
        try {
            particid = this.flowUtilDao.getSingal(sql).toString();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return particid;
    }

    public List queryActivityinst(Long processinstid) {
        String sql = "select b.processinstid,\n       b.processdefid,\n       b.processinstname,\n       a.activityinstid,\n       a.activityinstname,\n       a.activitytype,\n       a.currentstate,\n       a.starttime,\n       a.endtime,a.activitydefid\n  from wf_activityinst a, wf_processinst b\n where a.processinstid = '" + processinstid + "'\n" + "  and a.processinstid = b.processinstid\n" + " order by a.activityinstid";
        List list = null;
        try {
            list = this.flowUtilDao.findByNativeSQL(sql, new int[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public List<WorkItem> queryWorkItem(Long activityinstid) {
        String sql = "select workitemid,\n       workitemname,\n       currentstate,\n(select t1.role_name\n          from sys_c_roles t1\n           where t1.role_id =\n               (select t3.participant\n                  from WF_PARTICIPANT t3\n                 where t3.workitemid = t.workitemid)) participant,\n       starttime,\n       endtime,\n       workmemory,\n       activityinstid\n  from WF_WORKITEM t\n where t.activityinstid = " + activityinstid;
        List list = null;
        try {
            list = this.flowUtilDao.findByNativeSQL(sql, new int[0]);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return list;
    }

    public Object querySubProcInstId(Long processinstid, String activitydefid) {
        String queryString = "select b.processinstid, b.processdefid\n  from wf_activityinst a, wf_processinst b\n where a.processinstid = '" + processinstid + "'\n" + "   and a.activityinstid = b.activityinstid\n" + "   and a.activitydefid = '" + activitydefid + "'\n" + " order by a.activityinstid";
        try {
            return this.flowUtilDao.getSingal(queryString);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object queryParentProcInstId(Long processinstid) {
        String queryString = "select p.processinstid, p.processdefid from WF_PROCESSINST p where p.processinstid =(select t.parentprocinstid from WF_PROCESSINST t where t.processinstid=" + processinstid + " and t.processinstid != t.parentprocinstid)";
        try {
            return this.flowUtilDao.getSingal(queryString);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String queryActivitydefid(Long processinstid) {
        String queryString = "select act.activitydefid from WF_PROCESSINST inst,wf_activityinst act where inst.activityinstid=act.activityinstid and inst.processinstid=" + processinstid;
        String result = "";
        try {
            result = this.flowUtilDao.getSingal(queryString).toString();
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public List<WorkItem> queryWorkItemByDefid(Long processinstid, String activitydefid) {
        String queryString = "select t.workitemid,\n       t.workitemname,\n       t.currentstate,\n(select t1.role_name\n          from sys_c_roles t1\n         where t1.role_id =\n               (select t3.participant\n                  from WF_PARTICIPANT t3\n                 where t3.workitemid = t.workitemid)) participant,\n       t.starttime,\n       t.endtime,\n       t.workmemory,\n       t.limittime\n  from WF_WORKITEM t\n where t.activitydefid = '" + activitydefid + "'\n" + "   and t.processinstid = '" + processinstid + "'\n" + " order by t.workitemid";
        List list = null;
        try {
            list = this.flowUtilDao.findByNativeSQL(queryString, new int[0]);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return list;
    }

    public String queryCanDealProcess(long Accountid) {
        String sqlString = "select t.processinstid\n  from wf_workitem t\n  left join  WF_PARTICIPANT  m\n    on t.workitemid = m.workitemid\n   and t.currentstate in (4, 10)\n   and m.partictype = 'role'\n   left join bas_emp_role n on m.participant=n.role_id\n   where n.login_account_id=%s";
        return String.format(sqlString, Accountid);
    }

    @Transactional(readOnly=true)
    public List<Long> queryDealedProcess(Long userId, WorkItemEnum workStatus) {
        String tempsql = "";
        tempsql = WorkItemEnum.passed.equals((Object)workStatus) || WorkItemEnum.reported.equals((Object)workStatus) ? " =12 " : " IN (4, 10) ";
        String sql = "SELECT DISTINCT a.processinstid \n  FROM wf_workitem a\n  LEFT JOIN wf_participant b\n    ON a.workitemid = b.workitemid\n  LEFT JOIN fw_user_roles r\n    ON r.role_id = a.participant\n   AND b.partictype = 'role'\n WHERE a.currentstate " + tempsql + "\n" + "   AND (r.user_id = ?0 OR (b.participant = ?0 AND b.partictype = 'person'))";
        ArrayList<Long> list = new ArrayList<Long>();
        List ol = this.flowUtilDao.findByNativeSQL(sql, new Object[]{userId}, new int[0]);
        if (ol != null && !ol.isEmpty()) {
            for (Object ob : ol) {
                Long processinstid = Long.parseLong(ob.toString());
                list.add(processinstid);
            }
        }
        return list;
    }

    public Object queryFlowStatusByInstid(Long processinstid) {
        String sql = "select t.currentstate from WF_PROCESSINST t where t.processinstid=" + processinstid;
        try {
            return this.flowUtilDao.getSingal(sql);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public IProcessInstanceService getProcInstService() {
        return this.procInstService;
    }

    public IWorkItemService getWorkItemService() {
        return this.workItemService;
    }

    public Long createAndStartProcessliuChengId(String liuchengId, Long userId) {
        ProcessInstance processinst = this.procInstService.createAndStartProcess(liuchengId, userId.toString());
        return processinst.getParentProcInstId();
    }

    public Pagination<WfProcessDefine> lists(int ... rowStartIdxAndCount) throws ParseException {
        boolean PROCESSDEFID = false;
        boolean PROCESSDEFNAME = true;
        int PROCESSCHNAME = 2;
        int CURRENTSTATE = 3;
        int VERSIONSIGN = 4;
        int CREATETIME = 5;
        int CREATOR = 6;
        String sql = "select\n t.processdefid,\n t.processdefname,\n t.processchname,\n\n t.currentstate,\n t.versionsign,\n\n t.createtime,\n t.creator\n\n from WF_PROCESSDEFINE t\n where t.currentstate != '0'";
        String sqlCount = "select count(1) from (" + sql + ")";
        Long count = Long.parseLong(this.flowUtilDao.getSingal(sqlCount).toString());
        List list = this.flowUtilDao.findByNativeSQL(sql, rowStartIdxAndCount);
        ArrayList<WfProcessDefine> resultList = new ArrayList<WfProcessDefine>();
        for (Object[] ob : list) {
            WfProcessDefine wfProcessDefine = new WfProcessDefine();
            wfProcessDefine.setProcessDefId(Long.parseLong(ob[0] == null ? "" : ob[0].toString()));
            wfProcessDefine.setProcessDefName(ob[1] == null ? "" : ob[1].toString());
            wfProcessDefine.setProcesschname(ob[2] == null ? "" : ob[2].toString());
            wfProcessDefine.setCurrentstate(Integer.parseInt(ob[3] == null ? "" : ob[3].toString()));
            wfProcessDefine.setVersionsign(ob[4] == null ? "" : ob[4].toString());
            if (ob[5] != null) {
                wfProcessDefine.setCreatetime(new SimpleDateFormat("yyyy-MM-dd").parse(ob[5].toString()));
            }
            wfProcessDefine.setCreator(ob[6] == null ? "" : ob[6].toString());
            resultList.add(wfProcessDefine);
        }
        Pagination pg = new Pagination(resultList, count.longValue(), null);
        return pg;
    }

    public Long getProCessDefId(Long processinstId) {
        String sql = "SELECT a.PROCESSDEFID FROM wf_processinst a WHERE a.PROCESSINSTID = ?0";
        Object ob = this.flowUtilDao.getSingal(sql, new Long[]{processinstId});
        Long proCessDefId = null;
        if (ob != null) {
            proCessDefId = Long.valueOf(ob.toString());
        }
        return proCessDefId;
    }

    private void cleanRelvant_data(Long processinstId, String activitydefId) {
        String delsql = "delete from wf_relevant_data where PROCESSINSTID = ?0 and ACTIVITYDEFID = ?1 and NAME = ?2";
        this.flowUtilDao.exeNativeSQL(delsql, new Object[]{processinstId, activitydefId, "transitionExpressCondition"});
    }
}

