/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.usiflow.webframe.web.service.demo;

import com.cpi.framework.dao.support.Filter;
import com.cpi.framework.modules.security.shiro.Principal;
import com.cpi.usiflow.webframe.web.model.demo.HrJLeave;
import com.cpi.usiflow.webframe.web.service.demo.HrJLeaveService;
import com.ustcsoft.usiflow.engine.core.RelaDataManagerBuilder;
import com.ustcsoft.usiflow.engine.core.data.RelaDataManager;
import com.ustcsoft.usiflow.service.spi.IActivityTriggerEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="leaveSuperiorEnevt")
public class LeaveSuperiorEnevt
implements IActivityTriggerEvent {
    @Autowired
    private HrJLeaveService hrJLeaveService;

    public void beforeComplete(long processInstId, long activityInstId) {
        Principal principal = (Principal)SecurityUtils.getSubject().getPrincipal();
        String userId = null;
        if (principal != null) {
            userId = principal.getLoginName();
        }
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        Filter filter = new Filter("processinstid", Filter.Operator.eq, (Object)processInstId);
        filterList.add(filter);
        HrJLeave leave = (HrJLeave)this.hrJLeaveService.findList(null, filterList, null).get(0);
        RelaDataManager relaDataManager = RelaDataManagerBuilder.buildRelaDataManager();
        Map conditions = relaDataManager.getExpressConditions(processInstId, "");
        String status = conditions.get("status").toString();
        if ("CLOSED".equals(status)) {
            leave.setStatus("CLOSED");
        } else if (leave.getLeaveDays() > 3) {
            leave.setStatus("INPRG");
        } else {
            leave.setStatus("APPR");
        }
        leave.setSuperior(userId);
        leave.setSuperiorTime(new Date());
        this.hrJLeaveService.update(leave);
    }

    public void beforeStart(long processInstId, String activityDefId) {
    }

    public void afterStart(long processInstId, long activityInstId) {
    }

    public void afterComplete(long processInstId, long activityInstId) {
    }
}

