/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.usiflow.webframe.web.controller.statistics;

import com.cpi.framework.web.controller.BaseController;
import com.cpi.usiflow.webframe.core.util.StrUtil;
import com.cpi.usiflow.webframe.web.service.statistics.InstExeTimeService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/flowExecute"})
public class InstExeTimeController
extends BaseController {
    @Autowired
    private InstExeTimeService instExeTimeService;

    @RequestMapping(value={"/index"})
    public String index() {
        return "statistics/instExeTime";
    }

    @RequestMapping(value={"/queryInstExeTime"})
    @ResponseBody
    public void queryInstExeTime(String level, String yearPre, String yearNext, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> list = this.instExeTimeService.queryInstExeTime(level, yearPre, yearNext);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<node>");
        for (Map<String, Object> map : list) {
            String avgvalue = "0";
            if (map.get("avgvalue") != null) {
                avgvalue = map.get("avgvalue").toString();
            }
            String minvalue = "0";
            if (map.get("minvalue") != null) {
                minvalue = map.get("minvalue").toString();
            }
            String maxvalue = "0";
            if (map.get("maxvalue") != null) {
                maxvalue = map.get("maxvalue").toString();
            }
            sb.append("<node processdefid=\"" + String.valueOf(map.get("processdefid")) + "\" processchname=\"" + StrUtil.encodeString(String.valueOf(map.get("processchname"))) + "\" minvalue=\"" + minvalue + "\" maxvalue=\"" + maxvalue + "\" avgvalue=\"" + avgvalue + "\">\n");
            sb.append("</node>\n");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/queryInstExeTimeSub"})
    @ResponseBody
    public void queryInstExeTimeSub(String processdefid, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> list = this.instExeTimeService.queryInstExeTimeSub(processdefid);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<node>");
        for (Map<String, Object> map : list) {
            String avgvalue = "0";
            if (map.get("avgvalue") != null) {
                avgvalue = map.get("avgvalue").toString();
            }
            String minvalue = "0";
            if (map.get("minvalue") != null) {
                minvalue = map.get("minvalue").toString();
            }
            String maxvalue = "0";
            if (map.get("maxvalue") != null) {
                maxvalue = map.get("maxvalue").toString();
            }
            sb.append("<node processdefid=\"" + String.valueOf(map.get("processdefid")) + "\" processchname=\"" + StrUtil.encodeString(String.valueOf(map.get("processchname"))) + "\" versionsign=\"" + String.valueOf(map.get("versionsign")) + "\" minvalue=\"" + minvalue + "\" maxvalue=\"" + maxvalue + "\" avgvalue=\"" + avgvalue + "\">\n");
            sb.append("</node>\n");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/queryInstExeTimeMonth"})
    @ResponseBody
    public void queryInstExeTimeMonth(String processdefid, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> list = this.instExeTimeService.queryInstExeTimeMonth(processdefid);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<node>");
        for (Map<String, Object> map : list) {
            String month;
            String avgvalue = "0";
            if (map.get("avgvalue") != null) {
                avgvalue = map.get("avgvalue").toString();
            }
            String minvalue = "0";
            if (map.get("minvalue") != null) {
                minvalue = map.get("minvalue").toString();
            }
            String maxvalue = "0";
            if (map.get("maxvalue") != null) {
                maxvalue = map.get("maxvalue").toString();
            }
            if ((month = String.valueOf(map.get("groupMonth"))).length() == 1) {
                month = "0" + month;
            }
            sb.append("<node groupYear=\"" + String.valueOf(map.get("groupYear")) + "\" groupMonth=\"" + month + "\" minvalue=\"" + minvalue + "\" maxvalue=\"" + maxvalue + "\" avgvalue=\"" + avgvalue + "\">\n");
            sb.append("</node>\n");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }
}

