/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.usiflow.webframe.web.controller.flowadmin;

import com.cpi.framework.dao.support.Filter;
import com.cpi.framework.dao.support.Order;
import com.cpi.framework.dao.support.Pageable;
import com.cpi.framework.dao.support.Pagination;
import com.cpi.framework.web.common.ResponseData;
import com.cpi.framework.web.controller.BaseController;
import com.cpi.usiflow.webframe.web.model.flow.Processinst;
import com.cpi.usiflow.webframe.web.service.flow.ProcessinstService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/procInstAdmin"})
public class ProcessinstController
extends BaseController {
    @Autowired
    private ProcessinstService processinstService;

    @RequestMapping(value={"/index"})
    public String index() {
        return "workflow/processinst";
    }

    @RequestMapping(value={"/detail"})
    public String detail() {
        return "workflow/activityinstDetail";
    }

    @RequestMapping(value={"/processinst"})
    public void processinst() {
    }

    @RequestMapping(value={"/queryProcessinsts"})
    @ResponseBody
    public Pagination<Processinst> queryProcessinst(Processinst processinst, @RequestParam(value="start") int offset, @RequestParam(value="limit") int limit, @RequestParam(required=false) String dir, HttpServletResponse response) throws IOException {
        Filter filter;
        Pageable paginationRequest = new Pageable(Integer.valueOf(offset / limit), Integer.valueOf(limit));
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        if (processinst.getProcessinstid() != null) {
            filter = new Filter("processinstid", Filter.Operator.eq, (Object)processinst.getProcessinstid());
            filterList.add(filter);
        }
        if (StringUtils.hasText((String)processinst.getProcessinstname())) {
            filter = new Filter("processinstname", Filter.Operator.like, (Object)processinst.getProcessinstname());
            filterList.add(filter);
        }
        if (StringUtils.hasText((String)processinst.getProcesschname())) {
            filter = new Filter("processchname", Filter.Operator.like, (Object)processinst.getProcesschname());
            filterList.add(filter);
        }
        if (StringUtils.hasText((String)processinst.getProcessdefname())) {
            filter = new Filter("processdefname", Filter.Operator.like, (Object)processinst.getProcessdefname());
            filterList.add(filter);
        }
        if (StringUtils.hasText((String)processinst.getCreator())) {
            filter = new Filter("creator", Filter.Operator.like, (Object)processinst.getCreator());
            filterList.add(filter);
        }
        if (processinst.getCurrentstate() != -100) {
            filter = new Filter("currentstate", Filter.Operator.eq, (Object)processinst.getCurrentstate());
            filterList.add(filter);
        }
        if (StringUtils.hasText((String)processinst.getIstimeout())) {
            filter = new Filter("istimeout", Filter.Operator.like, (Object)processinst.getIstimeout());
            filterList.add(filter);
        }
        if (StringUtils.hasText((String)processinst.getLevel())) {
            filter = new Filter("level", Filter.Operator.like, (Object)processinst.getLevel());
            filterList.add(filter);
        }
        ArrayList<Order> orderList = new ArrayList<Order>();
        orderList.add(Order.asc((String)"createtime"));
        paginationRequest.setFilters(filterList);
        paginationRequest.setOrders(orderList);
        Pagination pgn = this.processinstService.findPage(paginationRequest);
        List resultList = pgn.getResult();
        ArrayList<Processinst> list = new ArrayList<Processinst>();
        for (int i = 0; i < resultList.size(); ++i) {
            Processinst pt = (Processinst)resultList.get(i);
            String istimeout = this.getTimeOut(pt.getStarttime(), pt.getEndtime(), pt.getIstimeout());
            if (istimeout.equals("0")) {
                pt.setIstimeout("\u672a\u8d85\u65f6");
            } else if (istimeout.equals("1")) {
                pt.setIstimeout("\u8d85\u65f6");
            }
            if (pt.getCurrentstate() == 2) {
                pt.setCurrentstatetext("\u5f85\u6fc0\u6d3b");
            } else if (pt.getCurrentstate() == 10) {
                pt.setCurrentstatetext("\u8fd0\u884c");
            } else if (pt.getCurrentstate() == 7) {
                pt.setCurrentstatetext("\u7ec8\u6b62");
            } else if (pt.getCurrentstate() == 12) {
                pt.setCurrentstatetext("\u5b8c\u6210");
            } else if (pt.getCurrentstate() == -1) {
                pt.setCurrentstatetext("\u5e94\u7528\u53d1\u751f\u5f02\u5e38");
            }
            list.add(pt);
        }
        return pgn;
    }

    private String getTimeOut(Date starttime, Date endtime, String limittime) {
        String result = "";
        if (limittime.equals("0")) {
            return "0";
        }
        if (starttime == null) {
            result = "0";
        } else {
            Date lasttime = new Date();
            if (endtime != null) {
                lasttime = endtime;
            }
            result = lasttime.getTime() - starttime.getTime() > Long.valueOf(limittime) * 1000L * 60L ? "1" : "0";
        }
        return result;
    }

    @RequestMapping(value={"/insertProcessinst"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData insertProcessinst(Processinst processinst) {
        this.processinstService.save(processinst);
        return ResponseData.SUCCESS_NO_DATA;
    }

    @RequestMapping(value={"/updateProcessinst"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData updateProcessinst(Processinst processinst) {
        this.processinstService.update(processinst);
        return ResponseData.SUCCESS_NO_DATA;
    }

    @RequestMapping(value={"/loadProcessinst"})
    @ResponseBody
    public void loadProcessinst(Long id, HttpServletResponse response) throws IOException {
        Processinst processinst = (Processinst)this.processinstService.find(id);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<node>");
        sb.append("<node processinstid=\"" + processinst.getProcessinstid() + "\" processinstname=\"" + processinst.getProcessinstname() + "\" processdefname=\"" + processinst.getProcessdefname() + "\" processchname=\"" + processinst.getProcesschname() + "\" versionsign=\"" + processinst.getVersionsign() + "\" currentstate=\"" + processinst.getCurrentstate() + "\" starttime=\"" + processinst.getStarttime() + "\" endtime=\"" + processinst.getEndtime() + "\" processdefid=\"" + processinst.getProcessdefid() + "\" istimeout=\"" + this.getTimeOut(processinst.getStarttime(), processinst.getEndtime(), String.valueOf(processinst.getLimitnum())) + "\"  creator=\"" + processinst.getCreator() + "\">\n");
        sb.append("</node>\n");
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/deleteProcessinst"})
    @ResponseBody
    public ResponseData deleteProcessinst(long id) {
        this.processinstService.delete(Long.valueOf(id));
        return ResponseData.SUCCESS_NO_DATA;
    }

    @RequestMapping(value={"/querySubProcInstId"})
    @ResponseBody
    public void querySubProcInstId(String parentProcinstid, HttpServletResponse response) throws IOException {
        Processinst processinst = this.processinstService.querySubProcInstId(parentProcinstid);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<node>");
        sb.append("<node processinstid=\"" + processinst.getProcessinstid() + "\" processDefId=\"" + processinst.getProcessdefid() + "\">\n");
        sb.append("</node>\n");
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/updateCurrentstate"})
    @ResponseBody
    public void updateCurrentstate(Long id, int currentstate) {
        Processinst processinst = (Processinst)this.processinstService.find(id);
        processinst.setCurrentstate(currentstate);
        this.processinstService.update(processinst);
    }
}

