/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.usiflow.webframe.web.controller.flowadmin;

import com.cpi.framework.dao.support.Filter;
import com.cpi.framework.dao.support.Pageable;
import com.cpi.framework.dao.support.Pagination;
import com.cpi.framework.modules.security.shiro.Principal;
import com.cpi.framework.web.common.ResponseData;
import com.cpi.framework.web.controller.BaseController;
import com.cpi.usiflow.webframe.flow.FlowSpringBeanUtil;
import com.cpi.usiflow.webframe.flow.ProcessEnginerHolder;
import com.cpi.usiflow.webframe.web.model.flow.PageTemplate;
import com.cpi.usiflow.webframe.web.service.flow.BusinessTypeService;
import com.cpi.usiflow.webframe.web.service.flow.PageTemplateService;
import com.ustcsoft.usiflow.engine.model.ActivityInst;
import com.ustcsoft.usiflow.engine.model.TransCtrl;
import com.ustcsoft.usiflow.engine.service.IActivityInstService;
import com.ustcsoft.usiflow.engine.service.IProcessDefineService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/formAdmin"})
public class PageTempController
extends BaseController {
    @Autowired
    private BusinessTypeService businessTypeService;
    @Autowired
    private PageTemplateService pageTemplateService;

    @RequestMapping(value={"/index"})
    public String index() {
        return "workflow/pageTemplate";
    }

    @RequestMapping(value={"/busiType"})
    public String busiType() {
        return "workflow/busiType";
    }

    @RequestMapping(value={"/flowDesigner"})
    public String flowDesigner() {
        return "workflow/flowDesigner";
    }

    @RequestMapping(value={"/viewFlow"})
    public String viewFlow() {
        return "workflow/viewFlow";
    }

    @RequestMapping(value={"/workItem"})
    public String workItem() {
        return "workflow/workItem";
    }

    @RequestMapping(value={"/savePageTemplatenew"})
    @ResponseBody
    public Long savePageTemplatenew(PageTemplate pageTemplate) {
        long contentInfo = 0L;
        Principal principal = (Principal)SecurityUtils.getSubject().getPrincipal();
        pageTemplate.setCreator(principal.getId().toString());
        pageTemplate.setCreateDate(new Date());
        try {
            this.pageTemplateService.save(pageTemplate);
            contentInfo = pageTemplate.getId();
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
        return contentInfo;
    }

    @RequestMapping(value={"/queryPageTemplatenew"})
    @ResponseBody
    public Pagination<PageTemplate> queryPageTemplatenew(PageTemplate pageTemplate, @RequestParam(value="start") int offset, @RequestParam(value="limit") int limit, @RequestParam(required=false) String dir, HttpServletResponse response) throws IOException {
        Pageable paginationRequest = new Pageable(Integer.valueOf(offset / limit), Integer.valueOf(limit));
        if (StringUtils.hasText((String)pageTemplate.getLevels())) {
            ArrayList<Filter> filterList = new ArrayList<Filter>();
            Filter filter = new Filter("levels", Filter.Operator.like, (Object)pageTemplate.getLevels());
            filterList.add(filter);
            paginationRequest.setFilters(filterList);
        }
        Pagination pgn = this.pageTemplateService.findPage(paginationRequest);
        return pgn;
    }

    @RequestMapping(value={"/queryPageTemplatenew1"})
    @ResponseBody
    public void queryPageTemplatenew1(PageTemplate pageTemplate, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> listnew = this.pageTemplateService.queryBusinessProcessnew(pageTemplate);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<node>");
        for (Map<String, Object> m : listnew) {
            sb.append("<node id=\"" + m.get("RES_ID") + "\" name=\"" + m.get("NAME") + "\" action=\"" + m.get("ACTION") + "\" businessTypeId=\"" + m.get("BUSINESS_TYPE_ID") + "\" remark=\"" + m.get("MEMO") + "\" creator=\"" + m.get("RES_CREATOR") + "\" editDate=\"" + m.get("RES_EDIT_DATE") + "\" businessTypeName=\"" + m.get("BUSINNAME") + "\" >\n");
            sb.append("</node>");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/updatePageTemplatenew"}, method={RequestMethod.POST})
    @ResponseBody
    public Long updatePageTemplatenew(PageTemplate pageTemplate) {
        long pageresult = 0L;
        Principal principal = (Principal)SecurityUtils.getSubject().getPrincipal();
        pageTemplate.setEditor(principal.getId().toString());
        pageTemplate.setEditDate(new Date());
        try {
            if (pageTemplate.getId() != null) {
                this.pageTemplateService.update(pageTemplate);
            } else {
                this.pageTemplateService.save(pageTemplate);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
        return pageresult;
    }

    @RequestMapping(value={"/delPageTemplatenew"})
    @ResponseBody
    public Long delPageTemplatenew(PageTemplate pageTemplate) {
        String[] namelist;
        long pageresult = 0L;
        for (String name : namelist = pageTemplate.getName().toString().split(",")) {
            if (name == "" || name == null) continue;
            try {
                this.pageTemplateService.delete(Long.valueOf(name));
            }
            catch (Throwable t) {
                t.printStackTrace(System.out);
            }
        }
        return pageresult;
    }

    @RequestMapping(value={"/saveFlowMenu"})
    @ResponseBody
    public Long saveFlowMenu(PageTemplate bp) {
        long workItem = 0L;
        try {
            Principal principal = (Principal)SecurityUtils.getSubject().getPrincipal();
            bp.setEditor(principal.getId().toString());
            bp.setEditDate(new Date());
            this.pageTemplateService.updateBusinessProcessMenu(bp);
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
        return workItem;
    }

    @RequestMapping(value={"/querySpringBeannew"})
    @ResponseBody
    public void querySpringBeannew(String type, HttpServletResponse response) throws IOException {
        StringBuilder sb = new StringBuilder();
        List<String> list = FlowSpringBeanUtil.querySpringBean(type);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node>\n");
        for (String name : list) {
            sb.append("<node value=\"" + name + "\" />\n");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/queryTransctrlsnew"})
    @ResponseBody
    public void queryTransctrlsnew(Long id, HttpServletResponse response) throws IOException {
        IActivityInstService activityInstService = ProcessEnginerHolder.getInstance().getActivityInstService();
        StringBuilder sb = new StringBuilder();
        List transCtrls = activityInstService.findTransCtrls(id.longValue());
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<activities>\n<transctrls>\n");
        for (TransCtrl tc : transCtrls) {
            sb.append("<transctrl srcId=\"" + tc.getSrcActDefId() + "\" destId=\"" + tc.getDestActDefId() + "\" />\n");
        }
        sb.append("</transctrls>\n<noFinishActs>\n");
        List activityInsts = activityInstService.findWaitingAndTerminateAndRunningActivityInst(id.longValue());
        for (ActivityInst activityInst : activityInsts) {
            sb.append("<activity id=\"" + activityInst.getActivityDefId() + "\" status=\"" + activityInst.getCurrentState() + "\" />\n");
        }
        sb.append("</noFinishActs></activities>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/deleteFlownew"})
    @ResponseBody
    public ResponseData deleteFlownew(long processDefId) {
        IProcessDefineService iProcessDefineService = ProcessEnginerHolder.getInstance().getProcessDefineService();
        iProcessDefineService.deleteProcessDefine(processDefId);
        return ResponseData.SUCCESS_NO_DATA;
    }

    @RequestMapping(value={"/publishFlownew"})
    @ResponseBody
    public ResponseData publishFlownew(long processDefId, String processDefName) {
        IProcessDefineService iProcessDefineService = ProcessEnginerHolder.getInstance().getProcessDefineService();
        iProcessDefineService.publishProcessDefine(processDefName, processDefId);
        return ResponseData.SUCCESS_NO_DATA;
    }
}

