/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.usiflow.webframe.web.controller.flowadmin;

import com.cpi.framework.dao.support.Filter;
import com.cpi.framework.dao.support.Pageable;
import com.cpi.framework.dao.support.Pagination;
import com.cpi.framework.modules.security.shiro.Principal;
import com.cpi.framework.web.common.ResponseData;
import com.cpi.framework.web.controller.BaseController;
import com.cpi.usiflow.webframe.flow.FlowSpringBeanUtil;
import com.cpi.usiflow.webframe.flow.ProcessEnginerHolder;
import com.cpi.usiflow.webframe.web.model.flow.FlowOperation;
import com.cpi.usiflow.webframe.web.model.flow.ProcessLib;
import com.cpi.usiflow.webframe.web.service.flow.BusinessTypeService;
import com.cpi.usiflow.webframe.web.service.flow.FlowOperationService;
import com.cpi.usiflow.webframe.web.service.flow.ProcessLibService;
import com.ustcsoft.usiflow.engine.model.ActivityInst;
import com.ustcsoft.usiflow.engine.model.TransCtrl;
import com.ustcsoft.usiflow.engine.service.IActivityInstService;
import com.ustcsoft.usiflow.engine.service.IProcessDefineService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/operAdmin"})
public class FlowOpertorController
extends BaseController {
    @Autowired
    private BusinessTypeService businessTypeService;
    @Autowired
    private FlowOperationService flowOperationService;
    @Autowired
    private ProcessLibService processLibService;

    @RequestMapping(value={"/index"})
    public String index() {
        return "workflow/flowOpertor";
    }

    @RequestMapping(value={"/busiType"})
    public String busiType() {
        return "workflow/busiType";
    }

    @RequestMapping(value={"/flowDesigner"})
    public String flowDesigner() {
        return "workflow/flowDesigner";
    }

    @RequestMapping(value={"/viewFlow"})
    public String viewFlow() {
        return "workflow/viewFlow";
    }

    @RequestMapping(value={"/workItem"})
    public String workItem() {
        return "workflow/workItem";
    }

    @RequestMapping(value={"/savePageTemplatenew"})
    @ResponseBody
    public Long savePageTemplatenew(FlowOperation flowOperation) {
        long contentInfo = 0L;
        Principal principal = (Principal)SecurityUtils.getSubject().getPrincipal();
        flowOperation.setCreator(principal.getId().toString());
        flowOperation.setCreateDate(new Date());
        try {
            this.flowOperationService.save(flowOperation);
            contentInfo = flowOperation.getId();
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
        return contentInfo;
    }

    @RequestMapping(value={"/queryPageTemplatenew"})
    @ResponseBody
    public Pagination<FlowOperation> queryPageTemplatenew(FlowOperation flowOperation, @RequestParam(value="start") int offset, @RequestParam(value="limit") int limit, @RequestParam(required=false) String dir, HttpServletResponse response) throws IOException {
        Pageable paginationRequest = new Pageable(Integer.valueOf(offset / limit), Integer.valueOf(limit));
        if (StringUtils.hasText((String)flowOperation.getLevels())) {
            ArrayList<Filter> filterList = new ArrayList<Filter>();
            filterList.add(Filter.like((String)"levels", (Object)flowOperation.getLevels()));
            paginationRequest.setFilters(filterList);
        }
        Pagination pgn = this.flowOperationService.findPage(paginationRequest);
        return pgn;
    }

    @RequestMapping(value={"/queryPageTemplatenew1"})
    @ResponseBody
    public void queryPageTemplatenew1(FlowOperation flowOperation, HttpServletResponse response) throws IOException {
        List<Map<String, Object>> listnew = this.flowOperationService.queryBusinessProcessnew(flowOperation);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<node>");
        for (Map<String, Object> m : listnew) {
            sb.append("<node id=\"" + m.get("RES_ID") + "\" name=\"" + m.get("NAME") + "\" action=\"" + m.get("ACTION") + "\" businessTypeId=\"" + m.get("BUSINESS_TYPE_ID") + "\" code=\"" + m.get("CODE") + "\" displayName=\"" + m.get("DISPLAY_NAME") + "\" remark=\"" + m.get("MEMO") + "\" creator=\"" + m.get("RES_CREATOR") + "\" editDate=\"" + m.get("RES_EDIT_DATE") + "\" businessTypeName=\"" + m.get("BUSINNAME") + "\" >\n");
            sb.append("</node>");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/updatePageTemplatenew"}, method={RequestMethod.POST})
    @ResponseBody
    public Long updatePageTemplatenew(FlowOperation flowOperation) {
        long pageresult = 0L;
        Principal principal = (Principal)SecurityUtils.getSubject().getPrincipal();
        flowOperation.setEditor(principal.getId().toString());
        flowOperation.setEditDate(new Date());
        try {
            if (flowOperation.getId() != null) {
                this.flowOperationService.update(flowOperation);
            } else {
                this.flowOperationService.save(flowOperation);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
        return pageresult;
    }

    @RequestMapping(value={"/delPageTemplatenew"})
    @ResponseBody
    public Long delPageTemplatenew(FlowOperation flowOperation) {
        String[] namelist;
        long pageresult = 0L;
        for (String name : namelist = flowOperation.getName().toString().split(",")) {
            if (name == "" || name == null) continue;
            try {
                this.flowOperationService.delete(Long.valueOf(name));
            }
            catch (Throwable t) {
                t.printStackTrace(System.out);
            }
        }
        return pageresult;
    }

    @RequestMapping(value={"/saveFlowMenu"})
    @ResponseBody
    public Long saveFlowMenu(FlowOperation bp) {
        long workItem = 0L;
        try {
            Principal principal = (Principal)SecurityUtils.getSubject().getPrincipal();
            bp.setEditor(principal.getId().toString());
            bp.setEditDate(new Date());
            this.flowOperationService.updateBusinessProcessMenu(bp);
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
        return workItem;
    }

    @RequestMapping(value={"/querySpringBeannew"})
    @ResponseBody
    public void querySpringBeannew(String type, HttpServletResponse response) throws IOException {
        StringBuilder sb = new StringBuilder();
        List<String> list = FlowSpringBeanUtil.querySpringBean(type);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node>\n");
        for (String name : list) {
            sb.append("<node value=\"" + name + "\" />\n");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/queryTransctrlsnew"})
    @ResponseBody
    public void queryTransctrlsnew(Long id, HttpServletResponse response) throws IOException {
        IActivityInstService activityInstService = ProcessEnginerHolder.getInstance().getActivityInstService();
        StringBuilder sb = new StringBuilder();
        List transCtrls = activityInstService.findTransCtrls(id.longValue());
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<activities>\n<transctrls>\n");
        for (TransCtrl tc : transCtrls) {
            sb.append("<transctrl srcId=\"" + tc.getSrcActDefId() + "\" destId=\"" + tc.getDestActDefId() + "\" />\n");
        }
        sb.append("</transctrls>\n<noFinishActs>\n");
        List activityInsts = activityInstService.findWaitingAndTerminateAndRunningActivityInst(id.longValue());
        for (ActivityInst activityInst : activityInsts) {
            sb.append("<activity id=\"" + activityInst.getActivityDefId() + "\" status=\"" + activityInst.getCurrentState() + "\" />\n");
        }
        sb.append("</noFinishActs></activities>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/deleteFlownew"})
    @ResponseBody
    public ResponseData deleteFlownew(long processDefId) {
        IProcessDefineService iProcessDefineService = ProcessEnginerHolder.getInstance().getProcessDefineService();
        iProcessDefineService.deleteProcessDefine(processDefId);
        return ResponseData.SUCCESS_NO_DATA;
    }

    @RequestMapping(value={"/publishFlownew"})
    @ResponseBody
    public ResponseData publishFlownew(long processDefId, String processDefName) {
        IProcessDefineService iProcessDefineService = ProcessEnginerHolder.getInstance().getProcessDefineService();
        iProcessDefineService.publishProcessDefine(processDefName, processDefId);
        return ResponseData.SUCCESS_NO_DATA;
    }

    @RequestMapping(value={"/saveFlowModel"})
    @ResponseBody
    public Long saveFlowModel(ProcessLib processLib) throws Exception {
        long contentInfo = 0L;
        try {
            this.processLibService.save(processLib);
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
        return contentInfo;
    }

    @RequestMapping(value={"/getFlowModel"})
    @ResponseBody
    public ProcessLib getFlowModel(ProcessLib processLib) throws Exception {
        ProcessLib proLib = (ProcessLib)this.processLibService.find(processLib.getId());
        return proLib;
    }
}

