/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.usiflow.webframe.web.controller.flow;

import com.cpi.framework.dao.support.Filter;
import com.cpi.framework.dao.support.Order;
import com.cpi.framework.dao.support.StatusEnum;
import com.cpi.framework.dao.utils.PrimaryKeyUtil;
import com.cpi.framework.modules.security.shiro.Principal;
import com.cpi.framework.web.common.ResponseData;
import com.cpi.framework.web.controller.BaseController;
import com.cpi.framework.web.entity.admin.FwOrg;
import com.cpi.framework.web.entity.admin.FwRoles;
import com.cpi.framework.web.entity.admin.FwUser;
import com.cpi.framework.web.service.admin.IFwUserService;
import com.cpi.usiflow.webframe.flow.FlowSpringBeanUtil;
import com.cpi.usiflow.webframe.flow.ProcessEnginerHolder;
import com.cpi.usiflow.webframe.web.model.flow.BusinessProcess;
import com.cpi.usiflow.webframe.web.model.flow.BusinessType;
import com.cpi.usiflow.webframe.web.service.admin.OrganizationService;
import com.cpi.usiflow.webframe.web.service.admin.RoleService;
import com.cpi.usiflow.webframe.web.service.flow.BusinessProcessService;
import com.cpi.usiflow.webframe.web.service.flow.BusinessTypeService;
import com.cpi.usiflow.webframe.web.service.flow.FlowUtilService;
import com.ustcsoft.usiflow.engine.model.ActivityInst;
import com.ustcsoft.usiflow.engine.model.ProcessDefine;
import com.ustcsoft.usiflow.engine.model.TransCtrl;
import com.ustcsoft.usiflow.engine.service.IActivityInstService;
import com.ustcsoft.usiflow.engine.service.IProcessDefineService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/flow"})
public class FlowController
extends BaseController {
    private static final String PROCESSDEFNAME_PREFIX = "flow.";
    @Autowired
    private BusinessTypeService businessTypeService;
    @Autowired
    private BusinessProcessService businessProcessService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private OrganizationService organizationService;
    @Resource(name="FwUserServiceImpl")
    private IFwUserService userService;
    @Resource(name="FlowUtilService")
    private FlowUtilService flowUtilService;

    @RequestMapping(value={"/index"})
    public String index() {
        return "workflow/flowAdmin";
    }

    @RequestMapping(value={"/busiType"})
    public String busiType() {
        return "workflow/busiType";
    }

    @RequestMapping(value={"/flowDesigner"})
    public String flowDesigner() {
        return "workflow/flowDesigner";
    }

    @RequestMapping(value={"/viewFlow"})
    public String viewFlow(Long processInstId, HttpServletRequest request) {
        Long processDefId = this.flowUtilService.getProCessDefId(processInstId);
        request.setAttribute("processInstId", (Object)processInstId);
        request.setAttribute("processDefId", (Object)processDefId);
        return "workflow/viewFlow";
    }

    @RequestMapping(value={"/workItem"})
    public String workItem() {
        return "workflow/workItem";
    }

    @RequestMapping(value={"/queryFlows"})
    @ResponseBody
    public List queryFlows(Long node, @RequestParam(required=false) String leafNode, @RequestParam(required=false) String type) {
        if (node == null) {
            node = 0L;
        }
        if (StringUtils.hasText((String)leafNode) && "Y".equals(leafNode)) {
            ArrayList<Filter> filterList = new ArrayList<Filter>();
            filterList.add(Filter.eq((String)"businessTypeId", (Object)node));
            ArrayList<Order> orderList = new ArrayList<Order>();
            orderList.add(Order.asc((String)"id"));
            List list = this.businessProcessService.findList(null, filterList, orderList);
            for (BusinessProcess busiProcess : list) {
                if (!"subflow".equals(busiProcess.getType())) continue;
                busiProcess.setIconCls("subflow");
            }
            return list;
        }
        if ("flow".equals(type) || "subflow".equals(type)) {
            IProcessDefineService iProcessDefineService = ProcessEnginerHolder.getInstance().getProcessDefineService();
            List list = iProcessDefineService.findProcessDefines(PROCESSDEFNAME_PREFIX + node);
            ArrayList processDefines = new ArrayList();
            for (ProcessDefine define : list) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", define.getProcessDefId());
                if (define.getCurrentState() == 3) {
                    map.put("text", define.getVersionSign() + "*");
                } else {
                    map.put("text", define.getVersionSign());
                }
                map.put("processDefName", define.getProcessDefName());
                map.put("versionSign", define.getVersionSign());
                map.put("leaf", true);
                map.put("iconCls", "version");
                map.put("type", "version");
                processDefines.add(map);
            }
            return processDefines;
        }
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        filterList.add(Filter.eq((String)"parentId", (Object)node));
        ArrayList<Order> orderList = new ArrayList<Order>();
        orderList.add(Order.asc((String)"orderIndex"));
        List list = this.businessTypeService.findList(null, filterList, orderList);
        for (BusinessType businessType : list) {
            businessType.setLeaf(false);
            if (!"Y".equals(businessType.getLeafNode())) continue;
            businessType.setIconCls("leaf");
        }
        return list;
    }

    @RequestMapping(value={"/queryFlowContent"})
    @ResponseBody
    public void queryFlowContent(Long id, HttpServletResponse response, HttpServletRequest request) throws IOException {
        IProcessDefineService iProcessDefineService = ProcessEnginerHolder.getInstance().getProcessDefineService();
        ProcessDefine processDefine = iProcessDefineService.findProcessDefine(id.longValue());
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(processDefine.getProcessDefContent());
    }

    @RequestMapping(value={"/queryParticipant4Org"})
    @ResponseBody
    public void queryParticipant4Org(Long id, HttpServletResponse response) throws IOException {
        if (id == null) {
            id = 0L;
        }
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        filterList.add(Filter.eq((String)"pId", (Object)id));
        filterList.add(Filter.eq((String)"status", (Object)StatusEnum.Y));
        List orgs = this.organizationService.findList(null, filterList, null);
        ArrayList<Filter> orgfilterList = new ArrayList<Filter>();
        orgfilterList.add(Filter.eq((String)"orgId", (Object)id));
        List users = this.userService.findList(null, orgfilterList, null);
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node>\n");
        for (FwOrg org : orgs) {
            sb.append("<node id=\"" + org.getId() + "\" name=\"" + org.getOrgName() + "\" type=\"organization\" />\n");
        }
        for (FwUser user : users) {
            sb.append("<node id=\"" + user.getId() + "\" name=\"" + user.getUsername() + "\" type=\"person\" />\n");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/queryParticipant4Role"})
    @ResponseBody
    public void queryParticipant4Role(Long id, HttpServletResponse response) throws IOException {
        if (id == null) {
            id = 0L;
        }
        List list = this.roleService.findAll();
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node>\n");
        for (FwRoles role : list) {
            sb.append("<node id=\"" + role.getId() + "\" name=\"" + role.getRoleName() + "\" type=\"role\" />\n");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/querySubFlow"})
    @ResponseBody
    public void querySubFlow(Long id, HttpServletResponse response) throws IOException {
        List busiTypes = null;
        List busiProcesses = null;
        if (id == 0L) {
            ArrayList<Filter> filterList = new ArrayList<Filter>();
            filterList.add(Filter.eq((String)"parentId", (Object)id));
            busiTypes = this.businessTypeService.findList(null, filterList, null);
        } else {
            ArrayList<Filter> filterList;
            BusinessType businessType = (BusinessType)this.businessTypeService.find(id);
            if ("N".equals(businessType.getLeafNode())) {
                filterList = new ArrayList<Filter>();
                filterList.add(Filter.eq((String)"parentId", (Object)id));
                busiTypes = this.businessTypeService.findList(null, filterList, null);
            } else {
                filterList = new ArrayList();
                filterList.add(Filter.eq((String)"businessTypeId", (Object)id));
                busiProcesses = this.businessProcessService.findList(null, filterList, null);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node>\n");
        if (busiTypes != null) {
            for (BusinessType busiType : busiTypes) {
                sb.append("<node id=\"" + busiType.getId() + "\" name=\"" + busiType.getName() + "\" type=\"busi\" />\n");
            }
        }
        if (busiProcesses != null) {
            for (BusinessProcess busiProcess : busiProcesses) {
                if (!"subflow".equals(busiProcess.getType())) continue;
                sb.append("<node id=\"flow." + busiProcess.getId() + "\" name=\"" + busiProcess.getFlowName() + "\" type=\"subflow\" />\n");
            }
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/querySpringBean"})
    @ResponseBody
    public void querySpringBean(String type, HttpServletResponse response) throws IOException {
        StringBuilder sb = new StringBuilder();
        List<String> list = FlowSpringBeanUtil.querySpringBean(type);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<node>\n");
        for (String name : list) {
            sb.append("<node value=\"" + name + "\" />\n");
        }
        sb.append("</node>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/queryTransctrls"})
    @ResponseBody
    public void queryTransctrls(Long id, HttpServletResponse response) throws IOException {
        IActivityInstService activityInstService = ProcessEnginerHolder.getInstance().getActivityInstService();
        StringBuilder sb = new StringBuilder();
        List transCtrls = activityInstService.findTransCtrls(id.longValue());
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<activities>\n<transctrls>\n");
        for (TransCtrl tc : transCtrls) {
            sb.append("<transctrl srcId=\"" + tc.getSrcActDefId() + "\" destId=\"" + tc.getDestActDefId() + "\" />\n");
        }
        sb.append("</transctrls>\n<noFinishActs>\n");
        List activityInsts = activityInstService.findWaitingAndTerminateAndRunningActivityInst(id.longValue());
        for (ActivityInst activityInst : activityInsts) {
            sb.append("<activity id=\"" + activityInst.getActivityDefId() + "\" status=\"" + activityInst.getCurrentState() + "\" />\n");
        }
        sb.append("</noFinishActs></activities>");
        response.setContentType("text/xml;charset=UTF-8");
        response.getWriter().write(sb.toString());
    }

    @RequestMapping(value={"/saveFlow"})
    @ResponseBody
    public Long saveFlow(ProcessDefine processDefine) {
        IProcessDefineService iProcessDefineService = ProcessEnginerHolder.getInstance().getProcessDefineService();
        boolean isUnique = iProcessDefineService.isUniqueProcessDefine(processDefine.getProcessDefName(), processDefine.getVersionSign());
        Principal principal = (Principal)SecurityUtils.getSubject().getPrincipal();
        if (!isUnique) {
            ProcessDefine pd = iProcessDefineService.findProcessDefine(processDefine.getProcessDefId());
            pd.setDescription(processDefine.getDescription());
            pd.setLimitTime(processDefine.getLimitTime());
            pd.setProcessDefContent(processDefine.getProcessDefContent());
            pd.setUpdateTime(new Date());
            pd.setUpdator(principal.getId().toString());
            iProcessDefineService.updateProcessDefine(pd);
        } else {
            processDefine.setProcessDefId(PrimaryKeyUtil.getPrimaryKey((String)"BusinessUsiFlow").longValue());
            processDefine.setCreateTime(new Date());
            processDefine.setCreator(principal.getId().toString());
            iProcessDefineService.insertProcessDefine(processDefine);
        }
        return processDefine.getProcessDefId();
    }

    @RequestMapping(value={"/deleteFlow"})
    @ResponseBody
    public ResponseData deleteFlow(long processDefId) {
        IProcessDefineService iProcessDefineService = ProcessEnginerHolder.getInstance().getProcessDefineService();
        iProcessDefineService.deleteProcessDefine(processDefId);
        return ResponseData.SUCCESS_NO_DATA;
    }

    @RequestMapping(value={"/publishFlow"})
    @ResponseBody
    public ResponseData publishFlow(long processDefId, String processDefName) {
        IProcessDefineService iProcessDefineService = ProcessEnginerHolder.getInstance().getProcessDefineService();
        iProcessDefineService.publishProcessDefine(processDefName, processDefId);
        return ResponseData.SUCCESS_NO_DATA;
    }
}

