/*
 * Decompiled with CFR 0.152.
 */
package com.cpi.usiflow.webframe.web.controller.demo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cpi.framework.dao.support.Filter;
import com.cpi.framework.dao.support.Order;
import com.cpi.framework.dao.support.Pageable;
import com.cpi.framework.dao.support.Pagination;
import com.cpi.framework.modules.security.shiro.Principal;
import com.cpi.framework.web.common.ResponseData;
import com.cpi.framework.web.controller.BaseController;
import com.cpi.framework.web.entity.admin.FwUser;
import com.cpi.usiflow.webframe.web.model.demo.HrJLeave;
import com.cpi.usiflow.webframe.web.service.demo.HrJLeaveService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/hrleave"})
public class HrJLeaveController
extends BaseController {
    @Autowired
    private HrJLeaveService hrJLeaveService;

    @RequestMapping(value={"/index"})
    public ModelAndView index() {
        ModelAndView model = new ModelAndView("demo/leave/leave", "loginUser", (Object)((Principal)SecurityUtils.getSubject().getPrincipal()));
        return model;
    }

    @RequestMapping(value={"/pageQueryLeaves"})
    @ResponseBody
    public Pagination<HrJLeave> pageQueryLeaves(@RequestParam(value="start") int offset, @RequestParam(value="limit") int limit, HrJLeave leave, @RequestParam(required=false) String sort, @RequestParam(required=false) String dir) {
        Filter filter;
        Pageable paginationRequest = new Pageable(Integer.valueOf(offset / limit), Integer.valueOf(limit));
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        ArrayList<Order> orderList = new ArrayList<Order>();
        if (StringUtils.hasText((String)sort) && StringUtils.hasText((String)dir)) {
            Order order = null;
            order = "ASC".equals(dir.toUpperCase()) ? new Order(sort, Order.Direction.asc) : new Order(sort, Order.Direction.desc);
            orderList.add(order);
        }
        if (StringUtils.hasText((String)leave.getLeaveCode())) {
            filter = new Filter("leaveCode", Filter.Operator.eq, (Object)leave.getLeaveCode());
            filterList.add(filter);
        }
        if (StringUtils.hasText((String)leave.getLeaveType()) && !"ALL".equals(leave.getLeaveType())) {
            filter = new Filter("leaveType", Filter.Operator.eq, (Object)leave.getLeaveType());
            filterList.add(filter);
        }
        if (StringUtils.hasText((String)leave.getLeaveReason())) {
            filter = new Filter("leaveReason", Filter.Operator.like, (Object)leave.getLeaveReason());
            filterList.add(filter);
        }
        paginationRequest.setFilters(filterList);
        paginationRequest.setOrders(orderList);
        Pagination page = this.hrJLeaveService.findPage(paginationRequest);
        return page;
    }

    @RequestMapping(value={"/pageQueryMyLeaves"})
    @ResponseBody
    public Pagination<HrJLeave> pageQueryMyLeaves(@RequestParam(value="start") int offset, @RequestParam(value="limit") int limit, HrJLeave leave, @RequestParam(required=false) String sort, @RequestParam(required=false) String dir) {
        Pageable paginationRequest = new Pageable(Integer.valueOf(offset / limit), Integer.valueOf(limit));
        Principal principal = (Principal)SecurityUtils.getSubject().getPrincipal();
        List<Long> processInstIdLs = this.hrJLeaveService.findProcessIdByUser(principal.getLoginName());
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        ArrayList<Order> orderList = new ArrayList<Order>();
        if (processInstIdLs != null && processInstIdLs.size() > 0) {
            Filter filter = new Filter("processinstid", Filter.Operator.in, processInstIdLs);
            filterList.add(filter);
            if (StringUtils.hasText((String)sort) && StringUtils.hasText((String)dir)) {
                Order order = null;
                order = "ASC".equals(dir.toUpperCase()) ? new Order(sort, Order.Direction.asc) : new Order(sort, Order.Direction.desc);
                orderList.add(order);
            }
            if (StringUtils.hasText((String)leave.getLeaveCode())) {
                filter = new Filter("leaveCode", Filter.Operator.eq, (Object)leave.getLeaveCode());
                filterList.add(filter);
            }
            if (StringUtils.hasText((String)leave.getLeaveType()) && !"ALL".equals(leave.getLeaveType())) {
                filter = new Filter("leaveType", Filter.Operator.eq, (Object)leave.getLeaveType());
                filterList.add(filter);
            }
            if (StringUtils.hasText((String)leave.getLeaveReason())) {
                filter = new Filter("leaveReason", Filter.Operator.like, (Object)leave.getLeaveReason());
                filterList.add(filter);
            }
            paginationRequest.setFilters(filterList);
            paginationRequest.setOrders(orderList);
            Pagination page = this.hrJLeaveService.findPage(paginationRequest);
            return page;
        }
        return new Pagination();
    }

    @RequestMapping(value={"/insertLeave"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData insertLeave(HrJLeave leave) {
        if (this.isExistedLeaveCode(leave.getLeaveCode())) {
            ResponseData res = ResponseData.error((String)"\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728\uff01");
            return res;
        }
        FwUser fwUSer = this.hrJLeaveService.getCurentUser();
        leave.setCreateBy(fwUSer.getLogincode());
        leave.setOrgId(fwUSer.getOrgId().getId());
        leave.setCreateTime(new Date());
        leave.setStatus("DRAFT");
        this.hrJLeaveService.startFlow(leave, "flow.791");
        return ResponseData.SUCCESS_NO_DATA;
    }

    @RequestMapping(value={"/updateLeave"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData updateLeave(HrJLeave leave) {
        HrJLeave oldLeave = (HrJLeave)this.hrJLeaveService.find(leave.getId());
        Principal principal = (Principal)SecurityUtils.getSubject().getPrincipal();
        leave.setCreateBy(oldLeave.getCreateBy());
        leave.setOrgId(oldLeave.getOrgId());
        leave.setCreateTime(oldLeave.getCreateTime());
        leave.setEditBy(principal.getLoginName());
        leave.setEditTime(new Date());
        leave.setStatus(oldLeave.getStatus());
        if (oldLeave.getProcessinstid() != null) {
            leave.setProcessinstid(oldLeave.getProcessinstid());
        }
        this.hrJLeaveService.update(leave);
        return ResponseData.SUCCESS_NO_DATA;
    }

    @RequestMapping(value={"/deleteLeave"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData deleteLeave(String deleteIds) {
        JSONArray jsonArray = JSON.parseArray((String)deleteIds);
        for (JSONObject jsonob : jsonArray) {
            this.hrJLeaveService.delete(jsonob.getLong("id"));
        }
        return ResponseData.SUCCESS_NO_DATA;
    }

    private boolean isExistedLeaveCode(String leaveCode) {
        boolean flag = false;
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        Filter filter = new Filter("leaveCode", Filter.Operator.eq, (Object)leaveCode);
        filterList.add(filter);
        List listLeaves = this.hrJLeaveService.findList(null, filterList, null);
        if (listLeaves.size() > 0) {
            flag = true;
        }
        return flag;
    }
}

