package com.cpi.framework.web.service.admin.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cpi.framework.core.cache.CacheNames;
import com.cpi.framework.dao.support.Pageable;
import com.cpi.framework.dao.support.Pagination;
import com.cpi.framework.dao.support.StatusEnum;
import com.cpi.framework.modules.security.shiro.Principal;
import com.cpi.framework.service.jpa.impl.BaseServiceImpl;
import com.cpi.framework.web.dao.admin.IFwUserDao;
import com.cpi.framework.web.entity.admin.FwOrg;
import com.cpi.framework.web.entity.admin.FwRoles;
import com.cpi.framework.web.entity.admin.FwRoles.RoleEnum;
import com.cpi.framework.web.entity.admin.FwUser;
import com.cpi.framework.web.service.admin.IFwUserService;

/**
 * 用户信息Service层实现
 * @author BridgeBai
 *
 */
@Transactional
@Service("FwUserServiceImpl")
public class FwUserServiceImpl extends BaseServiceImpl<FwUser, Long> implements IFwUserService {


	@Resource(name = "FwUserDaoImpl")
	private IFwUserDao fwUserDao;

	@Resource(name = "FwUserDaoImpl")
	public void setBaseDao(IFwUserDao fwUsernDao) {
		super.setBaseDao(fwUsernDao);
	}
	@Override
	@Transactional(readOnly = true)
	public boolean loginNameExists(String loginName) {
		return fwUserDao.loginNameExists(loginName);
	}

	@Override
	@Transactional(readOnly = true)
	public FwUser findByLoginName(String loginName) {
		return fwUserDao.findByLoginName(loginName);
	}
	
	/**
	 * 根据ID对象查找用户角色
	 * @param Id ID
	 * @return 角色,若不存在则返回null
	 */
	@Override
	@Transactional(readOnly = true)
	public Set<FwRoles> findRoles(Long id){
		FwUser fwUser = fwUserDao.find(id);
		if (fwUser != null) {			
			return fwUser.getFwRoles();
		}
		return null;
	}
	
	@Override
	@Transactional(readOnly = true)
	@Cacheable(value=CacheNames.RESOURCE_CACHE_NAME,key="#root.targetClass")
	public Map<Long,FwUser> findAllUser() {
		Map<Long,FwUser> usersMap=new HashMap<Long, FwUser>();
		List<FwUser> fwUsers=super.findAll();
		for(FwUser fwUser:fwUsers){
			if(StatusEnum.Y.equals(fwUser.getStatus())){
			   usersMap.put(fwUser.getId(), fwUser);
			}
		}
		return usersMap;
	}

	@Override
	@Transactional(readOnly = true)
	public boolean isAuthenticated() {
		Subject subject = SecurityUtils.getSubject();
		if (subject != null) {
			return subject.isAuthenticated();
		}
		return false;
	}

	@Override
	@Transactional(readOnly = true)
	public boolean isSuperAdmin() {
		return getCurrent().isSuperAdminRole();
	}

	@Override
	@Transactional(readOnly = true)
	public FwUser getCurrent() {
		Subject subject = SecurityUtils.getSubject();
		if (subject != null) {
			Principal principal = (Principal) subject.getPrincipal();
			if (principal != null) {
				return fwUserDao.find(principal.getId());
			}
		}
		return null;
	}

	@Override
	@Transactional(readOnly = true)
	public Principal getCurrentPrincipal() {
		Subject subject = SecurityUtils.getSubject();
		if (subject != null) {
			Principal principal = (Principal) subject.getPrincipal();
			if (principal != null) {
				return principal;
			}
		}
		return null;
	}
	
	@Override
	@Transactional(readOnly = true)
	public List<FwUser> findOrgUsers(FwOrg fwOrg) {
		return fwUserDao.findOrgUsers(fwOrg);
	}
	
	@Override
	@CacheEvict(value=CacheNames.RESOURCE_CACHE_NAME,key="#root.targetClass")
	public FwUser updateFwUser(FwUser fwUser) {		
		return super.update(fwUser);
	}
	
	@Override
	@CacheEvict(value=CacheNames.RESOURCE_CACHE_NAME,key="#root.targetClass")
	public void deleteFwUser(FwUser fwUser) {
		super.delete(fwUser);
		
	}
	@Override
	public Pagination<FwUser> findWaitMember(List<Long> memberIds,
			String queryName, Integer start, Integer limit) {
		return fwUserDao.findWaitMember(memberIds, queryName, start, limit);
	}
	@Override
	public void deleteUser(List<Long> userIds) {
		fwUserDao.deleteUser(userIds);
	}
	
	/**
	 * 功能 : 查询人员部门弹出框
	 * 开发：wwzhang 2015-11-5 下午4:25:29
	 * @param deptId部门id
	 * @param userName 用户姓名
	 * @return
	 * @throws Exception
	 */
	@Override
	@Transactional(readOnly = true)
	public List<FwUser> findUserAndOrg(String deptId,String userName,int page,int rows){
		List<FwUser> fwUsers=fwUserDao.findUserAndOrg(deptId,userName,page,rows);
		return fwUsers;
	}
	
	/**
	 * 
	 * 功能 :查询数据个总数
	
	 * 开发：wwzhang 2015-11-9
	
	 * @param deptId      部门id
	 * @param userName    用户姓名
	 * @return
	 */
	public Long getCount(String deptId, String userName){
		Long count = fwUserDao.getCount(deptId,userName);
		return count;
	}
	
	@Override
	public Pagination<FwUser> findLikeUserName(String userName,	Pageable pageable) {
		return fwUserDao.findLikeUserName(userName, pageable);
	}
	
	@Override
	public List<FwUser> findUserByRoleType(RoleEnum roleEnum) {
		return fwUserDao.findUserByRoleType(roleEnum);
	}
	@Override
	public List<FwUser> findUserByPermisson(String permissionCode) {
		Set<FwUser> fwUsers=new HashSet<FwUser>();
		fwUsers.addAll(fwUserDao.findUserByPermisson(permissionCode));
		fwUsers.addAll(fwUserDao.findUserByRolePermisson(permissionCode));
		fwUsers.addAll(fwUserDao.findUserByStationPermisson(permissionCode));
		return new ArrayList<FwUser>(fwUsers);
	}
}
