package com.cpi.framework.web.service.admin.impl;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cpi.framework.dao.support.Filter;
import com.cpi.framework.dao.support.Filter.Operator;
import com.cpi.framework.dao.support.Order;
import com.cpi.framework.dao.support.Order.Direction;
import com.cpi.framework.dao.support.StatusEnum;
import com.cpi.framework.service.jpa.impl.BaseServiceImpl;
import com.cpi.framework.web.dao.admin.IFwStationDao;
import com.cpi.framework.web.entity.admin.FwStation;
import com.cpi.framework.web.service.admin.IFwStationService;

/**
 * 功能 ：岗位管理Service层实现定义
 * @author zwwang  2015-6-3 上午11:47:05
 */
@Transactional
@Service("FwStationServiceImpl")
public class FwStationServiceImpl extends BaseServiceImpl<FwStation, Long> implements IFwStationService {
	
	@Resource(name = "FwStationDaoImpl")
	private IFwStationDao fwStationDao;

	@Resource(name = "FwStationDaoImpl")
	public void setBaseDao(IFwStationDao fwStationDao) {
		super.setBaseDao(fwStationDao);
	}

	@Override
	@Transactional(readOnly = true)
	public List<FwStation> findStationList(Long orgId) {
		List<Filter> filters = new ArrayList<Filter>();
		if (orgId != null) {
			filters.add(new Filter("orgId", Operator.eq, orgId));
		}
		filters.add(new Filter("status", Operator.eq, StatusEnum.Y));
		List<Order> orders = new ArrayList<Order>();
		orders.add(new Order("orderNo", Direction.asc));
		return fwStationDao.findList(null, null, filters, orders);
	}

	@Override
	public void deleteStation(List<Long> ids) {
		fwStationDao.deleteStation(ids);
	}

}
