package com.cpi.framework.web.service.admin.impl;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import com.cpi.framework.dao.support.Filter;
import com.cpi.framework.dao.support.Order;
import com.cpi.framework.dao.support.StatusEnum;
import com.cpi.framework.service.jpa.impl.BaseServiceImpl;
import com.cpi.framework.web.dao.admin.IFwRolesDao;
import com.cpi.framework.web.entity.admin.FwRoles;
import com.cpi.framework.web.service.admin.IFwRolesService;

/**
 * 功能 ：角色管理Service层实现定义
 * @author zwwang  2015-6-9 上午10:19:42
 */
@Transactional
@Service("FwRolesServiceImpl")
public class FwRolesServiceImpl extends BaseServiceImpl<FwRoles, Long> implements IFwRolesService {

	@Resource(name = "FwRolesDaoImpl")
	private IFwRolesDao fwRolesDao;
	
	@Resource(name = "FwRolesDaoImpl")
	public void setBaseDao(IFwRolesDao fwRolesDao) {
		super.setBaseDao(fwRolesDao);
	}

	@Transactional(readOnly = true)
	@Override
	public List<FwRoles> findRolesList(Long orgId) {
		List<Filter> filters = new ArrayList<Filter>();
		if (!StringUtils.isEmpty(orgId)) {
			filters.add(Filter.eq("orgId", orgId));
		}
		filters.add(Filter.eq("status", StatusEnum.Y));
		List<Order> orders = new ArrayList<Order>();
		orders.add(Order.asc("orgId"));
		orders.add(Order.asc("roleType"));
		orders.add(Order.asc("orderNo"));
		return fwRolesDao.findList(null, null, filters, orders);
	}

	@Override
	public void deleteRoles(List<Long> roleIds) {
		fwRolesDao.deleteRoles(roleIds);
	}
}
