package com.cpi.framework.web.service.admin.impl;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import com.cpi.framework.dao.support.Filter;
import com.cpi.framework.dao.support.Order;
import com.cpi.framework.dao.support.StatusEnum;
import com.cpi.framework.service.jpa.impl.BaseServiceImpl;
import com.cpi.framework.web.dao.admin.IFwPermissionsDao;
import com.cpi.framework.web.entity.admin.FwPermissions;
import com.cpi.framework.web.service.admin.IFwPermissionsService;

/**
 * 功能 ：权限管理Service层实现定义
 * @author zwwang  2015-6-4 上午9:58:03
 */
@Service("FwPermissionsServiceImpl")
@Transactional
public class FwPermissionsServiceImpl extends BaseServiceImpl<FwPermissions, Long> implements IFwPermissionsService {

	@Resource(name = "FwPermissionsDaoImpl")
	private IFwPermissionsDao fwPermissionsDao;

	@Resource(name = "FwPermissionsDaoImpl")
	public void setBaseDao(IFwPermissionsDao fwPermissionsDao) {
		super.setBaseDao(fwPermissionsDao);
	}

	@Override
	@Transactional(readOnly = true)
	public List<FwPermissions> findPermissionsList(String permissionName, String permissionType) {
		List<Filter> filters = new ArrayList<Filter>();
		if (!StringUtils.isEmpty(permissionName)) {
			filters.add(Filter.like("permissionName", "%" + permissionName + "%"));
		}
		if (!StringUtils.isEmpty(permissionType) && !"all".equals(permissionType)) {
			filters.add(Filter.eq("permissionType", permissionType));
		}
		filters.add(Filter.eq("status", StatusEnum.Y));
		List<Order> orders = new ArrayList<Order>();
		orders.add(Order.asc("permissionType"));
		orders.add(Order.asc("orderNo"));
		return fwPermissionsDao.findList(null, null, filters, orders);
	}

	@Override
	public void deletePermissions(List<Long> ids) {
		fwPermissionsDao.deletePermissions(ids);
	}
	
}
