package com.cpi.framework.web.service.admin.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cpi.framework.dao.support.Filter;
import com.cpi.framework.dao.support.Order;
import com.cpi.framework.dao.support.Filter.Operator;
import com.cpi.framework.dao.support.Order.Direction;
import com.cpi.framework.service.jpa.impl.BaseServiceImpl;
import com.cpi.framework.web.dao.admin.IFwPendingMessageDao;
import com.cpi.framework.web.entity.admin.FwPendingDetails;
import com.cpi.framework.web.entity.admin.FwPendingMessage;
import com.cpi.framework.web.service.admin.IFwPendingMessageService;


@Transactional
@Service("FwPendingMessageServiceImpl")
public class FwPendingMessageServiceImpl extends BaseServiceImpl<FwPendingMessage, Long> implements IFwPendingMessageService {

	@Resource(name="FwPendingMessageDaoImpl")
	private IFwPendingMessageDao fwPendingMessageDao;
	
	@Resource(name = "FwPendingMessageDaoImpl")
	public void setBaseDao(IFwPendingMessageDao fwPendingMessageDao) {
		super.setBaseDao(fwPendingMessageDao);
	}

	@Override
	public void updateMsgStatus(Long processInstId,Long userId,boolean TH) {
		List<Filter> filters = new ArrayList<Filter>();
		List<Order> orderList = new ArrayList<Order>();
		Order order=new Order("createDate", Direction.desc);
		orderList.add(order);
		filters.add(new Filter("processInstId", Operator.eq, processInstId));		
		List<FwPendingMessage> fwPendingMessages= fwPendingMessageDao.findList(null, null, filters, orderList);
		if(fwPendingMessages!=null && fwPendingMessages.size()>0){
			FwPendingMessage fwPendingMessage=fwPendingMessages.get(0);
			boolean isAllDeal=true;
			for(Iterator<FwPendingDetails> it=fwPendingMessage.getFwPendingDetails().iterator();it.hasNext();){
				FwPendingDetails fwPendingDetail=it.next();
				if(userId.equals(fwPendingDetail.getReceiverId()) && !fwPendingDetail.getIsDeal()){
					fwPendingDetail.setIsDeal(true);
					fwPendingDetail.setRead(true);
					fwPendingDetail.setReadTime(new Date());
					break;
				}else{
					isAllDeal=isAllDeal&&fwPendingDetail.getIsDeal();
				}
			}
			if(isAllDeal||TH){//明细全部办完时或者退回时改变主表状态
				fwPendingMessage.setIsdeal(true);
			}
			super.update(fwPendingMessage);
		}
		
	}
	@Override
	public List<FwPendingMessage> queryUserPendingMsg(Long userId) {		
		return fwPendingMessageDao.queryUserPendingMsg(userId);
	}

	@Override
	public List<FwPendingMessage> findFwMessageByBusiness(Long business) {
		return fwPendingMessageDao.findFwMessageByBusiness(business);
	}
	
	
}
