package com.cpi.framework.web.service.admin.impl;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cpi.framework.dao.support.Filter;
import com.cpi.framework.dao.support.Order;
import com.cpi.framework.dao.support.StatusEnum;
import com.cpi.framework.service.jpa.impl.BaseServiceImpl;
import com.cpi.framework.web.dao.admin.IFwOrgDao;
import com.cpi.framework.web.entity.admin.FwOrg;
import com.cpi.framework.web.entity.admin.FwUser;
import com.cpi.framework.web.service.admin.IFwOrgService;
@Transactional
@Service("FwOrgServiceImpl")
public class FwOrgServiceImpl extends BaseServiceImpl<FwOrg, Long> implements IFwOrgService {
	@Resource(name = "FwOrgDaoImpl")
	private IFwOrgDao fwOrgDao;

	@Resource(name = "FwOrgDaoImpl")
	public void setBaseDao(IFwOrgDao fwOrgDao) {
		super.setBaseDao(fwOrgDao);
	}

	@Override
	@Transactional(readOnly=true)
	public List<FwOrg> findChildOrgs(Long parentId,String orgName) {
		List<Filter> filters=new ArrayList<Filter>();
		List<Order> orders=new ArrayList<Order>();
		filters.add(Filter.eq("pId", parentId));
		filters.add(Filter.eq("status", StatusEnum.Y));
		if(StringUtils.isNotBlank(orgName)){
		   filters.add(Filter.like("orgName","%"+ orgName+"%"));
		}
		orders.add(Order.asc("orderNo"));
		List<FwOrg> fwOrgs= super.findList(null, filters, orders);
		return fwOrgs;
	}

	@Override
	public List<FwOrg> findChargeOrgs(FwUser fwUser) {
		List<Filter> filters=new ArrayList<Filter>();
		List<Order> orders=new ArrayList<Order>();
		filters.add(Filter.eq("chargeLeader", fwUser));
		filters.add(Filter.eq("status", StatusEnum.Y));
		orders.add(Order.asc("orderNo"));
		return super.findList(null, filters, orders);
	}
	
	@Transactional(readOnly = true)
	@Override
	public FwOrg findFwOrgs(Long deptId){
		return fwOrgDao.findFwOrgs(deptId);
	}
}
