
package com.cpi.framework.web.service.admin.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

import org.springframework.core.task.TaskExecutor;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import com.cpi.framework.modules.utils.DateUtils;
import com.cpi.framework.web.dao.admin.IFwUserDao;
import com.cpi.framework.web.entity.admin.FwOrg;
import com.cpi.framework.web.entity.admin.FwUser;
import com.cpi.framework.web.service.admin.IFwMailService;

/**
 * Service - 邮件
 * 
 * @author Bridgebai
 */
@Service("FwMailServiceImpl")
public class FwMailServiceImpl implements IFwMailService {
	
	@Resource(name = "javaMailSender")
	private JavaMailSenderImpl javaMailSender;
	@Resource(name = "taskExecutor")
	private TaskExecutor taskExecutor;	
	@Resource(name = "FwUserDaoImpl")
	private IFwUserDao fwUserDao;
	/**
	 * 添加邮件发送任务
	 * 
	 * @param mimeMessage
	 *            MimeMessage
	 */
	private void addSendTask(final MimeMessage mimeMessage) {
		try {
			taskExecutor.execute(new Runnable() {
				public void run() {
					javaMailSender.send(mimeMessage);
				}
			});
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	@Override
	public void send(String toMail, String subject,boolean async) {
		Assert.hasText(toMail);
		Assert.hasText(subject);
		try {
			StringBuilder sb = new StringBuilder();
			sb.append("各位领导、同事：<br><br>");
			sb.append("<div style='text-indent:8mm;'>请在周四完成本周的工时填报。<br><br><br></div>");
			sb.append("<div style='text-indent:40mm;'>项目组<br></div>");
			sb.append("<div style='text-indent:32mm;'>"+DateUtils.getNow()+"</div>");
			MimeMessage mimeMessage = javaMailSender.createMimeMessage();
			MimeMessageHelper mimeMessageHelper = new MimeMessageHelper(mimeMessage, false, "utf-8");
			mimeMessageHelper.setFrom(" <" + javaMailSender.getUsername() + ">");
			mimeMessageHelper.setSubject(subject);
			mimeMessageHelper.setTo(toMail);
			mimeMessageHelper.setText(sb.toString(), true);
			if (async) {
				addSendTask(mimeMessage);
			} else {
				javaMailSender.send(mimeMessage);
			}
		} catch (MessagingException e) {
			e.printStackTrace();
		}
	}

	@Override
	public void sendAll(String subject, boolean async) {
	  List<FwOrg> fwOrgs=new ArrayList<FwOrg>();
	  fwOrgs.add(new FwOrg(2l)); //公司领导部门
	  fwOrgs.add(new FwOrg(3l)); //综合管理部
	  fwOrgs.add(new FwOrg(4l)); //财务部
	  List<FwUser> fwUsers=fwUserDao.findUsersNotInOrgs(fwOrgs);
	  for(Iterator<FwUser> it=fwUsers.iterator(); it.hasNext();){
		  FwUser fwUser=it.next();
		  send(fwUser.getEmail(),subject,async);
	  }
		
	}
	
}