package com.cpi.framework.web.service.admin.impl;

import java.io.IOException;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.apache.jcs.engine.control.CompositeCacheManager;
import org.springframework.cache.CacheManager;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;

import com.cpi.framework.web.service.admin.IFwCacheService;

/**
 * Service - 缓存
 * 
 * @author BridgeBai
 */
@Service("FwCacheServiceImpl")
public class FwCacheServiceImpl implements IFwCacheService {

	@Resource(name = "cacheManager")
	private CacheManager cacheManager;
	@Resource(name = "ehCacheManager")
	private net.sf.ehcache.CacheManager shiroEhcacheManager;
	@Resource(name = "messageSource")
	private ReloadableResourceBundleMessageSource reloadableResourceBundleMessageSource;

	@Override
	public void clearCache() {
		reloadableResourceBundleMessageSource.clearCache();
		if (this.shiroEhcacheManager !=null){
				shiroEhcacheManager.clearAll();
		}
		if (this.cacheManager !=null){
			if( this.cacheManager instanceof  net.sf.ehcache.CacheManager){
				((net.sf.ehcache.CacheManager)this.cacheManager).clearAll();
			}
		}
	}

	@Override
	public void clearCache(String cacheName) {
		if(StringUtils.isNotBlank(cacheName)){
			if (this.shiroEhcacheManager !=null){
				shiroEhcacheManager.getCache(cacheName).removeAll();
		    }
			if (this.cacheManager !=null){
				if( this.cacheManager instanceof  net.sf.ehcache.CacheManager){
					((net.sf.ehcache.CacheManager)this.cacheManager).getCache(cacheName).removeAll();
				}
				if( this.cacheManager instanceof  CompositeCacheManager){
					try {
						((CompositeCacheManager)this.cacheManager).getCache(cacheName).removeAll();
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
				}
			}
		}
		
	}

}