package com.cpi.framework.web.service.admin;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.cas.CasAuthenticationException;
import org.apache.shiro.cas.CasRealm;
import org.apache.shiro.cas.CasToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.StringUtils;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.cpi.framework.modules.security.shiro.Principal;
import com.cpi.framework.web.dao.admin.IFwUserDao;
import com.cpi.framework.web.entity.admin.FwPermissions;
import com.cpi.framework.web.entity.admin.FwRoles;
import com.cpi.framework.web.entity.admin.FwUser;

public class ShiroCasRealm extends CasRealm {

	private static Logger log = LoggerFactory.getLogger(ShiroCasRealm.class);

	@Resource(name = "FwUserDaoImpl")
	private IFwUserDao fwUsernDao;


	@Override
	protected AuthenticationInfo doGetAuthenticationInfo(
			AuthenticationToken token) throws AuthenticationException {
		CasToken casToken = (CasToken) token;
		if (token == null) {
			return null;
		}

		String ticket = (String) casToken.getCredentials();
		if (!StringUtils.hasText(ticket)) {
			return null;
		}

		TicketValidator ticketValidator = ensureTicketValidator();

		try {
			// contact CAS server to validate service ticket
			Assertion casAssertion = ticketValidator.validate(ticket,
					getCasService());
			// get principal, user id and attributes
			AttributePrincipal casPrincipal = casAssertion.getPrincipal();
			String userId = casPrincipal.getName();
			log.debug(
					"Validate ticket : {} in CAS server : {} to retrieve user : {}",
					new Object[] { ticket, getCasServerUrlPrefix(), userId });

			Map<String, Object> attributes = casPrincipal.getAttributes();
			// refresh authentication token (user id + remember me)
			casToken.setUserId(userId);
			String rememberMeAttributeName = getRememberMeAttributeName();
			String rememberMeStringValue = (String) attributes
					.get(rememberMeAttributeName);
			boolean isRemembered = rememberMeStringValue != null
					&& Boolean.parseBoolean(rememberMeStringValue);
			if (isRemembered) {
				casToken.setRememberMe(true);
			}
			// create simple authentication info
			// List<Object> principals = CollectionUtils.asList(userId,
			// attributes);
			// PrincipalCollection principalCollection = new
			// SimplePrincipalCollection(principals, getName());
			FwUser user = fwUsernDao.findByLoginName(userId);
			if (user != null) {
				//this.setSession(CommonAttributes.SESSION_CURRENT_USER, user);
				PrincipalCollection principalCollection = new SimplePrincipalCollection(
						new Principal(user.getId(),user.getLogincode(),user.getUsername(),user.getOrgId().getId(),user.getCompanyId()), getName());
				return new SimpleAuthenticationInfo(principalCollection, ticket);
			} else {
				return null;
			}
		} catch (TicketValidationException e) {
			throw new CasAuthenticationException("Unable to validate ticket ["
					+ ticket + "]", e);
		}
	}

	/**
	 * Retrieves the AuthorizationInfo for the given principals (the CAS
	 * previously authenticated user : id + attributes).
	 * 
	 * @param principals
	 *            the primary identifying principals of the AuthorizationInfo
	 *            that should be retrieved.
	 * @return the AuthorizationInfo associated with this principals.
	 */
	@Override
	protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
		Principal principal = (Principal) principals.getPrimaryPrincipal();
		if (principal !=null) {
		    SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
		    FwUser fwUser = fwUsernDao.find(principal.getId());	
			if(fwUser!=null){
				for (FwRoles fwRole : fwUser.getFwRoles()) {
					info.addRole(String.valueOf(fwRole.getId()));
				}
				info.addStringPermissions(this.getPermissonCode(fwUser));
			}
			return info;
		}
		return null;
	}
	/**
	 * 获取用户权限
	 * @param fwUser
	 * @return
	 */
	private Set<String> getPermissonCode(FwUser fwUser){
		Set<String> fwPermissonCode=new HashSet<String>();
		if (fwUser != null) {
			Set<FwPermissions> fwPermissons = new HashSet<FwPermissions>();
			/**人员自己拥有的权限*/
			fwPermissons.addAll(fwUser.getFwPermissions());
			/**人员角色拥有的权限*/
			for (FwRoles role : fwUser.getFwRoles()) {
				fwPermissons.addAll(role.getFwPermissions());
			}
			/**人员岗位拥有的权限*/
		    fwPermissons.addAll(fwUser.getStId().getFwPermissions());
		    for (FwPermissions fwPermisson : fwPermissons) {
		    	fwPermissonCode.add(fwPermisson.getPermissionCode());
			}
		}
		return fwPermissonCode;
	}
	 /**
     * ShiroSession设置
     * 
     * @see 使用时直接用HttpSession.getAttribute(key)就可以取到
     */
    private void setSession(Object key, Object value) {
        Subject currentUser = SecurityUtils.getSubject();
        if (null != currentUser) {
            Session session = currentUser.getSession();
            if (null != session) {
                session.setAttribute(key, value);
            }
        }
    }
}
