package com.cpi.framework.web.service.admin;

import java.util.List;

import com.cpi.framework.service.jpa.IBaseService;
import com.cpi.framework.web.entity.admin.FwMenu;

/**
 * 系统菜单Dao层接口定义
 * 
 * @author BridgeBai
 */
public interface IFwMenuService extends IBaseService<FwMenu, Long> {

	/**
	 * 查询菜单信息
	 * @param menuId 菜单ID
	 * @return 菜单信息
	 */
	public FwMenu findMenu(Long menuId);
	
	/**
	 * 查询当前人员的子菜单信息
	 * @param pMenuId 符菜单ID
	 * @return 菜单信息
	 */
	public List<FwMenu> findChildMenus(Long pMenuId);


	
}
