package com.cpi.framework.web.service.admin;

import com.cpi.framework.dao.support.Pagination;
import com.cpi.framework.service.jpa.IBaseService;
import com.cpi.framework.web.entity.admin.FwDictionary;
import com.cpi.framework.web.entity.admin.FwDictionaryType;
/**
 * 数据字典类型Service层接口定义
 * @author BridgeBai
 *
 */
public interface IFwDictionaryTypeService extends IBaseService<FwDictionaryType, Long> {

	/**
	 * 功能 : 根据类型名称查询数据字典类型
	 * 开发：zwwang 2015-5-6 下午5:23:44
	 * @param typeName 数据字典类型名称
	 * @param rowStartIdxAndCount
	 * @return
	 */
	public Pagination<FwDictionaryType> findDictionaryTypeList(String typeName, int start, int limit);
	/**
	 * 功能 : 根据字典类型id查询字典类型记录
	 * 开发：zwwang 2015-5-6 下午6:25:13
	 * @param id 字典类型id
	 * @return
	 */
	public Pagination<FwDictionaryType> findDictionaryTypeById(Long id);
	
	/**
	 * 功能 : 保存数据字典类型
	 * 开发：zwwang 2015-5-7 下午2:55:28
	 * @param dictionaryType
	 */
	public void addDictionaryType(FwDictionaryType dictionaryType);
	
	/**
	 * 功能 : 修改数据字典类型
	 * 开发：zwwang 2015-5-7 下午2:58:33
	 * @param entity
	 */
	public void modifyDictionaryType(FwDictionaryType entity);
	/**
	 * 功能 : 保存数据字典类型对应的字典项
	 * 开发：zwwang 2015-5-7 下午3:00:48
	 * @param dictionary
	 * @param dicTypeIdDetai 数据字典类型id
	 */
	public void addDictionary(FwDictionary dictionary, Long dicTypeIdDetail);
		
}
