package com.cpi.framework.web.service.admin;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.cpi.framework.dao.support.Pagination;
import com.cpi.framework.service.jpa.IBaseService;
import com.cpi.framework.web.common.CombVO;
import com.cpi.framework.web.entity.admin.FwDictionary;

/**
 * 数据字典Service层接口定义
 * @author BridgeBai
 *
 */
public interface IFwDictionaryService extends IBaseService<FwDictionary, Long> {

	/**
	 * 查询类型编码下的所有数据字典信息
	 * @param dictTypeCode 类型编码
	 * @return
	 */
	public Set<FwDictionary> findDictionarys(String dictTypeCode);
	
	/**
	 * 查询类型编码下的所有数据字典信息
	 * @param dictTypeCode 类型编码
	 * @return
	 */
	public List<CombVO> findDictCombs(String dictTypeCode);
	/**
	 * 查询类型编码下的所有数据字典信息
	 * @param dictTypeCode 类型编码
	 * @return
	 */
	public Map<String,String> findDictMaps(String dictTypeCode);
	/**
	 * 功能 : 根据业务字典类型id查询对应的字典项
	 * 开发：zwwang 2015-5-6 下午7:22:17
	 * @param dicTypeId 业务字典类型id
	 * @param start
	 * @param limit
	 * @return
	 */
	public Pagination<FwDictionary> findDictionaryList(Long dicTypeId, int start, int limit);
	/**
	 * 功能 :根据字典项id查找子典项纪录
	 * 开发：zwwang 2015-5-6 下午8:28:53
	 * @param id 子典项id
	 * @return
	 */
	public Pagination<FwDictionary> findDictionaryById(Long id);
	/**
	 * 功能 : 级联更新字典项
	 * 开发：zwwang 2015-5-6 下午9:13:35
	 * @param entity
	 */
	public void updateDictionary(Long dicTypeIdDetail, FwDictionary entity);
	
	/**
	 * 功能 : 根据id删除字典项
	 * 开发：zwwang 2015-5-7 上午10:31:36
	 * @param ids
	 * @return
	 */
	public void removeDictionary(Long[] ids);
}
